package outputs

const (
	DefaultBatchSize      = 100
	DefaultThrottle       = 1000
	DefaultGoroutineCount = 1
)

type Config struct {
	Address  string `toml:"address"`
	User     string `toml:"user"`
	Password string `toml:"password"`

	Database  string `toml:"database"`
	TableName string `toml:"table_name"`

	MetricName string `toml:"metric_name"`

	BatchSize      int    `toml:"batch_size"`
	Throttle       int    `toml:"throttle"`
	PartitionCol   string `toml:"partition_col"`
	GoroutineCount int    `toml:"goroutine_count"`
}

func (c *Config) Revise() {
	if c.BatchSize == 0 {
		c.BatchSize = DefaultBatchSize
	}

	if c.Throttle == 0 {
		c.Throttle = DefaultThrottle
	}

	if c.GoroutineCount == 0 {
		c.GoroutineCount = DefaultGoroutineCount
	}
}
