//package bits.datasync.consumer_check;

import java.io.IOException;
import java.time.Duration;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.isolation.Plugins.ClassLoaderUsage;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.util.ConnectUtils;

public class TpConsumer {
	public static void main(String[] args) throws InterruptedException, ExecutionException, IOException{
		start(args);
//		readMessageFromTopic(args);
    }
	
	public static void start(String[] args) throws IOException, InterruptedException, ExecutionException {
		Map<String,String> paraMap = new HashMap<String,String>();
        for (String param: args) {
        	if(!param.startsWith("--") || !param.contains("=")) {
        		logn("parameter ["+param+"] with wrong format ,and it does not work");
        		
        	}else {
        		paraMap.put(param.substring(2).substring(0,param.substring(2).indexOf("=")).toLowerCase(), param.substring(2).substring(param.substring(2).indexOf("=")+1));
        	}
        }
        if (!validateParam(paraMap)) return;
        doWork(paraMap);
		
	}
	/**
	 * check the parameter
	 * @param paraMap
	 * @return
	 */
	public static boolean validateParam(Map<String,String> paraMap) {
        if(!paraMap.containsKey("connect_config")) {
        	logn("parameter error :connect_config must be input ");
        	showHelp();
        	return false;
        }
        if(!paraMap.containsKey("op")) {
        	logn("parameter error :op must be input ");
        	showHelp();
        	return false;
        }
        return true;
	}
	/**
	 * work branch
	 * @param paraMap
	 * @throws IOException
	 * @throws InterruptedException
	 * @throws ExecutionException
	 */
	public static void doWork(Map<String,String> paraMap) throws IOException, InterruptedException, ExecutionException {

		switch(paraMap.get("op").toLowerCase()) {
		case "1": //showtopicoffset
	        if(!paraMap.containsKey("topic")) {
	        	logn("parameter error :topic must be input when showtopicoffset");
	        	showHelp();
	        }else {
				showTopicOffset(paraMap);
	        }
			break;
		case "2"://readmsg
	        if(!paraMap.containsKey("topic")) {
	        	logn("parameter error :topic must be input when readmsg");
	        	showHelp();
	        }
	        else  {
            	String[] checkoffset = checkOffset(paraMap.get("offset"));
            	if("error".equals(checkoffset[0])) {
            		logn(checkoffset[1]);
            		showHelp();
            	}else {
                	readMessageFromTopic(paraMap);
            	}
        	}
			break;
		case "3"://showconsumergroup
        	showConsumerGroups(paraMap);
        	break;
		case "4"://showconsumeroffset
			if(!paraMap.containsKey("group_id")|| paraMap.get("group_id")==null) {
        		logn("parameter error :when showconsumeroffset , group_id is must");
        		showHelp();
			}else {
				showConsumerOffset(paraMap);
			}
        	break;
		default:
        	logn("parameter error :wrong parameter  [op]");
        	showHelp();
			break;
		}
	}

	
	
	public static void readMessageFromTopic(Map<String,String> paraMap ) throws IOException {
        String workerPropsFile = paraMap.get("connect_config");
        Map<String, String> workerProps = !workerPropsFile.isEmpty() ?
                Utils.propsToStringMap(Utils.loadProps(workerPropsFile)) : Collections.<String, String>emptyMap();

        Properties properties = createKcProp(workerProps);
        properties.put("group.id", "_datasync_check_consumer");
        
        
        //check and set offset
        String[] checkoffset = null; 
    	if(paraMap.containsKey("offset")) {
        	 checkoffset = checkOffset(paraMap.get("offset"));
        	if("type".equals(checkoffset[0])) {
            	properties.put("auto.offset.reset", paraMap.get("offset"));
        	}
    	}else {
            properties.put("auto.offset.reset", "earliest");
    	}
        //set the msg read count
        int max_read_num = -1;
        if(paraMap.containsKey("max-messages")) {
        	max_read_num = Integer.valueOf(paraMap.get("max-messages"));
        }
    	
        properties.put("max.poll.records", "15000");
        properties.put("max.partition.fetch.bytes", "31457280");
        if(max_read_num!=-1 && max_read_num<15000) {
            properties.put("max.poll.records", max_read_num);
        }
        
        //load plugin
        Plugins plugins = new Plugins(workerProps); 
        plugins.compareAndSwapWithDelegatingLoader();
        DistributedConfig config = new DistributedConfig(workerProps);
        Converter keyConverter =plugins.newConverter(config, "key.converter", ClassLoaderUsage.PLUGINS);
        Converter valueConverter =plugins.newConverter(config, "value.converter", ClassLoaderUsage.PLUGINS);
        HeaderConverter headerConverter =plugins.newHeaderConverter(config, WorkerConfig.HEADER_CONVERTER_CLASS_CONFIG, ClassLoaderUsage
                .PLUGINS);

        //key filter
        String [] keyfilter = null;
        if(paraMap.containsKey("keyfilter")) {
        	keyfilter = paraMap.get("keyfilter").split(",");
        }
        
        
        KafkaConsumer<byte[], byte[]> consumer =new KafkaConsumer<>(properties);
        int partition = 0;
        if(paraMap.containsKey("partition")) {
        	partition = Integer.valueOf(paraMap.get("partition"));
        }
        List<TopicPartition> list = new ArrayList<TopicPartition>();
        TopicPartition tp =new TopicPartition(paraMap.get("topic"), partition);
        list.add(tp);
    	consumer.assign(list);

    	if(paraMap.containsKey("offset") && "seek".equals(checkoffset[0])) {
            consumer.seek(tp, Integer.valueOf(paraMap.get("offset")));
    	}

        int msg_num = 0 ;
        while (max_read_num == -1 || msg_num < max_read_num) {
    	ConsumerRecords<byte[], byte[]> msgs = consumer.poll(Duration.ofMillis(1000));
//    	logn(msgs.count());

	        for (ConsumerRecord<byte[], byte[]> record : msgs) {
	        	if(max_read_num != -1 && msg_num > max_read_num) {
	        		break;
	        	}
	        	if(msg_num>0 &&msg_num%100000 ==0) {
	        		logn("Has consumer " + msg_num + " message");
	        	}
	            SchemaAndValue keyAndSchema =keyConverter.toConnectData(record.topic(), record.key());
	            SchemaAndValue valueAndSchema =valueConverter.toConnectData(record.topic(), record.value());
	            Headers headers =  convertHeadersFor(record,headerConverter);

	            Long timestamp = ConnectUtils.checkAndConvertTimestamp(record.timestamp());
	            SinkRecord origRecord = new SinkRecord(record.topic(), record.partition(),
	                    keyAndSchema.schema(), keyAndSchema.value(),
	                    valueAndSchema.schema(), valueAndSchema.value(),
	                    record.offset(),
	                    timestamp,
	                    record.timestampType(),
	                    headers); //headers


	            if(keyfilter!=null) {
            		if (origRecord.key()!=null&&!keyCheck(keyfilter,origRecord.key().toString())) {
        		        msg_num++;
                	    continue;
            		}
	            }
	        	logn("-----------------------------------------------------------------------------------------------------------------------------------");

	    		logn("offset:"+origRecord.kafkaOffset());
	            logn(headers);
				showRecordValue(origRecord);
				showHeadAndSchema(headers,keyAndSchema,valueAndSchema);
		        msg_num++;
	        }
        }
        consumer.close();
        System.exit(0);
	}
	private static void showRecordValue(SinkRecord record) {
		logn("key:"+record.key());
		String op = null;
        if(record.valueSchema()!=null) {
    		final Struct valueStruct = (Struct) record.value();
    		for( Field f : record.valueSchema().fields()) {
    			logn(f.name()+":"+valueStruct.get(f));
    			if(f.name().contentEquals("op")) {
    				op = valueStruct.get(f).toString();
    			}
    		}
        }else {
        	op = "tombstone data";
        	logn("op:tombstone data");
        	logn("value And ValueSchema are null");
        }

        if("d".equals(op)) {
        	logn("field list :"+record.valueSchema().fields().get(0).schema().fields());
        }

        if("c".contentEquals(op)||"u".contentEquals(op)) {
        	logn("field list :"+record.valueSchema().fields().get(1).schema().fields());
        }
	}

    private static void showHeadAndSchema(Headers headers,SchemaAndValue keyAndSchema,SchemaAndValue valueAndSchema) {
    	logn("");
    	logn("@schema-info@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
        logn("key_schema_name:"+keyAndSchema.schema().name());
        logn("key_schema_version:"+keyAndSchema.schema().version());
        logn(keyAndSchema.schema().fields());

        if(valueAndSchema.schema()!=null) {
            logn("value_schema_name:"+valueAndSchema.schema().name());
            logn("value_schema_version:"+valueAndSchema.schema().version());
            logn(valueAndSchema.schema().fields());
//        	logn("@@@show schema end ");
        }else {
        	logn("value_schema is null");
        }
    }
    /**
     * convertheader
     * @param record
     * @param headerConverter
     * @return
     */
    private static Headers convertHeadersFor(ConsumerRecord<byte[], byte[]> record,HeaderConverter headerConverter) {
        Headers result = new ConnectHeaders();
        org.apache.kafka.common.header.Headers recordHeaders = record.headers();
        if (recordHeaders != null) {
            String topic = record.topic();
            for (org.apache.kafka.common.header.Header recordHeader : recordHeaders) {
                SchemaAndValue schemaAndValue = headerConverter.toConnectHeader(topic, recordHeader.key(), recordHeader.value());
                result.add(recordHeader.key(), schemaAndValue);
            }
        }
        return result;
    }
    /**
     * create consumer
     * @param workerProps
     * @return
     * @throws IOException
     */
	public static Properties createKcProp(Map<String,String> workerProps) throws IOException {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", workerProps.get("bootstrap.servers").toString());
//        properties.put("bootstrap.servers","192.168.174.129:9092");
        properties.put("enable.auto.commit", "false");
        properties.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        properties.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");

    	for(Map.Entry<String, String> entry : workerProps.entrySet()){
    		if(entry.getKey().startsWith("consumer")) {
    			properties.put(entry.getKey().substring(9),  entry.getValue());
    		}
    	}
        return properties;
	}
    public static boolean keyCheck(String[] keyFilter, String keyStr) {
    	boolean result =true;
    	for(String key :keyFilter) {
    		if(!keyStr.contains(key)) {
    			result = false;
    		}
    	}
    	return result;
    }
	public static String[] checkOffset(String offset) {
		String[] result = new String[2];
		if(offset==null) {
			result[0] = "default";
			result[1] = "latest";
		}else if("latest".equals(offset) || "earliest".equals(offset)) {
			result[0] = "type";
			result[1] = offset;
		}else {
			try {// need locate the start position
				Integer.parseInt(offset);
				result[0] = "seek";
				result[1] = offset;
			}catch(Exception e) {
				result[0] = "error";
				result[1] = "parameter error : wrong parameter [offset]";
				return result;
			}
		}
		return result;
	}

	public static void showHelp() {
        String system = System.getProperty("os.name");
        if(system.toLowerCase().contains("windows")) {
    		logn("options influde:(config like this  --op=readmsg ,the '=' is  essential)");
    		logn("--connect_config             please set the config of kafka-connect");
    		logn("--op                              {1-showtopicoffset,2-readmsg,3-showconsumergroup,4-showconsumeroffset}");
    		logn("                                    showtopicoffset: will show the first and end offset of topic");
    		logn("                                    readmsg will read the msg of the topic,support filter by primay key");
    		logn("                                    showconsumergroup will show the consumer groups");
    		logn("                                    showconsumeroffset will show the consumer group's offset ");
    		logn("--topic                           topic name ");
    		logn("--partition                      partition, default is 0");
    		logn("--max-messages             when read msg ,the maximum amount of data consumed, if not specified, continue to consume ");
    		logn("--offset                          {lastest,earliest} or really offset(should be int)  default lastest, will read msg by this position");
    		logn("--keyfilter                       used for filter the primay key ,example:  --keyfilter=2111,222 ");
    		logn("--group_id                       when showconsumeroffset,the group_id is must");
        }else {
    		logn("options influde:(config like this  --op=readmsg ,the '=' is  essential)");
    		logn("--connect_config               please set the config of kafka-connect");
    		logn("--op                           {1-showtopicoffset,2-readmsg,3-showconsumergroup,4-showConsumerOffset}");
    		logn("                               showtopicoffset: will show the first and end offset of topic");
    		logn("                               readmsg will read the msg of the topic,support filter by primay key");
    		logn("                               showconsumergroup will show the consumer groups");
    		logn("                               showconsumeroffset will show the consumer group's offset ");
    		logn("--topic                        topic name ");
    		logn("--partition                    partition, default is 0");
    		logn("--max-messages                 when read msg ,the maximum amount of data consumed, if not specified, continue to consume ");
    		logn("--offset                       {lastest,earliest} or really offset(should be int)  default lastest, will read msg by this position");
    		logn("--keyfilter                    used for filter the primay key , example:  --keyfilter=2111,222 ");
    		logn("--group_id                     when showconsumeroffset,the group_id is must");

        }
	}


	public static void showTopicOffset(Map<String,String> paraMap) throws IOException {
        String workerPropsFile = paraMap.get("connect_config");
        Map<String, String> workerProps = !workerPropsFile.isEmpty() ?
                Utils.propsToStringMap(Utils.loadProps(workerPropsFile)) : Collections.<String, String>emptyMap();

        Properties properties = createKcProp(workerProps);

        KafkaConsumer<String, String> kc = new KafkaConsumer<>(properties);
//        int partition = 0;
//        if(paraMap.containsKey("partition")) {
//        	partition = new Integer(paraMap.get("partition"));
//        }

		List<PartitionInfo> partitionInfoList = kc.partitionsFor(paraMap.get("topic"));
		List<TopicPartition> list = partitionInfoList.stream().map(partitionInfo -> new TopicPartition(partitionInfo.topic(), partitionInfo.partition()))
				.collect(Collectors.toList());

		Map<TopicPartition,Long> start_offset =kc.beginningOffsets(list);
        Map<TopicPartition,Long> end_offset =kc.endOffsets(list);

		list.stream().filter(tp -> !paraMap.containsKey("partition") || String.valueOf(tp.partition()).equals(paraMap.get("partition")))
				.sorted(Comparator.comparingInt(TopicPartition::partition)).map(tp -> "topic_partition :" + tp.toString() + "  fisrt offset  : " + start_offset.get(tp) + ", end offset  : " + end_offset.get(tp))
				.forEach(TpConsumer::logn);
        kc.close();
	}
	
    public static void showConsumerGroups(Map<String,String> paraMap) throws IOException {
        String workerPropsFile = paraMap.get("connect_config");
        Map<String, String> workerProps = !workerPropsFile.isEmpty() ?
                Utils.propsToStringMap(Utils.loadProps(workerPropsFile)) : Collections.<String, String>emptyMap();
                
        Properties properties = createKcProp(workerProps);
        AdminClient client = AdminClient.create(properties);
        ListConsumerGroupsResult lcg = client.listConsumerGroups();

	   	Collection<ConsumerGroupListing> kc;
		try {
			kc = lcg.all().get();
		   	kc.forEach((cg)->{
			   		logn(cg.groupId());
		   	});
		} catch (InterruptedException e) {
			e.printStackTrace();
		} catch (ExecutionException e) {
			e.printStackTrace();
		}
    }

    public static void showConsumerOffset(Map<String,String> paraMap) throws IOException, InterruptedException, ExecutionException {
        String workerPropsFile = paraMap.get("connect_config");
        Map<String, String> workerProps = !workerPropsFile.isEmpty() ?
                Utils.propsToStringMap(Utils.loadProps(workerPropsFile)) : Collections.<String, String>emptyMap();
                
        Properties properties = createKcProp(workerProps);
        AdminClient client = AdminClient.create(properties);
        
    	ListConsumerGroupOffsetsResult  lcgor =client.listConsumerGroupOffsets(paraMap.get("group_id"));
    	logn("");
    	logn("consumer_group -> "+paraMap.get("group_id") +"'s  offsets :");
    	logn("");
		Map<TopicPartition, OffsetAndMetadata> offset =lcgor.partitionsToOffsetAndMetadata().get();
		for(Map.Entry<TopicPartition, OffsetAndMetadata> entry:offset.entrySet() ) {
			if(paraMap.containsKey("topic") && paraMap.get("topic")!=null) {
				if(entry.toString().startsWith(paraMap.get("topic"))){
					
					logn(entry.getKey() + " current_offset : "+entry.getValue().offset());
				}
			}else {
				logn(entry.toString());
			}
		}
    }
    public static void logn(String str) {
    	System.out.println(str);
    }
    public static void log(String str) {
    	System.out.print(str);
    }

    public static void log(Object obj) {
    	if(obj!=null) {
        	System.out.print(obj.toString());
    	}else {
        	System.out.print("null");
    	}
    }
    public static void logn(Object obj) {
    	if(obj!=null) {
        	System.out.println(obj.toString());
    	}else {
        	System.out.print("null");
    	}
    }
}
