#!/bin/bash

# kafka download : wget https://www-eu.apache.org/dist/kafka/2.3.0/kafka_2.11-2.3.0.tgz
# confluent download :  wget http://packages.confluent.io/archive/5.3/confluent-community-5.3.1-2.12.tar.gz

parentPath=$(dirname $(pwd))
config_file=$parentPath/config/config.properties
kafka_home=`more $config_file |egrep '^kafka_home'|awk -F= 'END {print $2}'`
confluent_home=`more $config_file |egrep '^confluent_home'|awk -F= 'END {print $2}'`
connect_config=`more $config_file |egrep '^connect_config'|awk -F= 'END {print $2}'`

kafka_lib_path=$kafka_home/libs
confluent_java_path=$confluent_home/share/java
schema_registry_path=$confluent_java_path/schema-registry
kafka_serde_tools_path=$confluent_java_path/kafka-serde-tools
confluent_common_path=$confluent_java_path/confluent-common


java_path=.:$kafka_lib_path/*:$schema_registry_path/*:$kafka_serde_tools_path/*:$confluent_common_path/*:$parentPath/class/

javac -cp $java_path -d $parentPath/class/ $parentPath/src/TpConsumer.java
java -cp $java_path TpConsumer --connect_config=${connect_config}  $*
