#!/bin/bash

parentPath=$(dirname $(pwd))
config_file=$parentPath/config/config.properties
connect_rest_url=`more $config_file |egrep '^connect_rest_url'|awk -F= 'END {print $2}'`
rest_pd=`more $config_file |egrep '^rest_pd'|awk -F= 'END {print $2}'`


curl_delete() {
    curl -u ${rest_pd}  -X DELETE $connect_rest_url/connectors/$1
}

curl_conn_create() {
    curl -u ${rest_pd} -i -X POST -H "Accept:application/json" -H  "Content-Type:application/json" http://$connect_rest_url/connectors/ -d $1
}

curl_conn_status(){
    curl -u ${rest_pd} -X GET $connect_rest_url/connectors/$1/status
}

curl_get_config(){
    curl -u ${rest_pd} -X GET $connect_rest_url/connectors/$1/config
}
curl_conn_alter(){
    curl -u ${rest_pd} -i -X PUT -H "Accept:application/json" -H  "Content-Type:application/json" http://$connect_rest_url/connectors/$1/config -d $2
}

curl_task_restart(){
    curl -u ${rest_pd} -i -X POST http://$connect_rest_url/connectors/$1/tasks/$2/restart
}

curl_conn_pause(){
    curl -u ${rest_pd} -i -X PUT  http://$connect_rest_url/connectors/$1/pause
}
curl_conn_resume(){
    curl -u ${rest_pd} -i -X PUT  http://$connect_rest_url/connectors/$1/resume
}
curl_conn_restart(){
    echo 'restart connect ' $1
    curl -u ${rest_pd} -i -X POST http://$connect_rest_url/connectors/$1/restart
}

topic_operation(){
    $kafka_home/bin/kafka-topics.sh --zookeeper $zook_host:$zook_ip $1 $2 $3
}
kafka_showall(){
   _list=`curl -u ${rest_pd} -X GET $connect_rest_url/connectors/`
   _l1=${_list%?}
   _l2=${_l1:1}
   _str=${_l2//\",\"/ }
   for x in ${_str//\"/}
do
   echo -e "\n"
   echo "curl -u user:password-X GET $connect_rest_url/connectors/$x/status"
   curl -u ${rest_pd} -X GET $connect_rest_url/connectors/$x/status
done

}
kfk_tools(){
    $kafka_home/bin/kafka-run-class.sh kafka.tools.GetOffsetShell --broker-list $connect_rest_url  --topic $1 --time -1 
}

kfk_consumer(){
    $kafka_home/bin/kafka-console-consumer.sh --bootstrap-server $connect_rest_url --topic $1 --from-beginning
}

alias curl_clist='curl -H "Accept:application/json" $connect_rest_url/connectors/'
alias curl_del=curl_delete
alias curl_create=curl_conn_create
alias curl_status=curl_conn_status
alias curl_alter=curl_conn_alter
alias curl_t_restart=curl_task_restart
alias curl_c_restart=curl_conn_restart
alias tpc=topic_operation
alias kafka_offset=kfk_tools
alias kafka_consumer=kfk_consumer

showhelp(){
 echo 'Usage: connect_rest [options]'
 echo '  create            create connector,example:  ./kafka_rest create @source.json'
 echo '  list              show connector list  ' 
 echo '  showall           show all the connectors'' status' 
 echo '  status            show connector status,eg: ./kafka_rest status ${connector_name}' 
 echo '  get_config        show the config of connector,eg ./kafka_rest get_config ${connector_name}' 
 echo '  delete            delete the connector,eg:./kafka_rest delete ${connector_name}' 
 echo '  t_restart         use for restart the task after the task run failed,eg:./kafka_rest t_restart ${connector_name} ${task_id} ' 
 echo '  c_pause           use for pause the connector,eg:./kafka_rest c_pause ${connector_name}' 
 echo '  c_resume          use for resume the connector who is paused,eg:./kafka_rest ${connector_name}' 
 echo '  c_alter           use for modify the config of connector,eg:./kafka_rest c_alter ${connector_name} @source_config.json' 
 echo '                    Pay attention the modify config is different with create config '
 echo '  c_restart         use for restart the connector,eg:./kafka_rest c_restart ${connector_name}' 
 echo '                    if the connector is running,task is failed please use t_restart'
 echo '  help              show the use help' 
}

main(){
 if [ $# -eq 0 ];then
    showhelp
    exit 0
 fi
 if [ $1 = 'list' ];then
    curl -u ${rest_pd} -H "Accept:application/json" $connect_rest_url/connectors/
 elif [ $1 = 'create' ];then
    curl_conn_create $2  
 elif [ $1 = 'status' ];then
    curl_conn_status $2
 elif [ $1 = 'get_config' ];then
    curl_get_config $2
 elif [ $1 = 'delete' ];then
    curl_delete $2
 elif [ $1 = 't_restart' ];then
    curl_task_restart $2 $3
 elif [ $1 = 'c_pause' ];then
    curl_conn_pause $2 
 elif [ $1 = 'c_resume' ];then
    curl_conn_resume $2 
 elif [ $1 = 'c_alter' ];then
    curl_conn_alter $2 $3
 elif [ $1 = 'c_restart' ];then
    curl_conn_restart $2
 elif [ $1 = 'showall' ];then
    kafka_showall
 elif [ $1 = 'help' ];then
    showhelp
 fi
}
#echo $1
main $1 $2 $3
