#!/bin/bash

parentPath=$(dirname $(pwd))
config_file=$parentPath/config/config.properties
kafka_home=`more $config_file |egrep '^kafka_home'|awk -F= 'END {print $2}'`
bootstrap_server=`more $config_file |egrep '^bootstrap_server'|awk -F= 'END {print $2}'`
command_config=`more $config_file |egrep '^command_config'|awk -F= 'END {print $2}'`
#===================
# append  kafka_args
kafka_args=""
if [ -n "${bootstrap_server}" ]; then
  kafka_args=$kafka_args"--bootstrap-server ${bootstrap_server} "
fi
if [ -n "${command_config}" ]; then
  kafka_args=$kafka_args"--command-config ${command_config} "
fi
#echo 'args is '  ${kafka_args}
#===================

#${kafka_home}/bin/kafka-topics.sh --list --bootstrap-server ${bootstrap_server} --command-config ${kf_cmd}
#${kafka_home}/bin/kafka-topics.sh --list  $kafka_args
#${kafka_home}/bin/kafka-topics.sh --list --bootstrap-server ${bootstrap_server} 

showhelp(){
 echo 'Usage: kafka.sh [options]'
 echo 'tplist                          List the topics available in the cluster' 
 echo 'tp_detail                       show topic detail ' 
 echo 'cm_list                         List the consumer available in the cluster' 
 echo 'cm_member                       Show the consumer assgine info' 
 echo 'cm_detail                       Show the consumer detail' 
 echo 'tp_delete                       Delete the special topic' 
 echo 'tp_delete_match                 Delete the match topic' 
 echo 'get_offsets                     get the partition offsets' 
 echo 'config                          show config infomation' 
}
function showConfigInfo(){
  echo 'parentPath'=${parentPath}
  echo 'config_file'=${config_file}
  echo 'kafka_home'=${kafka_home}
  echo 'bootstrap_server'=${bootstrap_server}
  echo 'command_config'=${command_config}	
  echo 'kafka_args'=${kafka_args}
}

function tplist(){
 ${kafka_home}/bin/kafka-topics.sh --list  $kafka_args
}
function tp_detail(){
 ${kafka_home}/bin/kafka-topics.sh  $kafka_args --topic $1 --describe
}

function tp_create(){
 ${kafka_home}/bin/kafka-topics.sh  $kafka_args --topic $1 --create -replication-factor 1 --partitions 1
}
function tp_delete(){
 ${kafka_home}/bin/kafka-topics.sh  $kafka_args --topic $1 --delete
}
function tp_delete_match(){
   #for item in `${kafka_home}/bin/kafka-topics.sh --list  $kafka_args` 
   for item in `tplist | egrep $1`
      do
         echo 'start to delete topic:' ${item}
         tp_delete ${item}
      done
# ${kafka_home}/bin/kafka-topics.sh  $kafka_args --topic $1 ----delete
}

function consumer_list(){
 ${kafka_home}/bin/kafka-consumer-groups.sh  $kafka_args --list
}
function consumer_member(){
 ${kafka_home}/bin/kafka-consumer-groups.sh  $kafka_args --describe --group $1 --members --verbose
}
function consumer_detail(){
 ${kafka_home}/bin/kafka-consumer-groups.sh  $kafka_args --describe --group $1
}
function get_offsets(){
   v_partition=0
   if [ ! -z "$2" ]; then
	  v_partition=$2
   fi
   v_time=-1
   if [ ! -z "$3" ]; then
	  v_time=$3
   fi
  ${kafka_home}/bin/kafka-get-offsets.sh  $kafka_args --topic $1  --partitions $v_partition --time $v_time
}

main(){
  if [ $# -eq 0 ];then
    showhelp
    exit 0
  fi
  if [ $1 = 'tplist' ];then
     tplist
  elif [ $1 = 'tp_detail' ];then
     tp_detail $2
  elif [ $1 = 'tp_create' ];then
     tp_create $2
  elif [ $1 = 'tp_delete' ];then
     tp_delete $2
  elif [ $1 = 'tp_delete_match' ];then
     tp_delete_match $2
  elif [ $1 = 'cm_list' ];then
     consumer_list
  elif [ $1 = 'cm_member' ];then
     consumer_member $2
  elif [ $1 = 'cm_detail' ];then
     consumer_detail $2
  elif [ $1 = 'get_offsets' ];then
     get_offsets $2 $3 $4
  elif [ $1 = 'help' ];then
     showhelp
  elif [ $1 = 'config' ];then
     showConfigInfo
 fi

}

main $*
