#!/bin/bash

parentPath=$(dirname $(pwd))
config_file=$parentPath/config/config.properties
kafka_home=`more $config_file |egrep '^kafka_home'|awk -F= 'END {print $2}'`
confluent_home=`more $config_file |egrep '^confluent_home'|awk -F= 'END {print $2}'`
bootstrap_server=`more $config_file |egrep '^bootstrap_server'|awk -F= 'END {print $2}'`
command_config=`more $config_file |egrep '^command_config'|awk -F= 'END {print $2}'`
schema_ip=`more $config_file |egrep '^schema_ip'|awk -F= 'END {print $2}'`
schema_port=`more $config_file |egrep '^schema_port'|awk -F= 'END {print $2}'`
schema_url=http://${schema_ip}:${schema_port}
#echo ${schema_url}

#===================
# append  kafka_args
kafka_args=""
if [ -n "${bootstrap_server}" ]; then
  kafka_args=$kafka_args"--bootstrap-server ${bootstrap_server} "
fi
if [ -n "${command_config}" ]; then
  kafka_args=$kafka_args"--command-config ${command_config} "
fi
echo 'args is '  ${kafka_args}
#===================

#${kafka_home}/bin/kafka-topics.sh --list --bootstrap-server ${bootstrap_server} --command-config ${kf_cmd}
#${kafka_home}/bin/kafka-topics.sh --list  $kafka_args
#${kafka_home}/bin/kafka-topics.sh --list --bootstrap-server ${bootstrap_server} 

showhelp(){
 echo 'Usage: kafka.sh [options]'
 echo 'config                          show config infomation' 
}
function showConfigInfo(){
  echo 'parentPath'=${parentPath}
  echo 'config_file'=${config_file}
  echo 'kafka_home'=${kafka_home}
  echo 'bootstrap_server'=${bootstrap_server}
  echo 'command_config'=${command_config}	
  echo 'kafka_args'=${kafka_args}
}

function consume(){
${confluent_home}/bin/kafka-avro-console-consumer \
    $kafka_args \
    --property schema.registry.url=${schema_url} \
    --property print.value=true \
    --property print.key=true \
    --property print.offset=true \
    --property value.deserializer=io.confluent.kafka.serializers.KafkaAvroDeserializer \
    $@
   # --topic $1  \
   # --from-beginning
   # --bootstrap-server $kafka_args \
}
function consume2(){
${kafka_home}/bin/kafka-console-consumer.sh \
   $kafka_args \
    --property print.value=true \
    --property print.key=true \
    --property print.offset=true \
    $@
}
function consumer_detail(){
 ${kafka_home}/bin/kafka-consumer-groups.sh  $kafka_args --describe --group $1
}
function get_offsets(){
   v_partition=0
   if [ ! -z "$2" ]; then
	  v_partition=$2
   fi
   v_time=-1
   if [ ! -z "$3" ]; then
	  v_time=$3
   fi
  ${kafka_home}/bin/kafka-get-offsets.sh  $kafka_args --topic $1  --partitions $v_partition --time $v_time
}

main(){
  if [ $# -eq 0 ];then
    showhelp
    exit 0
  fi
  consume2 $@
}

main $*
