/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.kafka.common.config.AbstractConfig;

public abstract class DatabaseDialectProvider {
    private final String name;
    public static final int NO_MATCH_SCORE = 0;
    public static final int AVERAGE_MATCHING_SCORE = 10;
    public static final int EXCELLENT_MATCHING_SCORE = 100;

    protected DatabaseDialectProvider(String name) {
        assert (name != null);
        this.name = name;
    }

    public abstract int score(JdbcUrlInfo var1);

    public abstract DatabaseDialect create(AbstractConfig var1);

    public String dialectName() {
        return this.name;
    }

    public String toString() {
        return this.dialectName();
    }

    public static abstract class FixedScoreProvider
    extends DatabaseDialectProvider {
        private final int score;

        protected FixedScoreProvider(String name, int score) {
            super(name);
            this.score = score;
        }

        @Override
        public int score(JdbcUrlInfo jdbcInfo) {
            return this.score;
        }
    }

    public static abstract class SubprotocolBasedProvider
    extends DatabaseDialectProvider {
        private final Set<String> subprotocols;

        protected SubprotocolBasedProvider(String name, String ... subprotocols) {
            this(name, Arrays.asList(subprotocols));
        }

        protected SubprotocolBasedProvider(String name, Collection<String> subprotocols) {
            super(name);
            this.subprotocols = new HashSet<String>(subprotocols);
        }

        @Override
        public int score(JdbcUrlInfo urlInfo) {
            if (urlInfo != null) {
                for (String subprotocol : this.subprotocols) {
                    if (!subprotocol.equalsIgnoreCase(urlInfo.subprotocol())) continue;
                    return 100;
                }
                Object combined = urlInfo.subprotocol() + ":" + urlInfo.subname();
                combined = ((String)combined).toLowerCase(Locale.getDefault());
                for (String subprotocol : this.subprotocols) {
                    if (!((String)combined).startsWith(subprotocol.toLowerCase(Locale.getDefault()))) continue;
                    return 100;
                }
            }
            return 0;
        }
    }

    public static interface JdbcUrlInfo {
        public String subprotocol();

        public String subname();

        public String url();
    }
}

