/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.io;

import com.xxdb.io.ExtendedDataInput;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public abstract class AbstractExtendedDataInputStream
extends BufferedInputStream
implements ExtendedDataInput {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int UTF8_STRING_LIMIT = 65536;
    private byte[] buf_;

    protected AbstractExtendedDataInputStream(InputStream in) {
        super(in, 8192);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int read;
        do {
            read = super.read(b, off, len);
            off += read;
        } while ((len -= read) > 0);
    }

    @Override
    public String readLine() throws IOException {
        return this.readUTF8((byte)10);
    }

    @Override
    public String readString() throws IOException {
        return this.readUTF8((byte)0);
    }

    private int isHaveEndBytes(byte endChar) {
        byte[] streamBuf = this.buf;
        for (int i = this.pos; i < this.count; ++i) {
            if (streamBuf[i] != endChar) continue;
            return i;
        }
        return -1;
    }

    private InputStream getInIfOpen() throws IOException {
        InputStream input = this.in;
        if (input == null) {
            throw new IOException("Stream closed");
        }
        return input;
    }

    private void fill() throws IOException {
        byte[] buffer = this.buf;
        this.pos = 0;
        this.count = 0;
        int n = this.getInIfOpen().read(buffer, this.pos, buffer.length - this.pos);
        if (n == -1) {
            throw new EOFException();
        }
        this.count = n;
    }

    private String readUTF8(byte terminator) throws IOException {
        if (this.buf_ == null) {
            this.buf_ = new byte[2048];
        }
        int bufPos = 0;
        while (true) {
            int terminatorPos;
            int dataCount;
            int n = dataCount = (terminatorPos = this.isHaveEndBytes(terminator)) == -1 ? this.count - this.pos : terminatorPos - this.pos + 1;
            if (dataCount + bufPos > this.buf_.length) {
                int bufferSize = Math.max(dataCount + bufPos, this.buf_.length * 2);
                byte[] tmp = new byte[bufferSize];
                System.arraycopy(this.buf_, 0, tmp, 0, this.buf_.length);
                this.buf_ = tmp;
            }
            System.arraycopy(this.buf, this.pos, this.buf_, bufPos, dataCount);
            bufPos += dataCount;
            this.pos += dataCount;
            if (terminatorPos != -1) break;
            this.fill();
        }
        return new String(this.buf_, 0, --bufPos, UTF8);
    }

    @Override
    public byte[] readBlob() throws IOException {
        int len = this.readInt();
        int actualSize = 0;
        byte[] buff = new byte[len];
        for (int offset = 0; offset < len; offset += actualSize) {
            actualSize = this.read(buff, offset, len - offset);
        }
        return buff;
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return new DataInputStream(this.in).readUTF();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int b1 = this.read();
        if (0 > b1) {
            throw new EOFException();
        }
        return b1;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int actualSkip = 0;
        for (int reamainSkip = n - actualSkip; reamainSkip > 0; reamainSkip -= actualSkip) {
            actualSkip = (int)this.skip(reamainSkip);
        }
        return actualSkip;
    }

    protected byte readAndCheckByte() throws IOException, EOFException {
        int b1 = this.read();
        if (-1 == b1) {
            throw new EOFException();
        }
        return (byte)b1;
    }

    protected int fromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    protected long fromBytes(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8) {
        return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
    }
}

