/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.temporal.Temporal;

public class BasicString
extends AbstractScalar
implements Comparable<BasicString> {
    private String value;
    private boolean isBlob = false;
    private byte[] blobValue;

    public BasicString(String value) {
        this.value = value;
        this.isBlob = false;
    }

    public BasicString(String value, boolean blob) {
        if (blob) {
            this.blobValue = value.getBytes(StandardCharsets.UTF_8);
        } else {
            this.value = value;
        }
        this.isBlob = blob;
    }

    public BasicString(byte[] value, boolean isBlob) {
        if (isBlob) {
            this.blobValue = value;
        } else {
            this.value = new String(value, StandardCharsets.UTF_8);
        }
        this.isBlob = isBlob;
    }

    public BasicString(ExtendedDataInput in) throws IOException {
        this.isBlob = false;
        this.value = in.readString();
    }

    public BasicString(ExtendedDataInput in, boolean blob) throws IOException {
        if (blob) {
            this.blobValue = in.readBlob();
        } else {
            this.value = in.readString();
        }
        this.isBlob = blob;
    }

    @Override
    public String getString() {
        if (this.isBlob) {
            return new String(this.blobValue, StandardCharsets.UTF_8);
        }
        if (this.isNull()) {
            return "";
        }
        return this.value;
    }

    @JsonIgnore
    public byte[] getBytes() {
        if (this.isBlob) {
            return this.blobValue;
        }
        throw new RuntimeException("The value must be a string scalar. ");
    }

    public byte[] getBlobValue() {
        return this.blobValue;
    }

    protected void setString(String value) {
        if (this.isBlob) {
            this.blobValue = value.getBytes(StandardCharsets.UTF_8);
        } else {
            this.value = value;
        }
    }

    @Override
    public boolean isNull() {
        if (this.isBlob) {
            return this.blobValue.length == 0;
        }
        return this.value.length() == 0;
    }

    @Override
    public void setNull() {
        if (this.isBlob) {
            this.blobValue = new byte[0];
        } else {
            this.value = "";
        }
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.LITERAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        if (!this.isBlob) {
            return Entity.DATA_TYPE.DT_STRING;
        }
        return Entity.DATA_TYPE.DT_BLOB;
    }

    @Override
    @JsonIgnore
    public Number getNumber() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    @JsonIgnore
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicString) || o == null) {
            return false;
        }
        if (this.isBlob != ((BasicString)o).isBlob) {
            return false;
        }
        if (this.isBlob) {
            byte[] oValue = ((BasicString)o).blobValue;
            if (this.blobValue.length != oValue.length) {
                return false;
            }
            for (int i = 0; i < this.blobValue.length; ++i) {
                if (this.blobValue[i] == oValue[i]) continue;
                return false;
            }
        } else {
            return this.value.equals(((BasicString)o).value);
        }
        return true;
    }

    public int hashCode() {
        if (this.isBlob) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.blobValue.length; ++i) {
                stringBuilder.append((char)this.blobValue[i]);
            }
            return stringBuilder.toString().hashCode();
        }
        return this.value.hashCode();
    }

    @Override
    public int hashBucket(int buckets) {
        if (this.isBlob) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.blobValue.length; ++i) {
                stringBuilder.append((char)this.blobValue[i]);
            }
            return BasicString.hashBucket(stringBuilder.toString(), buckets);
        }
        return BasicString.hashBucket(this.value, buckets);
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return "\"" + this.getString() + "\"";
    }

    public static int hashBucket(String str, int buckets) {
        int length = str.length();
        int bytes = 0;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++bytes;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                bytes += 2;
                continue;
            }
            bytes += 3;
        }
        int h = bytes;
        if (bytes == length) {
            int length4 = bytes / 4;
            for (int i = 0; i < length4; ++i) {
                int i4 = i * 4;
                int k = (str.charAt(i4) & 0xFF) + ((str.charAt(i4 + 1) & 0xFF) << 8) + ((str.charAt(i4 + 2) & 0xFF) << 16) + ((str.charAt(i4 + 3) & 0xFF) << 24);
                k *= 1540483477;
                k ^= k >>> 24;
                h *= 1540483477;
                h ^= (k *= 1540483477);
            }
            switch (bytes % 4) {
                case 3: {
                    h ^= (str.charAt((bytes & 0xFFFFFFFC) + 2) & 0xFF) << 16;
                }
                case 2: {
                    h ^= (str.charAt((bytes & 0xFFFFFFFC) + 1) & 0xFF) << 8;
                }
                case 1: {
                    h ^= str.charAt(bytes & 0xFFFFFFFC) & 0xFF;
                    h *= 1540483477;
                }
            }
            h ^= h >>> 13;
            h *= 1540483477;
            h ^= h >>> 15;
        } else {
            int k = 0;
            int cursor = 0;
            for (int i = 0; i < length; ++i) {
                char c = str.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    k += c << 8 * cursor++;
                } else if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                    k += (0xC0 | 0x1F & c >> 6) << 8 * cursor++;
                    if (cursor == 4) {
                        k *= 1540483477;
                        k ^= k >>> 24;
                        h *= 1540483477;
                        h ^= (k *= 1540483477);
                        k = 0;
                        cursor = 0;
                    }
                    k += (0x80 | 0x3F & c) << 8 * cursor++;
                } else {
                    k += (0xE0 | 0xF & c >> 12) << 8 * cursor++;
                    if (cursor == 4) {
                        k *= 1540483477;
                        k ^= k >>> 24;
                        h *= 1540483477;
                        h ^= (k *= 1540483477);
                        k = 0;
                        cursor = 0;
                    }
                    k += (0x80 | 0x3F & c >> 6) << 8 * cursor++;
                    if (cursor == 4) {
                        k *= 1540483477;
                        k ^= k >>> 24;
                        h *= 1540483477;
                        h ^= (k *= 1540483477);
                        k = 0;
                        cursor = 0;
                    }
                    k += (0x80 | 0x3F & c) << 8 * cursor++;
                }
                if (cursor != 4) continue;
                k *= 1540483477;
                k ^= k >>> 24;
                h *= 1540483477;
                h ^= (k *= 1540483477);
                k = 0;
                cursor = 0;
            }
            if (cursor > 0) {
                h ^= k;
                h *= 1540483477;
            }
            h ^= h >>> 13;
            h *= 1540483477;
            h ^= h >>> 15;
        }
        if (h >= 0) {
            return h % buckets;
        }
        return (int)((0x100000000L + (long)h) % (long)buckets);
    }

    @Override
    public void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        if (this.isBlob) {
            this.writeScalarToOutputStream(out, true);
        } else {
            this.writeScalarToOutputStream(out, false);
        }
    }

    protected void writeScalarToOutputStream(ExtendedDataOutput out, boolean blob) throws IOException {
        if (!blob) {
            out.writeString(this.value);
        } else {
            out.writeBlob(this.blobValue);
        }
    }

    @Override
    public int compareTo(BasicString o) {
        if (this.isBlob) {
            return new String(this.blobValue, StandardCharsets.UTF_8).compareTo(o.value);
        }
        return this.value.compareTo(o.value);
    }

    @Override
    @JsonIgnore
    public int getScale() {
        return super.getScale();
    }
}

