/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractMatrix;
import com.xxdb.data.BasicDecimal64;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicLong;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class BasicDecimal64Matrix
extends AbstractMatrix {
    private long[] values;
    private static final long MIN_VALUE = Long.MIN_VALUE;
    private static final long MAX_VALUE = Long.MAX_VALUE;

    public BasicDecimal64Matrix(int rows, int columns, int scale) {
        super(rows, columns, scale);
        if (scale < 0 || scale > 18) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,18].");
        }
        this.values = new long[rows * columns];
    }

    public BasicDecimal64Matrix(int rows, int columns, List<?> listOfArrays, int scale) throws Exception {
        super(rows, columns);
        if (scale < 0 || scale > 18) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,18].");
        }
        this.scale = scale;
        this.values = new long[rows * columns];
        if (listOfArrays == null || listOfArrays.size() != columns) {
            throw new Exception("input list of arrays does not have " + columns + " columns");
        }
        for (int i = 0; i < columns; ++i) {
            Object[] newArray;
            Object array = listOfArrays.get(i);
            if (array instanceof String[]) {
                newArray = (String[])array;
                long[] tempArr = new long[newArray.length];
                if (newArray.length == 0 || newArray.length != rows) {
                    throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
                }
                for (int j = 0; j < newArray.length; ++j) {
                    BigDecimal bd = new BigDecimal(newArray[j]);
                    BigDecimal multipliedValue = bd.scaleByPowerOfTen(scale).setScale(0, RoundingMode.HALF_UP);
                    if (multipliedValue.longValue() <= Long.MIN_VALUE || multipliedValue.longValue() >= Long.MAX_VALUE) continue;
                    tempArr[j] = multipliedValue.longValue();
                }
                System.arraycopy(tempArr, 0, this.values, i * rows, rows);
                continue;
            }
            if (array instanceof long[]) {
                newArray = (long[])listOfArrays.get(i);
                if (newArray.length == 0 || newArray.length != rows) {
                    throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
                }
                for (int j = 0; j < newArray.length; ++j) {
                    newArray[j] = newArray[j] * (long)Math.pow(10.0, this.scale);
                }
                System.arraycopy(newArray, 0, this.values, i * rows, rows);
                continue;
            }
            throw new RuntimeException("BasicDecimal64Matrix 'listOfArrays' param only support String[] or long[].");
        }
    }

    public BasicDecimal64Matrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    @Override
    public boolean isNull(int row, int column) {
        return this.values[this.getIndex(row, column)] == Long.MIN_VALUE;
    }

    @Override
    public void setNull(int row, int column) {
        this.values[this.getIndex((int)row, (int)column)] = Long.MIN_VALUE;
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicDecimal64(this.scale, this.values[this.getIndex(row, column)]);
    }

    public void set(int row, int column, Entity value) {
        if (!value.getDataForm().equals((Object)Entity.DATA_FORM.DF_SCALAR) || value.getDataType() != Entity.DATA_TYPE.DT_DECIMAL64) {
            throw new RuntimeException("The value type is not BasicDecimal64!");
        }
        int newScale = ((Scalar)value).getScale();
        Entity.DATA_TYPE type = value.getDataType();
        if (this.scale < 0) {
            this.scale = newScale;
        }
        if (((Scalar)value).isNull()) {
            this.values[this.getIndex((int)row, (int)column)] = Long.MIN_VALUE;
        } else if (this.scale != newScale) {
            BigInteger newValue = type == Entity.DATA_TYPE.DT_LONG ? BigInteger.valueOf(((BasicLong)value).getLong()) : (type == Entity.DATA_TYPE.DT_INT ? BigInteger.valueOf(((BasicInt)value).getInt()) : BigInteger.valueOf(((BasicDecimal64)value).getLong()));
            BigInteger pow = BigInteger.valueOf(10L);
            if (newScale - this.scale > 0) {
                pow = pow.pow(newScale - this.scale);
                newValue = newValue.divide(pow);
            } else {
                pow = pow.pow(this.scale - newScale);
                newValue = newValue.multiply(pow);
            }
            this.values[this.getIndex((int)row, (int)column)] = newValue.longValue();
        } else {
            this.values[this.getIndex((int)row, (int)column)] = ((BasicDecimal64)value).getLong();
        }
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.DENARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DECIMAL64;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDecimal64.class;
    }

    @Override
    protected void readMatrixFromInputStream(int rows, int columns, ExtendedDataInput in) throws IOException {
        int len;
        int size = rows * columns;
        this.values = new long[size];
        long totalBytes = (long)size * 8L;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        this.scale = in.readInt();
        for (long off = 0L; off < totalBytes; off += (long)len) {
            len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = (int)(off / 8L);
            int end = len / 8;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getLong(i * 8);
            }
        }
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeInt(this.scale);
        out.writeLongArray(this.values);
    }
}

