/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicDate;
import com.xxdb.data.BasicIntMatrix;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;

public class BasicDateMatrix
extends BasicIntMatrix {
    public BasicDateMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public BasicDateMatrix(int rows, int columns, List<int[]> listOfArrays) throws Exception {
        super(rows, columns, listOfArrays);
    }

    public BasicDateMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setDate(int row, int column, LocalDate value) {
        this.setInt(row, column, Utils.countDays(value));
    }

    public LocalDate getDate(int row, int column) {
        return Utils.parseDate(this.getInt(row, column));
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicDate(this.getInt(row, column));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDate.class;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DATE;
    }
}

