/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicInt;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;

public class BasicDateHour
extends BasicInt {
    public BasicDateHour(LocalDateTime value) {
        super(Utils.countHours(value));
    }

    public BasicDateHour(Calendar value) {
        super(Utils.countHours(value));
    }

    public BasicDateHour(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public BasicDateHour(int value) {
        super(value);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DATEHOUR;
    }

    public LocalDateTime getDateHour() {
        if (this.isNull()) {
            return null;
        }
        return Utils.parseDateHour(this.getInt());
    }

    @Override
    public Temporal getTemporal() throws Exception {
        return this.getDateHour();
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        return this.getDateHour().format(DateTimeFormatter.ofPattern("yyyy.MM.dd'T'HH"));
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return "\"" + this.getString() + "\"";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BasicDateHour) || o == null) {
            return false;
        }
        return this.getInt() == ((BasicDateHour)o).getInt();
    }
}

