/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.dolphindb.jdbc.Driver;
import com.dolphindb.jdbc.JDBCConnection;
import com.dolphindb.jdbc.JDBCResultSetMetaData;
import com.dolphindb.jdbc.JDBCStatement;
import com.dolphindb.jdbc.TypeCast;
import com.dolphindb.jdbc.Utils;
import com.xxdb.data.BasicBoolean;
import com.xxdb.data.BasicByte;
import com.xxdb.data.BasicDate;
import com.xxdb.data.BasicDateHour;
import com.xxdb.data.BasicDateTime;
import com.xxdb.data.BasicDouble;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicFloat;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicLong;
import com.xxdb.data.BasicMinute;
import com.xxdb.data.BasicMonth;
import com.xxdb.data.BasicNanoTime;
import com.xxdb.data.BasicNanoTimestamp;
import com.xxdb.data.BasicSecond;
import com.xxdb.data.BasicShort;
import com.xxdb.data.BasicTable;
import com.xxdb.data.BasicTime;
import com.xxdb.data.BasicTimestamp;
import com.xxdb.data.Entity;
import com.xxdb.data.EntityBlockReader;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.sql.rowset.serial.SerialBlob;

public class JDBCResultSet
implements ResultSet {
    private final JDBCConnection conn;
    private final JDBCStatement statement;
    private BasicTable table;
    private int currentRow = -1;
    private int offsetRows;
    private int maxRows = -1;
    private int globalRows;
    private String tableName;
    private Entity tableNameArg;
    private List<Entity> arguments;
    private HashMap<String, Integer> findColumnHashMap;
    private int updateRow;
    private int insertRow;
    private HashMap<Integer, Entity> insertRowMap;
    private boolean isInsert;
    private boolean isClosed = false;
    private boolean isUpdatable = false;
    private Object o;
    private Entity entity;
    private EntityBlockReader reader;

    public JDBCResultSet(JDBCConnection conn, JDBCStatement statement, Entity entity, String sql) throws SQLException {
        this(conn, statement, entity, sql, -1);
    }

    public JDBCResultSet(JDBCConnection conn, JDBCStatement statement, Entity entity, String sql, int maxRows) throws SQLException {
        this.conn = conn;
        this.statement = statement;
        if (entity.isTable()) {
            if (maxRows > 0) {
                this.maxRows = maxRows;
                if (entity.rows() > this.maxRows) {
                    this.table = (BasicTable)((BasicTable)entity).getSubTable(0, this.maxRows - 1);
                    this.offsetRows = this.maxRows;
                } else {
                    this.table = (BasicTable)entity;
                    this.offsetRows = this.table.rows();
                }
            } else {
                this.table = (BasicTable)entity;
                this.offsetRows = this.table.rows();
            }
            this.findColumnHashMap = new HashMap(this.table.columns());
            for (int i = 0; i < this.table.columns(); ++i) {
                this.findColumnHashMap.put(this.table.getColumnName(i), i + 1);
            }
            this.isUpdatable = false;
            if (this.isUpdatable) {
                this.insertRowMap = new HashMap(this.table.columns() + 1);
            }
        } else {
            this.entity = entity;
            if (sql != null && sql.contains("select 1 as ")) {
                ArrayList<String> colNames = new ArrayList<String>(1);
                colNames.add(Utils.getSelectOneColName(sql));
                ArrayList<Vector> cols = new ArrayList<Vector>(1);
                BasicIntVector vector = new BasicIntVector(1);
                BasicInt scalar = new BasicInt(1);
                try {
                    vector.set(0, scalar);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                cols.add(vector);
                this.table = new BasicTable(colNames, cols);
                this.offsetRows = this.table.rows();
                this.findColumnHashMap = new HashMap(this.table.columns());
                for (int i = 0; i < this.table.columns(); ++i) {
                    this.findColumnHashMap.put(this.table.getColumnName(i), i + 1);
                }
                this.isUpdatable = false;
                if (this.isUpdatable) {
                    this.insertRowMap = new HashMap(this.table.columns() + 1);
                }
            }
        }
    }

    public JDBCResultSet(JDBCConnection conn, JDBCStatement statement, EntityBlockReader reader, String sql, int maxRows) throws SQLException {
        this.conn = conn;
        this.statement = statement;
        this.reader = reader;
        if (!reader.hasNext().booleanValue()) {
            throw new SQLException("ResultSet data is null");
        }
        BasicTable entity = null;
        try {
            entity = (BasicTable)reader.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (entity.isTable()) {
            if (maxRows > 0) {
                this.maxRows = maxRows;
                if (entity.rows() > this.maxRows) {
                    this.table = (BasicTable)entity.getSubTable(0, this.maxRows - 1);
                    this.offsetRows = this.maxRows;
                } else {
                    this.table = entity;
                    this.offsetRows = this.table.rows();
                }
            } else {
                this.table = entity;
                this.offsetRows = this.table.rows();
            }
            this.globalRows += this.offsetRows;
        } else {
            throw new SQLException("ResultSet data is null");
        }
        this.findColumnHashMap = new HashMap(this.table.columns());
        for (int i = 0; i < this.table.columns(); ++i) {
            this.findColumnHashMap.put(this.table.getColumnName(i), i + 1);
        }
        this.isUpdatable = false;
        if (this.isUpdatable) {
            this.insertRowMap = new HashMap(this.table.columns() + 1);
        }
    }

    public JDBCResultSet(JDBCConnection conn, JDBCStatement statement, EntityBlockReader reader, String sql) throws SQLException {
        this(conn, statement, reader, sql, -1);
    }

    private BasicTable loadTable() throws SQLException {
        return (BasicTable)this.run(this.tableName);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.getFetchSize() != 0 && (this.table == null || this.currentRow >= this.offsetRows - 1)) {
            if (this.maxRows != -1 && this.globalRows >= this.maxRows) {
                return false;
            }
            try {
                if (!this.reader.hasNext().booleanValue()) {
                    return false;
                }
                BasicTable tempTable = (BasicTable)this.reader.read();
                int nextBlockRows = tempTable.rows();
                if (this.maxRows != -1 && this.globalRows + nextBlockRows > this.maxRows) {
                    this.table = (BasicTable)tempTable.getSubTable(0, this.maxRows - this.globalRows - 1);
                    nextBlockRows = this.table.rows();
                } else {
                    this.table = tempTable;
                }
                this.globalRows += nextBlockRows;
                this.offsetRows = nextBlockRows;
                this.currentRow = -1;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.checkClosed();
        ++this.currentRow;
        return this.currentRow <= this.offsetRows - 1;
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        if (this.findColumnHashMap != null) {
            this.findColumnHashMap.clear();
            this.findColumnHashMap = null;
        }
        if (this.insertRowMap != null) {
            this.insertRowMap.clear();
            this.insertRowMap = null;
        }
        if (this.arguments != null) {
            this.arguments.clear();
            this.arguments = null;
        }
        this.table = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (Objects.nonNull(this.o)) {
            return ((Scalar)this.o).isNull();
        }
        return true;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Vector column = this.table.getColumn(this.adjustColumnIndex(columnIndex));
        Entity entity = column.get(this.currentRow);
        this.o = entity;
        Entity.DATA_TYPE x = column.getDataType();
        switch (x) {
            case DT_BOOL: {
                try {
                    return entity.getString().equals("") ? null : ((BasicBoolean)entity).booleanValue();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case DT_BYTE: {
                return ((BasicByte)entity).byteValue();
            }
            case DT_SHORT: {
                try {
                    return ((BasicShort)entity).shortValue();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case DT_INT: {
                try {
                    return ((BasicInt)entity).intValue();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case DT_LONG: {
                try {
                    return ((BasicLong)entity).longValue();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case DT_DATE: {
                return entity.getString().equals("") ? null : Date.valueOf(((BasicDate)entity).getDate());
            }
            case DT_TIME: {
                return entity.getString().equals("") ? null : Time.valueOf(((BasicTime)entity).getTime());
            }
            case DT_DATETIME: {
                return ((BasicDateTime)entity).getDateTime();
            }
            case DT_TIMESTAMP: {
                return ((BasicTimestamp)entity).getTimestamp();
            }
            case DT_FLOAT: {
                try {
                    return ((BasicFloat)entity).floatValue();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case DT_DOUBLE: {
                try {
                    return ((BasicDouble)entity).doubleValue();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case DT_STRING: 
            case DT_BLOB: 
            case DT_IPADDR: 
            case DT_INT128: 
            case DT_COMPLEX: 
            case DT_POINT: {
                return entity.getString().equals("") ? null : entity.getString();
            }
            case DT_MONTH: {
                return ((BasicMonth)entity).getMonth();
            }
            case DT_MINUTE: {
                return ((BasicMinute)entity).getMinute();
            }
            case DT_SECOND: {
                return ((BasicSecond)entity).getSecond();
            }
            case DT_NANOTIME: {
                return ((BasicNanoTime)entity).getNanoTime();
            }
            case DT_NANOTIMESTAMP: {
                return ((BasicNanoTimestamp)entity).getNanoTimestamp();
            }
            case DT_SYMBOL: {
                return entity.getString().equals("") ? null : entity.getString();
            }
            case DT_UUID: {
                String string = entity.getString();
                if (string.isEmpty()) {
                    return null;
                }
                return UUID.fromString(string);
            }
            case DT_DATEHOUR: {
                return ((BasicDateHour)entity).getDateHour();
            }
            case DT_DECIMAL32: 
            case DT_DECIMAL64: 
            case DT_DECIMAL128: {
                return entity.getString().equals("") ? null : new BigDecimal(entity.getString());
            }
        }
        return entity;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getObject(columnIndex) == null ? null : this.getObject(columnIndex).toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Boolean x = (Boolean)this.getObject(columnIndex);
        if (Objects.isNull(x)) {
            return false;
        }
        return x;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Byte x = (Byte)this.getObject(columnIndex);
        if (Objects.isNull(x)) {
            return 0;
        }
        return x;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Short x = (Short)this.getObject(columnIndex);
        if (Objects.isNull(x)) {
            return 0;
        }
        return x;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object x = this.getObject(columnIndex);
        return Objects.nonNull(x) ? ((Number)x).intValue() : 0;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object x = this.getObject(columnIndex);
        return Objects.nonNull(x) ? ((Number)x).longValue() : 0L;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Float x = (Float)this.getObject(columnIndex);
        if (Objects.isNull(x)) {
            return 0.0f;
        }
        return x.floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object x = this.getObject(columnIndex);
        return Objects.nonNull(x) ? ((Number)x).doubleValue() : 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object x = this.getObject(columnIndex);
        if (x instanceof Float) {
            return BigDecimal.valueOf(((Float)x).floatValue());
        }
        if (x instanceof Double) {
            return BigDecimal.valueOf((Double)x);
        }
        return (BigDecimal)x;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Driver.unused("The method 'getBigDecimal(int columnIndex, int scale)' is not supported.");
        return null;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Driver.unused("getBytes not implemented");
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        LocalDateTime dt;
        Object x = this.getObject(columnIndex);
        LocalDate localdate = null;
        if (x instanceof Date) {
            return (Date)x;
        }
        if (x instanceof BasicMonth) {
            YearMonth dt2 = ((BasicMonth)x).getMonth();
            if (dt2 != null) {
                localdate = LocalDate.of(dt2.getYear(), dt2.getMonth(), 1);
            }
        } else if (x instanceof LocalDateTime) {
            localdate = LocalDate.of(((LocalDateTime)x).getYear(), ((LocalDateTime)x).getMonth(), ((LocalDateTime)x).getDayOfMonth());
        } else if (x instanceof BasicTimestamp) {
            LocalDateTime dt3 = ((BasicTimestamp)x).getTimestamp();
            if (dt3 != null) {
                localdate = LocalDate.of(dt3.getYear(), dt3.getMonth(), dt3.getDayOfMonth());
            }
        } else if (x instanceof BasicNanoTimestamp && (dt = ((BasicNanoTimestamp)x).getNanoTimestamp()) != null) {
            localdate = LocalDate.of(dt.getYear(), dt.getMonth(), dt.getDayOfMonth());
        }
        if (localdate == null) {
            return null;
        }
        return Date.valueOf(localdate);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object x = this.getObject(columnIndex);
        LocalTime time = null;
        if (x instanceof Time) {
            return (Time)x;
        }
        if (x instanceof LocalTime) {
            time = (LocalTime)x;
        } else if (x instanceof LocalDateTime) {
            time = LocalTime.of(((LocalDateTime)x).getHour(), ((LocalDateTime)x).getMinute(), ((LocalDateTime)x).getSecond());
        }
        return Objects.isNull(time) ? null : Time.valueOf(time);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object x = this.getObject(columnIndex);
        LocalDateTime dateTime = null;
        if (x instanceof LocalDateTime) {
            dateTime = (LocalDateTime)x;
        } else if (x instanceof BasicTimestamp) {
            dateTime = ((BasicTimestamp)x).getTimestamp();
        } else if (x instanceof BasicNanoTimestamp) {
            dateTime = ((BasicNanoTimestamp)x).getNanoTimestamp();
        }
        if (dateTime == null) {
            return null;
        }
        return Timestamp.valueOf(dateTime);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        Driver.unused("The method 'getBigDecimal(String columnLabel, int scale)' is not supported.");
        return null;
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new JDBCResultSetMetaData(this.table);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> aClass) throws SQLException {
        try {
            return (T)TypeCast.entity2java(this.table.getColumn(this.adjustColumnIndex(columnIndex)).get(this.currentRow), aClass.getName());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> aClass) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), aClass);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.findColumnHashMap.get(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        Object object = this.getObject(this.findColumn(columnLabel));
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof String) {
            return new BigDecimal((String)object);
        }
        if (object instanceof Double) {
            return BigDecimal.valueOf((Double)object);
        }
        if (object instanceof Integer) {
            return new BigDecimal((Integer)object);
        }
        if (object instanceof Long) {
            return new BigDecimal((Long)object);
        }
        return null;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.currentRow < 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.currentRow >= this.offsetRows;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.currentRow == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.currentRow == this.offsetRows - 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.currentRow = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.currentRow = this.offsetRows;
    }

    @Override
    public boolean first() throws SQLException {
        this.currentRow = 0;
        return this.offsetRows > 0;
    }

    @Override
    public boolean last() throws SQLException {
        this.currentRow = this.offsetRows - 1;
        return this.offsetRows > 0;
    }

    @Override
    public int getRow() throws SQLException {
        return this.currentRow + 1;
    }

    @Override
    public boolean absolute(int columnIndex) throws SQLException {
        this.currentRow = columnIndex >= 0 ? columnIndex - 1 : this.offsetRows + columnIndex;
        return this.currentRow < this.offsetRows;
    }

    @Override
    public boolean relative(int columnIndex) throws SQLException {
        this.currentRow += columnIndex;
        return this.currentRow >= 0 && this.currentRow < this.offsetRows;
    }

    @Override
    public boolean previous() throws SQLException {
        --this.currentRow;
        return this.currentRow >= 0;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement != null ? this.statement.getFetchSize() : 0;
    }

    @Override
    public int getType() throws SQLException {
        return 1005;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public EntityBlockReader getReader() {
        return this.reader;
    }

    public void setReader(EntityBlockReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.update(columnIndex, (Object)Float.valueOf(x));
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal bigDecimal) throws SQLException {
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] bytes) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateDate(int columnIndex, Date date) throws SQLException {
        this.update(columnIndex, (Object)date);
    }

    @Override
    public void updateTime(int columnIndex, Time time) throws SQLException {
        this.update(columnIndex, (Object)time);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp timestamp) throws SQLException {
        this.update(columnIndex, (Object)timestamp);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, int columnIndex1) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, int columnIndex1) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, int columnIndex1) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateObject(int columnIndex, Object o, int columnIndex1) throws SQLException {
        this.update(columnIndex, o);
    }

    @Override
    public void updateObject(int columnIndex, Object o) throws SQLException {
        this.update(columnIndex, o);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.update(columnLabel, (Object)Float.valueOf(x));
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal bigDecimal) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] bytes) throws SQLException {
        this.update(columnLabel, (Object)bytes);
    }

    @Override
    public void updateDate(String columnLabel, Date date) throws SQLException {
        this.update(columnLabel, (Object)date);
    }

    @Override
    public void updateTime(String columnLabel, Time time) throws SQLException {
        this.update(columnLabel, (Object)time);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp timestamp) throws SQLException {
        this.update(columnLabel, (Object)timestamp);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, int columnIndex) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, int columnIndex) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int columnIndex) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateObject(String columnLabel, Object o, int columnIndex) throws SQLException {
        this.update(columnLabel, o);
    }

    @Override
    public void updateObject(String columnLabel, Object o) throws SQLException {
        this.update(columnLabel, o);
    }

    @Override
    public void insertRow() throws SQLException {
        this.isUpdatable();
        try {
            if (this.insertRow == this.currentRow) {
                this.createArguments();
                this.conn.run("tableInsert", this.arguments);
                this.table = this.loadTable();
                this.offsetRows = this.table.rows();
            }
            this.arguments.clear();
            this.insertRowMap.clear();
            this.isInsert = false;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void updateRow() throws SQLException {
        this.isUpdatable();
        if (this.updateRow == this.currentRow) {
            this.updateRun();
            this.table = this.loadTable();
            this.offsetRows = this.table.rows();
        }
        this.insertRowMap.clear();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.isUpdatable();
        StringBuilder sb = new StringBuilder("delete from ").append(this.tableName).append(" where ");
        for (int i = 1; i <= this.table.columns(); ++i) {
            sb.append(this.getColumnName(i)).append(" = ").append(Utils.java2db(this.getObject(i))).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        String sql = sb.toString();
        this.run(sql);
        this.table = this.loadTable();
        this.offsetRows = this.table.rows();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.isUpdatable();
        BasicTable newTable = this.loadTable();
        try {
            for (int i = 0; i < newTable.columns(); ++i) {
                this.table.getColumn(i).set(this.currentRow, newTable.getColumn(i).get(this.currentRow));
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.isUpdatable();
        if (this.isInsert) {
            throw new SQLException("cursor is on the insert row");
        }
        this.insertRowMap.clear();
        this.isInsert = false;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.isUpdatable();
        this.isInsert = true;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.isInsert = false;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        SerialBlob blob = new SerialBlob(this.getObject(columnIndex).toString().getBytes());
        return blob;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(String columnLabel, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(String columnLabel, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateRef(int columnIndex, Ref ref) throws SQLException {
    }

    @Override
    public void updateRef(String columnLabel, Ref ref) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, Blob blob) throws SQLException {
        this.update(columnIndex, (Object)blob);
    }

    @Override
    public void updateBlob(String columnLabel, Blob blob) throws SQLException {
        this.update(columnLabel, (Object)blob);
    }

    @Override
    public void updateClob(int columnIndex, Clob clob) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Clob clob) throws SQLException {
    }

    @Override
    public void updateArray(int columnIndex, Array array) throws SQLException {
    }

    @Override
    public void updateArray(String columnLabel, Array array) throws SQLException {
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateRowId(int columnIndex, RowId rowId) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId rowId) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void updateNString(int columnIndex, String columnLabel) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String columnLabel1) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML sqlxml) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML sqlxml) throws SQLException {
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        return aClass.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return aClass.isInstance(this);
    }

    public Entity getResult() throws SQLException {
        if (this.table == null) {
            return this.entity;
        }
        return this.table;
    }

    public BasicDate getBasicDate(String columnLabel) throws SQLException {
        return (BasicDate)this.getObject(columnLabel);
    }

    public BasicMonth getBasicMonth(String columnLabel) throws SQLException {
        return (BasicMonth)this.getObject(columnLabel);
    }

    public BasicTime getBasicTime(String columnLabel) throws SQLException {
        return (BasicTime)this.getObject(columnLabel);
    }

    public BasicMinute getBasicMinute(String columnLabel) throws SQLException {
        return (BasicMinute)this.getObject(columnLabel);
    }

    public BasicSecond getBasicSecond(String columnLabel) throws SQLException {
        return (BasicSecond)this.getObject(columnLabel);
    }

    public BasicDateTime getBasicDateTime(String columnLabel) throws SQLException {
        return (BasicDateTime)this.getObject(columnLabel);
    }

    public BasicNanoTime getBasicNanoTime(String columnLabel) throws SQLException {
        return (BasicNanoTime)this.getObject(columnLabel);
    }

    public BasicNanoTimestamp getBasicNanoTimestamp(String columnLabel) throws SQLException {
        return (BasicNanoTimestamp)this.getObject(columnLabel);
    }

    public BasicDate getBasicDate(int columnIndex) throws SQLException {
        return (BasicDate)this.getObject(columnIndex);
    }

    public BasicMonth getBasicMonth(int columnIndex) throws SQLException {
        return (BasicMonth)this.getObject(columnIndex);
    }

    public BasicTime getBasicTime(int columnIndex) throws SQLException {
        return (BasicTime)this.getObject(columnIndex);
    }

    public BasicMinute getBasicMinute(int columnIndex) throws SQLException {
        return (BasicMinute)this.getObject(columnIndex);
    }

    public BasicSecond getBasicSecond(int columnIndex) throws SQLException {
        return (BasicSecond)this.getObject(columnIndex);
    }

    public BasicDateTime getBasicDateTime(int columnIndex) throws SQLException {
        return (BasicDateTime)this.getObject(columnIndex);
    }

    public BasicNanoTime getBasicNanoTime(int columnIndex) throws SQLException {
        return (BasicNanoTime)this.getObject(columnIndex);
    }

    public BasicNanoTimestamp getBasicNanoTimestamp(int columnIndex) throws SQLException {
        return (BasicNanoTimestamp)this.getObject(columnIndex);
    }

    public BasicTable getTable() {
        return this.table;
    }

    private void update(String name, Object value) throws SQLException {
        this.update(this.findColumn(name), value);
    }

    private void update(int columnIndex, Object value) throws SQLException {
        this.isUpdatable();
        if (this.isInsert) {
            this.insertRow = this.currentRow;
        } else {
            this.updateRow = this.currentRow;
        }
        this.insert(columnIndex, value);
    }

    private void insert(int columnIndex, Object value) throws SQLException {
        try {
            Entity targetEntity = this.table.getColumn(this.adjustColumnIndex(columnIndex)).get(this.currentRow);
            Entity.DATA_TYPE dataType = targetEntity.getDataType();
            int size = 0;
            if (dataType.getName().equals(Entity.DATA_TYPE.DT_DECIMAL.getName()) || dataType.getName().equals(Entity.DATA_TYPE.DT_DECIMAL32.getName()) || dataType.getName().equals(Entity.DATA_TYPE.DT_DECIMAL64.getName()) || dataType.getName().equals(Entity.DATA_TYPE.DT_DECIMAL128.getName())) {
                String value2 = String.valueOf(value);
                String[] values = value2.split("\\.");
                size = values[1].length();
            }
            Entity entity = BasicEntityFactory.createScalar(dataType, value, size);
            this.insertRowMap.put(columnIndex, entity);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private void updateRun() throws SQLException {
        StringBuilder sb = new StringBuilder();
        StringBuilder where = new StringBuilder(" where ");
        sb.append("update ").append(this.tableName).append(" set ");
        for (int i = 1; i <= this.table.columns(); ++i) {
            Entity value = this.insertRowMap.get(i);
            if (value != null) {
                sb.append(this.getColumnName(i)).append(" = ").append(Utils.java2db(value)).append(", ");
            }
            where.append(this.getColumnName(i)).append(" = ").append(Utils.java2db(this.table.getColumn(this.adjustColumnIndex(i)).get(this.currentRow))).append(" ,");
        }
        sb.delete(sb.length() - 2, sb.length());
        where.delete(where.length() - 2, where.length());
        sb.append((CharSequence)where);
        String sql = sb.toString();
        this.run(sql);
    }

    private Entity run(String sql) throws SQLException {
        try {
            return this.conn.run(sql);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private String getColumnName(int columnIndex) {
        return this.table.getColumnName(this.adjustColumnIndex(columnIndex));
    }

    private int adjustColumnIndex(int columnIndex) {
        return columnIndex - 1;
    }

    private void checkClosed() throws SQLException {
        if (this.table == null && this.isClosed) {
            throw new SQLException("ResultSet is closed");
        }
    }

    public void isUpdatable() throws SQLException {
        if (!this.isUpdatable) {
            throw new SQLException("Updating the table of ResultSet is not currently supported");
        }
    }

    private void createArguments() {
        int col = this.table.columns();
        if (this.arguments == null) {
            this.arguments = new ArrayList<Entity>(col + 1);
        }
        this.arguments.add(this.tableNameArg);
        for (int i = 1; i <= col; ++i) {
            this.arguments.add(this.insertRowMap.get(i));
        }
    }
}

