/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect.DolphinDBDatabaseDialectImp;

import com.dolphindb.jdbc.JDBCStatement;
import io.confluent.connect.jdbc.dialect.DolphinDBDatabaseDialectImp.DDBSynConfigModel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DolphinDBUtils {
    public static List<Map<String, Object>> queryForList(Connection connection, String sql) throws SQLException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try (JDBCStatement stm = (JDBCStatement)connection.createStatement();
             ResultSet rs = stm.executeQuery(sql);){
            ResultSetMetaData metadata = rs.getMetaData();
            int columnCount = metadata.getColumnCount();
            while (rs.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = metadata.getColumnName(i);
                    Object columnValue = rs.getObject(i);
                    row.put(columnName, columnValue);
                }
                resultList.add(row);
            }
        }
        return resultList;
    }

    public static List queryVector(Connection conn, String sql) throws SQLException {
        JDBCStatement stm = (JDBCStatement)conn.createStatement();
        String tmpTabName = "tmp_tab_" + UUID.randomUUID().toString().replace("-", "");
        StringBuilder sb = new StringBuilder();
        sb.append(tmpTabName).append("=");
        sb.append("table(").append(sql).append(" as col);");
        sb.append("select * from ").append(tmpTabName);
        ArrayList<Object> list = new ArrayList<Object>();
        ResultSet rs = stm.executeQuery(sb.toString());
        while (rs.next()) {
            list.add(rs.getObject(1));
        }
        return list;
    }

    public static boolean checkTabAddSortFlag(Map<String, DDBSynConfigModel> ddbSynConfigModelMap, String tabSortKeyAddFlag, String topicName) {
        Boolean addTabSortColFlag = false;
        if (ddbSynConfigModelMap.containsKey(topicName)) {
            if (tabSortKeyAddFlag.equals(ddbSynConfigModelMap.get(topicName).getAddSortColFlag())) {
                addTabSortColFlag = true;
            }
        } else {
            String checkMsg = String.format("topic: [%s] does not have a corresponding table configured\uff0cpleas check the config,or the sink connector name.", topicName);
            throw new RuntimeException(checkMsg);
        }
        return addTabSortColFlag;
    }

    public static boolean checkTabAddSortFlag(Map<String, DDBSynConfigModel> ddbSynConfigModelMap, String tabSortKeyAddFlag, String dfsDBName, String dfsTabName) {
        Boolean addTabSortColFlag = false;
        for (DDBSynConfigModel ddbSynConfigModel : ddbSynConfigModelMap.values()) {
            if (!dfsDBName.equalsIgnoreCase(ddbSynConfigModel.getTargetDB()) || !dfsTabName.equalsIgnoreCase(ddbSynConfigModel.getTargetTab()) || !tabSortKeyAddFlag.equalsIgnoreCase(ddbSynConfigModel.getAddSortColFlag())) continue;
            addTabSortColFlag = true;
            break;
        }
        return addTabSortColFlag;
    }
}

