/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect.DolphinDBDatabaseDialectImp;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DolphinDBDatabaseDialectImp.DDBSynConfigModel;
import io.confluent.connect.jdbc.dialect.DolphinDBDatabaseDialectImp.DolphinDBUtils;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.PreparedStatementBinder;
import io.confluent.connect.jdbc.sink.metadata.FieldsMetadata;
import io.confluent.connect.jdbc.sink.metadata.SchemaPair;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.TableDefinition;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;

public class DDBPreparedStatementBinder
extends PreparedStatementBinder {
    private final JdbcSinkConfig.PrimaryKeyMode pkMode;
    private final PreparedStatement statement;
    private final SchemaPair schemaPair;
    private final FieldsMetadata fieldsMetadata;
    private final JdbcSinkConfig.InsertMode insertMode;
    private final DatabaseDialect dialect;
    private final TableDefinition tabDef;
    private Map<String, DDBSynConfigModel> synConfigMap = null;
    private String ADD_SORT_COL_FLAG;
    private String TAB_SORT_KEY_ADD_FALG;

    public DDBPreparedStatementBinder(DatabaseDialect dialect, PreparedStatement statement, JdbcSinkConfig.PrimaryKeyMode pkMode, SchemaPair schemaPair, FieldsMetadata fieldsMetadata, TableDefinition tabDef, JdbcSinkConfig.InsertMode insertMode, Map<String, DDBSynConfigModel> synConfigMap, String tabSortKeyAddFlag, String addSortColFlag) {
        super(dialect, statement, pkMode, schemaPair, fieldsMetadata, tabDef, insertMode);
        this.dialect = dialect;
        this.pkMode = pkMode;
        this.statement = statement;
        this.schemaPair = schemaPair;
        this.fieldsMetadata = fieldsMetadata;
        this.insertMode = insertMode;
        this.tabDef = tabDef;
        this.synConfigMap = synConfigMap;
        this.TAB_SORT_KEY_ADD_FALG = tabSortKeyAddFlag;
        this.ADD_SORT_COL_FLAG = addSortColFlag;
    }

    @Override
    protected void bindField(int index, Schema schema, Object value, String fieldName) throws SQLException {
        ColumnDefinition colDef = null;
        for (String colName : this.tabDef.columnNames()) {
            if (!colName.equalsIgnoreCase(fieldName)) continue;
            colDef = this.tabDef.definitionForColumn(colName);
        }
        this.dialect.bindField(this.statement, index, schema, value, colDef);
    }

    @Override
    protected int bindNonKeyFields(SinkRecord record, Struct valueStruct, int index) throws SQLException {
        for (String fieldName : this.fieldsMetadata.nonKeyFieldNames) {
            Field field = record.valueSchema().field(fieldName);
            this.bindField(index++, field.schema(), valueStruct.get(field), fieldName);
        }
        Boolean addTabSortColFlag = DolphinDBUtils.checkTabAddSortFlag(this.synConfigMap, this.TAB_SORT_KEY_ADD_FALG, record.topic());
        if ("true".equalsIgnoreCase(this.ADD_SORT_COL_FLAG) && addTabSortColFlag.booleanValue()) {
            this.statement.setInt(index++, 0);
        }
        return index;
    }
}

