/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.DBConnection;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicString;
import com.xxdb.data.Entity;
import com.xxdb.data.Vector;
import com.xxdb.streaming.client.AbstractClient;
import com.xxdb.streaming.client.IMessage;
import com.xxdb.streaming.client.MessageHandler;
import com.xxdb.streaming.client.StreamDeserializer;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPooledClient
extends AbstractClient {
    private static int CORES = Runtime.getRuntime().availableProcessors();
    private ExecutorService threadPool;
    private HashMap<String, List<String>> users = new HashMap();
    private Object lock = new Object();
    private static final Logger log = LoggerFactory.getLogger(ThreadPooledClient.class);
    private HashMap<String, QueueHandlerBinder> queueHandlers = new HashMap();

    public ThreadPooledClient() throws SocketException {
        this("", 8849, CORES);
    }

    public ThreadPooledClient(int threadCount) throws SocketException {
        this("", 0, threadCount);
    }

    public ThreadPooledClient(int subscribePort, int threadCount) throws SocketException {
        this("", subscribePort, threadCount);
    }

    public ThreadPooledClient(String subscribeHost, int subscribePort, int threadCount) throws SocketException {
        super(subscribeHost, subscribePort);
        if (threadCount <= 0) {
            throw new RuntimeException("The 'threadCount' parameter cannot be less than or equal to zero.");
        }
        this.threadPool = Executors.newFixedThreadPool(threadCount);
        new Thread(){
            private LinkedList<IMessage> backlog = new LinkedList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fillBacklog() {
                boolean filled = false;
                HashMap hashMap = ThreadPooledClient.this.queueHandlers;
                synchronized (hashMap) {
                    Set keySet = ThreadPooledClient.this.queueHandlers.keySet();
                    for (String topic : keySet) {
                        List messages = (List)((QueueHandlerBinder)ThreadPooledClient.this.queueHandlers.get(topic)).queue.poll();
                        if (messages == null) continue;
                        this.backlog.addAll(messages);
                        filled = true;
                    }
                }
                return filled;
            }

            private void refill() {
                int count = 200;
                while (!this.fillBacklog()) {
                    if (count <= 100) {
                        if (count > 0) {
                            Thread.yield();
                        } else {
                            Thread.yield();
                        }
                    }
                    --count;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    IMessage msg;
                    if ((msg = this.backlog.poll()) != null) {
                        QueueHandlerBinder binder;
                        HashMap hashMap = ThreadPooledClient.this.queueHandlers;
                        synchronized (hashMap) {
                            binder = (QueueHandlerBinder)ThreadPooledClient.this.queueHandlers.get(msg.getTopic());
                        }
                        ThreadPooledClient.this.threadPool.execute(new HandlerRunner(binder.handler, msg));
                        continue;
                    }
                    this.refill();
                }
            }
        }.start();
    }

    @Override
    protected boolean doReconnect(AbstractClient.Site site) {
        this.threadPool.shutdownNow();
        try {
            Thread.sleep(1000L);
            this.subscribe(site.host, site.port, site.tableName, site.actionName, site.handler, site.msgId + 1L, true, site.filter, site.deserializer, site.allowExistTopic, site.userName, site.passWord);
            log.info("Successfully reconnected and subscribed " + site.host + ":" + site.port + "/" + site.tableName + site.actionName);
            return true;
        }
        catch (Exception ex) {
            log.error("Unable to subscribe table. Will try again after 1 seconds.");
            ex.printStackTrace();
            return false;
        }
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer, boolean allowExistTopic, String userName, String passWord) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, reconnect, filter, deserializer, allowExistTopic, userName, passWord, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer, boolean allowExistTopic, String userName, String passWord, boolean msgAsTable) throws IOException {
        BlockingQueue<List<IMessage>> queue = this.subscribeInternal(host, port, tableName, actionName, handler, offset, reconnect, filter, deserializer, allowExistTopic, userName, passWord, msgAsTable);
        String topicStr = host + ":" + port + "/" + tableName + "/" + actionName;
        List<String> usr = Arrays.asList(userName, passWord);
        HashMap<String, QueueHandlerBinder> hashMap = this.queueHandlers;
        synchronized (hashMap) {
            this.queueHandlers.put((String)this.tableNameToTrueTopic.get(topicStr), new QueueHandlerBinder(queue, handler));
            this.users.put(topicStr, usr);
        }
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, boolean allowExistTopic, String userName, String passWord) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, reconnect, filter, null, allowExistTopic, userName, passWord);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer, boolean allowExistTopic) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, reconnect, filter, deserializer, allowExistTopic, "", "");
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, boolean allowExistTopic) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, reconnect, filter, null, allowExistTopic);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, reconnect, filter, deserializer, false);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, reconnect, null, null, false);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, Vector filter) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, false, filter, null, false);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, false);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, -1L);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, boolean reconnect) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, -1L, reconnect);
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler) throws IOException {
        this.subscribe(host, port, tableName, "javaStreamingApi", handler, -1L);
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler, boolean reconnect) throws IOException {
        this.subscribe(host, port, tableName, "javaStreamingApi", handler, -1L, reconnect);
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler, long offset) throws IOException {
        this.subscribe(host, port, tableName, "javaStreamingApi", handler, offset);
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler, long offset, boolean reconnect) throws IOException {
        this.subscribe(host, port, tableName, "javaStreamingApi", handler, offset, reconnect);
    }

    public void unsubscribe(String host, int port, String tableName, String actionName) throws IOException {
        this.unsubscribeInternal(host, port, tableName, actionName);
    }

    public void unsubscribe(String host, int port, String tableName) throws IOException {
        this.unsubscribeInternal(host, port, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unsubscribeInternal(String host, int port, String tableName, String actionName) throws IOException {
        DBConnection dbConn = new DBConnection();
        String fullTableName = host + ":" + port + "/" + tableName + "/" + actionName;
        List<String> usr = this.users.get(fullTableName);
        String user = usr.get(0);
        String pwd = usr.get(1);
        if (!user.equals("")) {
            dbConn.connect(host, port, user, pwd);
        } else {
            dbConn.connect(host, port);
        }
        try {
            String localIP = this.listeningHost;
            if (localIP.equals("")) {
                localIP = dbConn.getLocalAddress().getHostAddress();
            }
            ArrayList<Entity> params = new ArrayList<Entity>();
            params.add(new BasicString(localIP));
            params.add(new BasicInt(this.listeningPort));
            params.add(new BasicString(tableName));
            params.add(new BasicString(actionName));
            dbConn.run("stopPublishTable", params);
            String topic = null;
            Object object = this.tableNameToTrueTopic;
            synchronized (object) {
                topic = (String)this.tableNameToTrueTopic.get(fullTableName);
            }
            object = this.trueTopicToSites;
            synchronized (object) {
                AbstractClient.Site[] sites = (AbstractClient.Site[])this.trueTopicToSites.get(topic);
                if (sites == null || sites.length == 0) {
                    // empty if block
                }
                for (int i = 0; i < sites.length; ++i) {
                    sites[i].closed = true;
                }
            }
            object = this.queueManager;
            synchronized (object) {
                this.queueManager.removeQueue(topic);
            }
            log.info("Successfully unsubscribed table " + fullTableName);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            dbConn.close();
            String topicStr = host + ":" + port + "/" + tableName + "/" + actionName;
            QueueHandlerBinder queueHandler = null;
            HashMap<String, QueueHandlerBinder> hashMap = this.queueHandlers;
            synchronized (hashMap) {
                queueHandler = this.queueHandlers.get(topicStr);
                this.queueHandlers.remove(topicStr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashMap<String, QueueHandlerBinder> hashMap = this.queueHandlers;
        synchronized (hashMap) {
            this.queueHandlers = null;
        }
        this.threadPool.shutdownNow();
        if (this.pThread != null) {
            this.pThread.interrupt();
        }
        this.isClose_ = true;
    }

    class HandlerRunner
    implements Runnable {
        MessageHandler handler;
        IMessage message;

        HandlerRunner(MessageHandler handler, IMessage message) {
            this.handler = handler;
            this.message = message;
        }

        @Override
        public void run() {
            this.handler.doEvent(this.message);
        }
    }

    private class QueueHandlerBinder {
        private BlockingQueue<List<IMessage>> queue;
        private MessageHandler handler;

        public QueueHandlerBinder(BlockingQueue<List<IMessage>> queue, MessageHandler handler) {
            this.queue = queue;
            this.handler = handler;
        }
    }
}

