/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicInt;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

public class BasicIntVector
extends AbstractVector {
    protected int[] values;
    protected int size;
    protected int capaticy;

    public BasicIntVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicIntVector(List<Integer> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i) != null ? list.get(i) : Integer.MIN_VALUE;
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicIntVector(int[] array) {
        this(array, true);
    }

    public BasicIntVector(int[] array, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = copy ? (int[])array.clone() : array;
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicIntVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new int[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicIntVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        ByteOrder bo;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new int[size];
        long totalBytes = (long)size * 4L;
        byte[] buf = new byte[4096];
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (long off = 0L; off < totalBytes; off += (long)len) {
            len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int start = (int)(off / 4L);
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getInt(i * 4);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        long totalBytes = (long)count * 4L;
        long off = 0L;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        while (off < totalBytes) {
            int len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getInt(i * 4);
            }
            off += (long)len;
            start += end;
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeInt(this.values[start + i]);
        }
    }

    @Override
    public Entity get(int index) {
        return new BasicInt(this.values[index]);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        int[] sub = new int[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicIntVector(sub, false);
    }

    protected int[] getSubArray(int[] indices) {
        int length = indices.length;
        int[] sub = new int[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return sub;
    }

    public int getInt(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        this.values[index] = ((Scalar)value).isNull() ? Integer.MIN_VALUE : ((Scalar)value).getNumber().intValue();
    }

    public void setInt(int index, int value) {
        this.values[index] = value;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        int value = this.values[index];
        if (value >= 0) {
            return value % buckets;
        }
        if (value == Integer.MIN_VALUE) {
            return -1;
        }
        return (int)((0x100000000L + (long)value) % (long)buckets);
    }

    @Override
    public int getUnitLength() {
        return 4;
    }

    public void add(int value) {
        if (this.size + 1 > this.capaticy && this.values.length > 0) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        } else if (this.values.length <= 0) {
            this.values = Arrays.copyOf(this.values, this.values.length + 1);
        }
        this.capaticy = this.values.length;
        this.values[this.size] = value;
        ++this.size;
    }

    public void addRange(int[] valueList) {
        this.values = Arrays.copyOf(this.values, valueList.length + this.values.length);
        System.arraycopy(valueList, 0, this.values, this.size, valueList.length);
        this.size += valueList.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().intValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicIntVector)value).getdataArray());
    }

    public int[] getdataArray() {
        int[] data = new int[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        return data;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicIntVector v = (BasicIntVector)vector;
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicIntVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == Integer.MIN_VALUE;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = Integer.MIN_VALUE;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_INT;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicInt.class;
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        int[] data = new int[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        out.writeIntArray(data);
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        int[] data = new int[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        for (int val : data) {
            buffer.putInt(val);
        }
        return buffer;
    }

    @Override
    public int asof(Scalar value) {
        int target;
        try {
            target = value.getNumber().intValue();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        int start = 0;
        int end = this.size - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.values[mid] <= target) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return end;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            out.putInt(this.values[indexStart + i]);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement * 4;
    }
}

