/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.temporal.Temporal;

public class BasicDouble
extends AbstractScalar
implements Comparable<BasicDouble> {
    private double value;

    public BasicDouble(double value) {
        this.value = value;
    }

    public BasicDouble(ExtendedDataInput in) throws IOException {
        this.value = in.readDouble();
    }

    public double getDouble() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value == -1.7976931348623157E308;
    }

    @Override
    public void setNull() {
        this.value = -1.7976931348623157E308;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.FLOATING;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DOUBLE;
    }

    @Override
    public Number getNumber() throws Exception {
        if (this.isNull()) {
            return -1.7976931348623157E308;
        }
        return this.value;
    }

    public Double doubleValue() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    @JsonIgnore
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            return String.valueOf(this.value);
        }
        double absVal = Math.abs(this.value);
        if (Utils.SCALE < 0) {
            return new DecimalFormat("0.########").format(this.value);
        }
        if (this.value >= 1.0E7) {
            BigDecimal bd = new BigDecimal(this.value);
            return bd.setScale(Utils.SCALE, RoundingMode.DOWN).toString();
        }
        if (this.value == 0.0) {
            return String.valueOf(this.value);
        }
        BigDecimal bd = new BigDecimal(this.value + "");
        return bd.setScale(Utils.SCALE, RoundingMode.DOWN).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicDouble) || o == null) {
            return false;
        }
        return this.value == ((BasicDouble)o).value;
    }

    public int hashCode() {
        return new Double(this.value).hashCode();
    }

    @Override
    public int hashBucket(int buckets) {
        return -1;
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return this.getString();
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeDouble(this.value);
    }

    @Override
    public int compareTo(BasicDouble o) {
        return Double.compare(this.value, o.value);
    }

    @Override
    @JsonIgnore
    public int getScale() {
        return super.getScale();
    }
}

