/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.Temporal;
import java.util.Objects;

public class BasicDecimal128
extends AbstractScalar
implements Comparable<BasicDecimal128> {
    private int scale;
    private BigInteger unscaledValue;
    private static final BigDecimal DECIMAL128_MIN_VALUE = new BigDecimal("-170141183460469231731687303715884105728");
    private static final BigDecimal DECIMAL128_MAX_VALUE = new BigDecimal("170141183460469231731687303715884105728");
    private static final BigInteger BIGINT_MIN_VALUE = new BigInteger("-170141183460469231731687303715884105728");
    private static final BigInteger BIGINT_MAX_VALUE = new BigInteger("170141183460469231731687303715884105728");

    public BasicDecimal128(String data, int scale) {
        this(new BigDecimal(data).scaleByPowerOfTen(scale).toBigInteger(), scale);
    }

    public BasicDecimal128(BigInteger unscaledVal, int scale) {
        if (scale < 0 || scale > 38) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,38].");
        }
        BigDecimal bd = new BigDecimal(unscaledVal);
        if (bd.compareTo(DECIMAL128_MIN_VALUE) < 0 || bd.compareTo(DECIMAL128_MAX_VALUE) > 0) {
            throw new RuntimeException("Decimal128 overflow " + new BigDecimal(unscaledVal).scaleByPowerOfTen(-scale));
        }
        this.unscaledValue = unscaledVal;
        if (this.unscaledValue.compareTo(BIGINT_MIN_VALUE) < 0) {
            throw new RuntimeException("Decimal128 " + this.unscaledValue + " cannot be less than " + BIGINT_MIN_VALUE);
        }
        if (this.unscaledValue.compareTo(BIGINT_MAX_VALUE) > 0) {
            throw new RuntimeException("Decimal128 " + this.unscaledValue + " cannot exceed " + BIGINT_MAX_VALUE);
        }
        this.scale = scale;
    }

    public BasicDecimal128(ExtendedDataInput in) throws IOException {
        this.scale = in.readInt();
        this.unscaledValue = BasicDecimal128.handleLittleEndianBigEndian(in);
    }

    private static BigInteger handleLittleEndianBigEndian(ExtendedDataInput in) throws IOException {
        BigInteger value;
        byte[] buffer = new byte[16];
        if (in.isLittleEndian()) {
            in.readFully(buffer);
            BasicDecimal128.reverseByteArray(buffer);
            value = new BigInteger(buffer);
        } else {
            in.readFully(buffer);
            value = new BigInteger(buffer);
        }
        return value;
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeInt(this.scale);
        byte[] newArray = new byte[16];
        byte[] originalArray = this.unscaledValue.toByteArray();
        if (originalArray.length == 0 || originalArray.length > 16) {
            throw new RuntimeException("byte length of Decimal128 " + originalArray.length + " cannot be less than 0 or exceed 16.");
        }
        if (originalArray[0] >= 0) {
            System.arraycopy(originalArray, 0, newArray, 16 - originalArray.length, originalArray.length);
        } else {
            System.arraycopy(originalArray, 0, newArray, 16 - originalArray.length, originalArray.length);
            for (int i = 0; i < 16 - originalArray.length; ++i) {
                newArray[i] = -1;
            }
        }
        out.writeBigIntArray(newArray, 0, newArray.length);
    }

    public static void reverseByteArray(byte[] array) {
        int left = 0;
        for (int right = array.length - 1; left < right; ++left, --right) {
            byte temp = array[left];
            array[left] = array[right];
            array[right] = temp;
        }
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.DENARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DECIMAL128;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        if (this.scale == 0) {
            return this.unscaledValue.toString();
        }
        BigDecimal bd = new BigDecimal(this.unscaledValue).scaleByPowerOfTen(-this.scale);
        return bd.toPlainString();
    }

    @Override
    public boolean isNull() {
        if (Objects.isNull(this.unscaledValue)) {
            return true;
        }
        return new BigDecimal(this.unscaledValue).compareTo(DECIMAL128_MIN_VALUE) == 0;
    }

    @Override
    public void setNull() {
        this.unscaledValue = BIGINT_MIN_VALUE;
    }

    @Override
    public Number getNumber() throws Exception {
        if (this.isNull()) {
            return DECIMAL128_MIN_VALUE;
        }
        BigDecimal bd = new BigDecimal(this.unscaledValue).scaleByPowerOfTen(-this.scale).stripTrailingZeros();
        return bd;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    @JsonIgnore
    public Temporal getTemporal() throws Exception {
        throw new Exception("Incompatible data type");
    }

    @Override
    public int hashBucket(int buckets) {
        return 0;
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return this.getString();
    }

    @Override
    public int compareTo(BasicDecimal128 o) {
        BigDecimal a = new BigDecimal(this.getString());
        BigDecimal b = new BigDecimal(o.getString());
        return a.compareTo(b);
    }

    public BigInteger unscaledValue() {
        return this.unscaledValue;
    }
}

