/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

import com.xxdb.compression.Encoder;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;

public class LZ4Encoder
implements Encoder {
    LZ4Compressor compressor;
    private static final int DEFAULT_BLOCK_SIZE = 65536;

    @Override
    public ByteBuffer compress(AbstractVector input, int elementCount, int unitLength, int maxCompressedLength, ByteBuffer out) throws IOException {
        boolean isLittleEndian;
        if (this.compressor == null) {
            LZ4Factory factory = LZ4Factory.fastestInstance();
            this.compressor = factory.fastCompressor();
        }
        int byteCount = 0;
        int dataCount = input.rows();
        int dataIndex = 0;
        ByteBuffer dataBufer = ByteBuffer.allocate(65536);
        boolean bl = isLittleEndian = out.order() == ByteOrder.LITTLE_ENDIAN;
        if (isLittleEndian) {
            dataBufer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            dataBufer.order(ByteOrder.BIG_ENDIAN);
        }
        AbstractVector.NumElementAndPartial numElementAndPartial = new AbstractVector.NumElementAndPartial(0, 0);
        while (dataCount > dataIndex) {
            int blockSize;
            for (int readBytes = input.serialize(dataIndex, numElementAndPartial.partial, dataCount - dataIndex, numElementAndPartial, dataBufer); readBytes > 0; readBytes -= blockSize) {
                blockSize = Math.min(65536, dataBufer.position());
                byte[] srcBuf = new byte[blockSize];
                dataBufer.flip();
                dataBufer.get(srcBuf, 0, blockSize);
                byte[] ret = this.compressor.compress(srcBuf);
                if (ret.length + 4 > out.remaining()) {
                    out = Utils.reAllocByteBuffer(out, (out.position() + ret.length + 4) * 2);
                }
                out.putInt(ret.length);
                out.put(ret);
                byteCount += ret.length + 32;
            }
            dataIndex += numElementAndPartial.numElement;
            dataBufer.clear();
        }
        return out;
    }

    public ByteBuffer compress(ByteBuffer in, int elementCount, int unitLength, int maxCompressedLength) throws IOException {
        int blockSize;
        int compressedLength;
        if (this.compressor == null) {
            LZ4Factory factory = LZ4Factory.fastestInstance();
            this.compressor = factory.fastCompressor();
        }
        ByteBuffer out = ByteBuffer.allocate(maxCompressedLength);
        for (int count = 0; elementCount > 0 && count < maxCompressedLength; count += compressedLength, elementCount -= blockSize / unitLength) {
            blockSize = Math.min(65536, elementCount * unitLength);
            byte[] src = new byte[blockSize];
            byte[] dest = new byte[blockSize];
            in.get(src);
            compressedLength = this.compressor.compress(src, 0, blockSize, dest, 0);
            out.putInt(compressedLength);
            out.put(dest, 0, compressedLength);
            count += 4;
        }
        out.flip();
        return out;
    }
}

