/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.xxdb.data.BasicBoolean;
import com.xxdb.data.BasicBooleanVector;
import com.xxdb.data.BasicByte;
import com.xxdb.data.BasicByteVector;
import com.xxdb.data.BasicComplex;
import com.xxdb.data.BasicDate;
import com.xxdb.data.BasicDateHour;
import com.xxdb.data.BasicDateTime;
import com.xxdb.data.BasicDateTimeVector;
import com.xxdb.data.BasicDateVector;
import com.xxdb.data.BasicDecimal128;
import com.xxdb.data.BasicDecimal32;
import com.xxdb.data.BasicDecimal64;
import com.xxdb.data.BasicDouble;
import com.xxdb.data.BasicDoubleVector;
import com.xxdb.data.BasicDuration;
import com.xxdb.data.BasicFloat;
import com.xxdb.data.BasicFloatVector;
import com.xxdb.data.BasicIPAddr;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicInt128;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicLong;
import com.xxdb.data.BasicLongVector;
import com.xxdb.data.BasicMinute;
import com.xxdb.data.BasicMinuteVector;
import com.xxdb.data.BasicMonth;
import com.xxdb.data.BasicMonthVector;
import com.xxdb.data.BasicNanoTime;
import com.xxdb.data.BasicNanoTimeVector;
import com.xxdb.data.BasicNanoTimestamp;
import com.xxdb.data.BasicNanoTimestampVector;
import com.xxdb.data.BasicPoint;
import com.xxdb.data.BasicSecond;
import com.xxdb.data.BasicSecondVector;
import com.xxdb.data.BasicShort;
import com.xxdb.data.BasicShortVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTime;
import com.xxdb.data.BasicTimeVector;
import com.xxdb.data.BasicTimestamp;
import com.xxdb.data.BasicTimestampVector;
import com.xxdb.data.BasicUuid;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class TypeCast {
    private static final String PACKAGE_NAME = "com.xxdb.data.";
    private static final String VECTOR = "Vector";
    private static final String BASIC_ANY_VECTOR = "com.xxdb.data.BasicAnyVector";
    public static final String BASIC_MONTH = "com.xxdb.data.BasicMonth";
    public static final String BASIC_DATE = "com.xxdb.data.BasicDate";
    public static final String BASIC_TIME = "com.xxdb.data.BasicTime";
    public static final String BASIC_MINUTE = "com.xxdb.data.BasicMinute";
    public static final String BASIC_SECOND = "com.xxdb.data.BasicSecond";
    public static final String BASIC_NANOTIME = "com.xxdb.data.BasicNanoTime";
    public static final String BASIC_TIMESTAMP = "com.xxdb.data.BasicTimestamp";
    public static final String BASIC_DATETIME = "com.xxdb.data.BasicDateTime";
    public static final String BASIC_NANOTIMESTAMP = "com.xxdb.data.BasicNanoTimestamp";
    public static final String BASIC_MONTH_VECTOR = "com.xxdb.data.BasicMonthVector";
    public static final String BASIC_DATE_VECTOR = "com.xxdb.data.BasicDateVector";
    public static final String BASIC_TIME_VECTOR = "com.xxdb.data.BasicTimeVector";
    public static final String BASIC_MINUTE_VECTOR = "com.xxdb.data.BasicMinuteVector";
    public static final String BASIC_SECOND_VECTOR = "com.xxdb.data.BasicSecondVector";
    public static final String BASIC_NANOTIME_VECTOR = "com.xxdb.data.BasicNanoTimeVector";
    public static final String BASIC_TIMESTAMP_VECTOR = "com.xxdb.data.BasicTimestampVector";
    public static final String BASIC_DATETIME_VECTOR = "com.xxdb.data.BasicDateTimeVector";
    public static final String BASIC_NANOTIMESTAMP_VECTOR = "com.xxdb.data.BasicNanoTimestampVector";
    public static final String DATE = "java.sql.Date";
    public static final String TIME = "java.sql.Time";
    public static final String TIMESTAMP = "java.sql.Timestamp";
    public static final String LOCAL_DATE = "java.time.LocalDate";
    public static final String LOCAL_TIME = "java.time.LocalTime";
    public static final String LOCAL_DATETIME = "java.time.LocalDateTime";
    public static final String YEAR_MONTH = "java.time.YearMonth";
    public static final int YEAR = 1970;
    public static final int MONTH = 1;
    public static final int DAY = 1;
    public static final int HOUR = 0;
    public static final int MINUTE = 0;
    public static final int SECOND = 0;
    public static final int NANO = 0;
    public static final YearMonth YEARMONTH = YearMonth.of(1970, 1);
    public static final LocalTime LOCALTIME = LocalTime.of(0, 0, 0, 0);
    public static final LocalDate LOCALDATE = LocalDate.of(1970, 1, 1);
    public static final LocalDateTime LOCALDATETIME = LocalDateTime.of(LOCALDATE, LOCALTIME);
    public static final String BASIC_VOID = "com.xxdb.data.Void";
    public static final String BASIC_BOOLEAN = "com.xxdb.data.BasicBoolean";
    public static final String BASIC_BYTE = "com.xxdb.data.BasicByte";
    public static final String BASIC_SHORT = "com.xxdb.data.BasicShort";
    public static final String BASIC_INT = "com.xxdb.data.BasicInt";
    public static final String BASIC_LONG = "com.xxdb.data.BasicLong";
    public static final String BASIC_FLOAT = "com.xxdb.data.BasicFloat";
    public static final String BASIC_DOUBLE = "com.xxdb.data.BasicDouble";
    public static final String BASIC_STRING = "com.xxdb.data.BasicString";
    public static final String BASIC_COMPLEX = "com.xxdb.data.BasicComplex";
    public static final String BASIC_DATEHOUR = "com.xxdb.data.BasicDateHour";
    public static final String BASIC_DURATION = "com.xxdb.data.BasicDuration";
    public static final String BASIC_INT128 = "com.xxdb.data.BasicInt128";
    public static final String BASIC_IPADDR = "com.xxdb.data.BasicIPAddr";
    public static final String BASIC_POINT = "com.xxdb.data.BasicPoint";
    public static final String BASIC_UUID = "com.xxdb.data.BasicUuid";
    public static final String BASIC_SYMBOL = "com.xxdb.data.BasicString";
    public static final String BASIC_BLOB = "com.xxdb.data.BasicString";
    public static final String BASIC_BOOLEAN_VECTOR = "com.xxdb.data.BasicBooleanVector";
    public static final String BASIC_BYTE_VECTOR = "com.xxdb.data.BasicByteVector";
    public static final String BASIC_SHORT_VECTOR = "com.xxdb.data.BasicShortVector";
    public static final String BASIC_INT_VECTOR = "com.xxdb.data.BasicIntVector";
    public static final String BASIC_LONG_VECTOR = "com.xxdb.data.BasicLongVector";
    public static final String BASIC_FLOAT_VECTOR = "com.xxdb.data.BasicFloatVector";
    public static final String BASIC_DOUBLE_VECTOR = "com.xxdb.data.BasicDoubleVector";
    public static final String BASIC_STRING_VECTOR = "com.xxdb.data.BasicStringVector";
    public static final String BOOLEAN = "java.lang.Boolean";
    public static final String BYTE = "java.lang.Byte";
    public static final String CHAR = "java.lang.Character";
    public static final String SHORT = "java.lang.Short";
    public static final String INT = "java.lang.Integer";
    public static final String LONG = "java.lang.Long";
    public static final String FLOAT = "java.lang.Float";
    public static final String DOUBLE = "java.lang.Double";
    public static final String STRING = "java.lang.String";
    public static final String UDATE = "java.util.Date";
    public static final String BOOLEANARR = "[Z";
    public static final String BYTEARR = "[B";
    public static final String CHARARR = "[C";
    public static final String SHORTARR = "[S";
    public static final String INTARR = "[I";
    public static final String LONGARR = "[J";
    public static final String FLOATARR = "[F";
    public static final String DOUBLEARR = "[D";
    public static final HashMap<Integer, String> TYPEINT2STRING = new LinkedHashMap<Integer, String>();
    public static Scalar[] NULL = new Scalar[]{new BasicBoolean(false), new BasicByte(0), new BasicShort(0), new BasicInt(0), new BasicLong(0L), new BasicFloat(0.0f), new BasicDouble(0.0), new BasicString(""), new BasicDate(LocalDate.of(2020, 1, 1)), new BasicTimestamp(LocalDateTime.of(2020, 1, 1, 0, 0)), new BasicTime(LocalTime.of(0, 0)), new BasicNanoTime(LocalTime.of(0, 0, 0, 0)), new BasicNanoTimestamp(LocalDateTime.of(2020, 1, 1, 0, 0, 0, 0)), new BasicString("", true), new BasicDateHour(LocalDateTime.of(2020, 1, 1, 0, 0, 0)), new BasicComplex(0.0, 0.0), new BasicDuration(Entity.DURATION.NS, 1), new BasicInt128(1L, 1L), new BasicIPAddr(1L, 1L), new BasicPoint(1.0, 1.0), new BasicUuid(1L, 1L), new BasicMonth(2020, Month.JANUARY), new BasicSecond(LocalTime.of(0, 0, 0)), new BasicMinute(LocalTime.of(0, 0, 0)), new BasicDateTime(LocalDateTime.of(2020, 1, 1, 0, 0, 0)), new BasicDecimal32(0, 0), new BasicDecimal64(0L, 0), new BasicDecimal128("0", 0)};

    public static Object nullScalar(Entity.DATA_TYPE type) throws SQLException {
        Scalar x = null;
        switch (type) {
            case DT_BOOL: {
                x = NULL[0];
                break;
            }
            case DT_BYTE: {
                x = NULL[1];
                break;
            }
            case DT_SHORT: {
                x = NULL[2];
                break;
            }
            case DT_INT: {
                x = NULL[3];
                break;
            }
            case DT_LONG: {
                x = NULL[4];
                break;
            }
            case DT_FLOAT: {
                x = NULL[5];
                break;
            }
            case DT_DOUBLE: {
                x = NULL[6];
                break;
            }
            case DT_SYMBOL: 
            case DT_STRING: {
                x = NULL[7];
                break;
            }
            case DT_DATE: {
                x = NULL[8];
                break;
            }
            case DT_TIMESTAMP: {
                x = NULL[9];
                break;
            }
            case DT_TIME: {
                x = NULL[10];
                break;
            }
            case DT_NANOTIME: {
                x = NULL[11];
                break;
            }
            case DT_NANOTIMESTAMP: {
                x = NULL[12];
                break;
            }
            case DT_BLOB: {
                x = NULL[13];
                break;
            }
            case DT_DATEHOUR: {
                x = NULL[14];
                break;
            }
            case DT_COMPLEX: {
                x = NULL[15];
                break;
            }
            case DT_DURATION: {
                x = NULL[16];
                break;
            }
            case DT_INT128: {
                x = NULL[17];
                break;
            }
            case DT_IPADDR: {
                x = NULL[18];
                break;
            }
            case DT_POINT: {
                x = NULL[19];
                break;
            }
            case DT_MONTH: {
                x = NULL[21];
                break;
            }
            case DT_SECOND: {
                x = NULL[22];
                break;
            }
            case DT_MINUTE: {
                x = NULL[23];
                break;
            }
            case DT_UUID: {
                x = NULL[20];
                break;
            }
            case DT_DATETIME: {
                x = NULL[24];
                break;
            }
            case DT_DECIMAL32: {
                x = NULL[25];
                break;
            }
            case DT_DECIMAL64: {
                x = NULL[26];
                break;
            }
            case DT_DECIMAL128: {
                x = NULL[27];
                break;
            }
            default: {
                throw new SQLException("Unsupported type");
            }
        }
        return x;
    }

    public static String castDbString(Object o) {
        String srcClassName;
        switch (srcClassName = o.getClass().getName()) {
            case "java.lang.String": 
            case "com.xxdb.data.BasicString": {
                return "\"" + o + "\"";
            }
            case "java.lang.Character": {
                return "'" + o + "'";
            }
            case "java.sql.Date": {
                return new BasicDate(((Date)o).toLocalDate()).toString();
            }
            case "java.sql.Time": {
                return new BasicNanoTime(((Time)o).toLocalTime()).toString();
            }
            case "java.util.Date": {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((java.util.Date)o);
                return new BasicTimestamp(calendar).toString();
            }
            case "java.sql.Timestamp": {
                return new BasicNanoTimestamp(((Timestamp)o).toLocalDateTime()).toString();
            }
            case "java.time.YearMonth": {
                return new BasicMonth((YearMonth)o).toString();
            }
            case "java.time.LocalDate": {
                return new BasicDate((LocalDate)o).toString();
            }
            case "java.time.LocalTime": {
                return new BasicNanoTime((LocalTime)o).toString();
            }
            case "java.time.LocalDateTime": {
                return new BasicNanoTimestamp((LocalDateTime)o).toString();
            }
            case "java.lang.Boolean": 
            case "java.lang.Byte": 
            case "java.lang.Short": 
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Float": 
            case "java.lang.Double": 
            case "com.xxdb.data.BasicBoolean": 
            case "com.xxdb.data.BasicByte": 
            case "com.xxdb.data.BasicShort": 
            case "com.xxdb.data.BasicInt": 
            case "com.xxdb.data.BasicLong": 
            case "com.xxdb.data.BasicDate": 
            case "com.xxdb.data.BasicMonth": 
            case "com.xxdb.data.BasicTime": 
            case "com.xxdb.data.BasicMinute": 
            case "com.xxdb.data.BasicSecond": 
            case "com.xxdb.data.BasicDateTime": 
            case "com.xxdb.data.BasicTimestamp": 
            case "com.xxdb.data.BasicNanoTime": 
            case "com.xxdb.data.BasicNanoTimestamp": 
            case "com.xxdb.data.BasicFloat": 
            case "com.xxdb.data.BasicDouble": 
            case "com.xxdb.data.BasicDuration": {
                return o.toString();
            }
            case "com.xxdb.data.BasicDateHour": {
                int value = ((BasicDateHour)o).getInt();
                return "datehour(" + value + ")";
            }
            case "com.xxdb.data.BasicUuid": {
                return "uuid(\"" + o.toString() + "\")";
            }
            case "com.xxdb.data.BasicIPAddr": {
                return "ipaddr(\"" + o.toString() + "\")";
            }
            case "com.xxdb.data.BasicInt128": {
                return "int128(\"" + o.toString() + "\")";
            }
            case "com.xxdb.data.BasicComplex": {
                double x = ((BasicComplex)o).getReal();
                double y = ((BasicComplex)o).getImage();
                return "complex(" + x + "," + y + ")";
            }
            case "com.xxdb.data.BasicPoint": {
                double a = ((BasicPoint)o).getX();
                double b = ((BasicPoint)o).getY();
                return "point(" + a + "," + b + ")";
            }
            case "com.xxdb.data.Void": {
                return "NULL";
            }
        }
        return null;
    }

    public static Entity java2db(Object srcValue, String targetEntityClassName) throws IOException {
        String srcValueClassName = srcValue.getClass().getName();
        Entity castEntity = null;
        if (srcValueClassName.equals(targetEntityClassName) || srcValueClassName.startsWith(targetEntityClassName)) {
            return (Entity)srcValue;
        }
        try {
            castEntity = TypeCast.dateTimeCast(srcValue, targetEntityClassName);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (castEntity != null) {
            return castEntity;
        }
        castEntity = TypeCast.basicTypeCast(srcValue, targetEntityClassName);
        if (castEntity != null) {
            return castEntity;
        }
        throw new IOException("only support bool byte char short int long float double Object[] List Date Time Timestamp YearMoth LocalDate LocalTime LocalDateTime Scalar Vector");
    }

    public static Entity dateTimeCast(Object srcValue, String targetEntityClassName) throws Exception {
        Entity castEntity;
        if ((srcValue instanceof Scalar || srcValue instanceof Vector) && (castEntity = TypeCast.dateTime_db2db((Entity)srcValue, targetEntityClassName)) != null) {
            return castEntity;
        }
        castEntity = TypeCast.dataTime_java2db(srcValue, targetEntityClassName);
        if (castEntity != null) {
            return castEntity;
        }
        if (srcValue instanceof List && (castEntity = TypeCast.dateTimeArr2Vector(((List)srcValue).toArray(), targetEntityClassName)) != null) {
            return castEntity;
        }
        if (srcValue instanceof Object[] && (castEntity = TypeCast.dateTimeArr2Vector((Object[])srcValue, targetEntityClassName)) != null) {
            return castEntity;
        }
        return null;
    }

    public static Entity basicTypeCast(Object srcValue, String targetEntityClassName) throws IOException {
        Entity castEntity;
        if ((srcValue instanceof Scalar || srcValue instanceof Vector) && (castEntity = TypeCast.basicType_db2db((Entity)srcValue, targetEntityClassName)) != null) {
            return castEntity;
        }
        castEntity = TypeCast.basicType_java2db(srcValue, targetEntityClassName);
        if (castEntity != null) {
            return castEntity;
        }
        if (srcValue instanceof List && (castEntity = TypeCast.basicTypeArr2Vector(((List)srcValue).toArray(), targetEntityClassName)) != null) {
            return castEntity;
        }
        if (srcValue instanceof Object[] && (castEntity = TypeCast.basicTypeArr2Vector((Object[])srcValue, targetEntityClassName)) != null) {
            return castEntity;
        }
        return null;
    }

    public static Entity dataTime_java2db(Object srcValue, String targetEntityClassName) throws IOException {
        if (srcValue instanceof Entity) {
            return null;
        }
        String srcEntityClassName = srcValue.getClass().getName();
        if (!TypeCast.CheckedDateTime(srcEntityClassName, targetEntityClassName)) {
            return null;
        }
        Comparable<ChronoLocalDate> temporal = null;
        switch (srcEntityClassName) {
            case "java.sql.Date": {
                temporal = ((Date)srcValue).toLocalDate();
                break;
            }
            case "java.sql.Time": {
                temporal = ((Time)srcValue).toLocalTime();
                break;
            }
            case "java.sql.Timestamp": {
                temporal = ((Timestamp)srcValue).toLocalDateTime();
                break;
            }
            case "java.time.LocalDate": {
                temporal = (LocalDate)srcValue;
                break;
            }
            case "java.time.LocalTime": {
                temporal = (LocalTime)srcValue;
                break;
            }
            case "java.util.Date": {
                temporal = new Timestamp(((java.util.Date)srcValue).getTime()).toLocalDateTime();
                break;
            }
            case "java.time.LocalDateTime": {
                temporal = (LocalDateTime)srcValue;
                break;
            }
            case "java.time.YearMonth": {
                temporal = (YearMonth)srcValue;
                break;
            }
            default: {
                return null;
            }
        }
        return TypeCast.Temporal2dateTime(temporal, srcEntityClassName, targetEntityClassName);
    }

    public static boolean CheckedDateTime(String srcEntityClassName, String targetEntityClassName) throws IOException {
        switch (srcEntityClassName) {
            case "com.xxdb.data.BasicMonth": 
            case "com.xxdb.data.BasicDate": 
            case "com.xxdb.data.BasicTime": 
            case "com.xxdb.data.BasicMinute": 
            case "com.xxdb.data.BasicSecond": 
            case "com.xxdb.data.BasicNanoTime": 
            case "com.xxdb.data.BasicTimestamp": 
            case "com.xxdb.data.BasicDateTime": 
            case "com.xxdb.data.BasicNanoTimestamp": 
            case "com.xxdb.data.BasicMonthVector": 
            case "com.xxdb.data.BasicDateVector": 
            case "com.xxdb.data.BasicTimeVector": 
            case "com.xxdb.data.BasicMinuteVector": 
            case "com.xxdb.data.BasicSecondVector": 
            case "com.xxdb.data.BasicNanoTimeVector": 
            case "com.xxdb.data.BasicTimestampVector": 
            case "com.xxdb.data.BasicDateTimeVector": 
            case "com.xxdb.data.BasicNanoTimestampVector": 
            case "com.xxdb.data.BasicAnyVector": 
            case "java.sql.Date": 
            case "java.util.Date": 
            case "java.sql.Time": 
            case "java.sql.Timestamp": 
            case "java.time.YearMonth": 
            case "java.time.LocalTime": 
            case "java.time.LocalDate": 
            case "java.time.LocalDateTime": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicMonth": 
                    case "com.xxdb.data.BasicDate": 
                    case "com.xxdb.data.BasicTime": 
                    case "com.xxdb.data.BasicMinute": 
                    case "com.xxdb.data.BasicSecond": 
                    case "com.xxdb.data.BasicNanoTime": 
                    case "com.xxdb.data.BasicTimestamp": 
                    case "com.xxdb.data.BasicDateTime": 
                    case "com.xxdb.data.BasicNanoTimestamp": {
                        return true;
                    }
                }
                throw new IOException(srcEntityClassName + " can not cast " + targetEntityClassName);
            }
        }
        return false;
    }

    public static Entity Tempos2dateTime(Object[] srcTempos, String srcEntityClassName, String targetEntityClassName) throws IOException {
        int size = srcTempos.length;
        switch (targetEntityClassName) {
            case "com.xxdb.data.BasicMonth": {
                BasicMonthVector targetVector = new BasicMonthVector(size);
                int index = 0;
                for (Object srcTemporal : srcTempos) {
                    targetVector.setMonth(index, (YearMonth)TypeCast.castTemporal(srcTemporal, YEAR_MONTH));
                    ++index;
                }
                return targetVector;
            }
            case "com.xxdb.data.BasicDate": {
                BasicDateVector targetVector = new BasicDateVector(size);
                int index = 0;
                for (Object srcTemporal : srcTempos) {
                    targetVector.setDate(index, (LocalDate)TypeCast.castTemporal(srcTemporal, LOCAL_DATE));
                    ++index;
                }
                return targetVector;
            }
            case "com.xxdb.data.BasicTime": {
                BasicTimeVector targetVector = new BasicTimeVector(size);
                int index = 0;
                for (Object srcTemporal : srcTempos) {
                    targetVector.setTime(index, (LocalTime)TypeCast.castTemporal(srcTemporal, LOCAL_TIME));
                    ++index;
                }
                return targetVector;
            }
            case "com.xxdb.data.BasicMinute": {
                BasicMinuteVector targetVector = new BasicMinuteVector(size);
                int index = 0;
                for (Object srcTemporal : srcTempos) {
                    targetVector.setMinute(index, (LocalTime)TypeCast.castTemporal(srcTemporal, LOCAL_TIME));
                    ++index;
                }
                return targetVector;
            }
            case "com.xxdb.data.BasicSecond": {
                BasicSecondVector targetVector = new BasicSecondVector(size);
                int index = 0;
                for (Object srcTemporal : srcTempos) {
                    targetVector.setSecond(index, (LocalTime)TypeCast.castTemporal(srcTemporal, LOCAL_TIME));
                    ++index;
                }
                return targetVector;
            }
            case "com.xxdb.data.BasicNanoTime": {
                BasicNanoTimeVector targetVector = new BasicNanoTimeVector(size);
                int index = 0;
                for (Object srcTemporal : srcTempos) {
                    targetVector.setNanoTime(index, (LocalTime)TypeCast.castTemporal(srcTemporal, LOCAL_TIME));
                    ++index;
                }
                return targetVector;
            }
            case "com.xxdb.data.BasicTimestamp": {
                BasicTimestampVector targetVector = new BasicTimestampVector(size);
                int index = 0;
                for (Object srcTemporal : srcTempos) {
                    targetVector.setTimestamp(index, (LocalDateTime)TypeCast.castTemporal(srcTemporal, LOCAL_DATETIME));
                    ++index;
                }
                return targetVector;
            }
            case "com.xxdb.data.BasicDateTime": {
                BasicDateTimeVector targetVector = new BasicDateTimeVector(size);
                int index = 0;
                for (Object srcTemporal : srcTempos) {
                    targetVector.setDateTime(index, (LocalDateTime)TypeCast.castTemporal(srcTemporal, LOCAL_DATETIME));
                    ++index;
                }
                return targetVector;
            }
            case "com.xxdb.data.BasicNanoTimestamp": {
                BasicNanoTimestampVector targetVector = new BasicNanoTimestampVector(size);
                int index = 0;
                for (Object srcTemporal : srcTempos) {
                    targetVector.setNanoTimestamp(index, (LocalDateTime)TypeCast.castTemporal(srcTemporal, LOCAL_DATETIME));
                    ++index;
                }
                return targetVector;
            }
        }
        throw new IOException(srcEntityClassName + " can not cast " + targetEntityClassName);
    }

    public static Entity Temporal2dateTime(Temporal srcTemporal, String srcEntityClassName, String targetEntityClassName) throws IOException {
        switch (targetEntityClassName) {
            case "com.xxdb.data.BasicMonth": {
                return new BasicMonth((YearMonth)TypeCast.castTemporal(srcTemporal, YEAR_MONTH));
            }
            case "com.xxdb.data.BasicDate": {
                return new BasicDate((LocalDate)TypeCast.castTemporal(srcTemporal, LOCAL_DATE));
            }
            case "com.xxdb.data.BasicTime": {
                return new BasicTime((LocalTime)TypeCast.castTemporal(srcTemporal, LOCAL_TIME));
            }
            case "com.xxdb.data.BasicMinute": {
                return new BasicMinute((LocalTime)TypeCast.castTemporal(srcTemporal, LOCAL_TIME));
            }
            case "com.xxdb.data.BasicSecond": {
                return new BasicSecond((LocalTime)TypeCast.castTemporal(srcTemporal, LOCAL_TIME));
            }
            case "com.xxdb.data.BasicNanoTime": {
                return new BasicNanoTime((LocalTime)TypeCast.castTemporal(srcTemporal, LOCAL_TIME));
            }
            case "com.xxdb.data.BasicTimestamp": {
                return new BasicTimestamp((LocalDateTime)TypeCast.castTemporal(srcTemporal, LOCAL_DATETIME));
            }
            case "com.xxdb.data.BasicDateTime": {
                return new BasicDateTime((LocalDateTime)TypeCast.castTemporal(srcTemporal, LOCAL_DATETIME));
            }
            case "com.xxdb.data.BasicNanoTimestamp": {
                return new BasicNanoTimestamp((LocalDateTime)TypeCast.castTemporal(srcTemporal, LOCAL_DATETIME));
            }
        }
        throw new IOException(srcEntityClassName + " can not cast " + targetEntityClassName);
    }

    public static Entity dateTime_db2db(Entity srcEntity, String targetEntityClassName) throws Exception {
        String srcEntityClassName = null;
        if (srcEntity.isScalar()) {
            Temporal srcTemporal = null;
            srcEntityClassName = srcEntity.getClass().getName();
            if (!TypeCast.CheckedDateTime(srcEntityClassName, targetEntityClassName)) {
                return null;
            }
            switch (srcEntityClassName) {
                case "com.xxdb.data.BasicMonth": 
                case "com.xxdb.data.BasicDate": 
                case "com.xxdb.data.BasicTime": 
                case "com.xxdb.data.BasicMinute": 
                case "com.xxdb.data.BasicSecond": 
                case "com.xxdb.data.BasicNanoTime": 
                case "com.xxdb.data.BasicTimestamp": 
                case "com.xxdb.data.BasicDateTime": 
                case "com.xxdb.data.BasicNanoTimestamp": {
                    srcTemporal = ((Scalar)srcEntity).getTemporal();
                    return TypeCast.Temporal2dateTime(srcTemporal, srcEntityClassName, targetEntityClassName);
                }
            }
            throw new IOException(srcEntityClassName + " can not cast " + targetEntityClassName);
        }
        if (srcEntity.isVector()) {
            if (srcEntity.rows() == 0) {
                throw new IOException("Vector rows can not 0");
            }
            srcEntityClassName = srcEntity.getClass().getName();
            String srcScalarFromVectorClassName = ((Vector)srcEntity).get(0).getClass().getName();
            if (!TypeCast.CheckedDateTime(srcScalarFromVectorClassName, targetEntityClassName)) {
                return null;
            }
            Object[] srcTempos = null;
            switch (srcEntityClassName) {
                case "com.xxdb.data.BasicMonthVector": 
                case "com.xxdb.data.BasicDateVector": 
                case "com.xxdb.data.BasicTimeVector": 
                case "com.xxdb.data.BasicMinuteVector": 
                case "com.xxdb.data.BasicSecondVector": 
                case "com.xxdb.data.BasicNanoTimeVector": 
                case "com.xxdb.data.BasicTimestampVector": 
                case "com.xxdb.data.BasicDateTimeVector": 
                case "com.xxdb.data.BasicNanoTimestampVector": {
                    int size = srcEntity.rows();
                    srcTempos = new Temporal[size];
                    for (int i = 0; i < size; ++i) {
                        srcTempos[i] = ((Scalar)((Vector)srcEntity).get(i)).getTemporal();
                    }
                    return TypeCast.Tempos2dateTime(srcTempos, srcEntityClassName, targetEntityClassName);
                }
                case "com.xxdb.data.BasicAnyVector": {
                    if (!TypeCast.CheckedDateTime(srcScalarFromVectorClassName, targetEntityClassName)) {
                        return null;
                    }
                    switch (srcScalarFromVectorClassName) {
                        case "com.xxdb.data.BasicMonth": 
                        case "com.xxdb.data.BasicDate": 
                        case "com.xxdb.data.BasicTime": 
                        case "com.xxdb.data.BasicMinute": 
                        case "com.xxdb.data.BasicSecond": 
                        case "com.xxdb.data.BasicNanoTime": 
                        case "com.xxdb.data.BasicTimestamp": 
                        case "com.xxdb.data.BasicDateTime": 
                        case "com.xxdb.data.BasicNanoTimestamp": {
                            int size = srcEntity.rows();
                            srcTempos = new Temporal[size];
                            for (int i = 0; i < size; ++i) {
                                srcTempos[i] = ((Scalar)((Vector)srcEntity).get(i)).getTemporal();
                            }
                            return TypeCast.Tempos2dateTime(srcTempos, srcScalarFromVectorClassName, targetEntityClassName);
                        }
                    }
                    throw new IOException(srcScalarFromVectorClassName + " can not cast " + targetEntityClassName);
                }
            }
            return null;
        }
        throw new IOException(srcEntity.getClass().getName() + " can not cast " + srcEntityClassName);
    }

    public static Entity dateTimeArr2Vector(Object[] srcValue, String targetEntityClassName) throws IOException {
        int size = srcValue.length;
        if (size == 0) {
            throw new IOException(srcValue + "size can not 0 ");
        }
        Object srcValueFromArr = srcValue[0];
        String srcValueFromListClassName = srcValueFromArr.getClass().getName();
        if (srcValueFromArr instanceof Scalar) {
            throw new IOException("you need use com.xxdb.data.Vector load com.xxdb.data.Scalar");
        }
        if (!TypeCast.CheckedDateTime(srcValueFromListClassName, targetEntityClassName)) {
            return null;
        }
        return TypeCast.Tempos2dateTime(srcValue, srcValueFromListClassName, targetEntityClassName);
    }

    public static boolean CheckedBasicType(String srcEntityClassName, String targetEntityClassName) throws IOException {
        switch (srcEntityClassName) {
            case "com.xxdb.data.BasicBoolean": 
            case "com.xxdb.data.BasicByte": 
            case "com.xxdb.data.BasicInt": 
            case "com.xxdb.data.BasicShort": 
            case "com.xxdb.data.BasicLong": 
            case "com.xxdb.data.BasicFloat": 
            case "com.xxdb.data.BasicDouble": 
            case "com.xxdb.data.BasicString": 
            case "com.xxdb.data.BasicBooleanVector": 
            case "com.xxdb.data.BasicByteVector": 
            case "com.xxdb.data.BasicIntVector": 
            case "com.xxdb.data.BasicShortVector": 
            case "com.xxdb.data.BasicLongVector": 
            case "com.xxdb.data.BasicFloatVector": 
            case "com.xxdb.data.BasicDoubleVector": 
            case "com.xxdb.data.BasicStringVector": 
            case "com.xxdb.data.BasicAnyVector": 
            case "java.lang.Boolean": 
            case "java.lang.Byte": 
            case "java.lang.Character": 
            case "java.lang.Short": 
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Float": 
            case "java.lang.Double": 
            case "java.lang.String": 
            case "[Z": 
            case "[B": 
            case "[C": 
            case "[S": 
            case "[I": 
            case "[J": 
            case "[F": 
            case "[D": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        return true;
                    }
                }
                throw new IOException(srcEntityClassName + " can not cast " + targetEntityClassName);
            }
        }
        return false;
    }

    public static Entity basicTypeArr2Vector(Object[] srcValue, String targetEntityClassName) throws IOException {
        int size = srcValue.length;
        if (size == 0) {
            throw new IOException(srcValue + "size can not 0 ");
        }
        Object srcValueFromArr = srcValue[0];
        String srcValueFromListClassName = srcValueFromArr.getClass().getName();
        if (srcValueFromArr instanceof Scalar) {
            throw new IOException("you need use com.xxdb.data.Vector load com.xxdb.data.Scalar");
        }
        if (!TypeCast.CheckedBasicType(srcValueFromListClassName, targetEntityClassName)) {
            return null;
        }
        switch (srcValueFromListClassName) {
            case "java.lang.Boolean": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicBooleanVector targetVector = new BasicBooleanVector(size);
                        int index = 0;
                        if (srcValue instanceof Boolean[]) {
                            Boolean[] booleans;
                            Boolean[] booleanArray = booleans = (Boolean[])srcValue;
                            int n = booleanArray.length;
                            for (int i = 0; i < n; ++i) {
                                boolean item = booleanArray[i];
                                targetVector.setBoolean(index, item);
                                ++index;
                            }
                        } else {
                            for (Object item : srcValue) {
                                targetVector.setBoolean(index, (Boolean)item);
                                ++index;
                            }
                        }
                        return targetVector;
                    }
                }
                throw new IOException(srcValueFromListClassName + " can not cast to " + targetEntityClassName);
            }
            case "java.lang.Byte": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicByteVector targetVector = new BasicByteVector(size);
                        int index = 0;
                        if (srcValue instanceof Byte[]) {
                            Byte[] bytes;
                            Byte[] byteArray = bytes = (Byte[])srcValue;
                            int n = byteArray.length;
                            for (int item = 0; item < n; ++item) {
                                byte item2 = byteArray[item];
                                targetVector.setByte(index, item2);
                                ++index;
                            }
                        } else {
                            for (Object item : srcValue) {
                                targetVector.setByte(index, (Byte)item);
                                ++index;
                            }
                        }
                        return targetVector;
                    }
                }
                throw new IOException(srcValueFromListClassName + " can not cast to " + targetEntityClassName);
            }
            case "java.lang.Character": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicByteVector targetVector = new BasicByteVector(size);
                        int index = 0;
                        if (srcValue instanceof Character[]) {
                            Character[] characters;
                            Character[] characterArray = characters = (Character[])srcValue;
                            int n = characterArray.length;
                            for (int item = 0; item < n; ++item) {
                                char item3 = characterArray[item].charValue();
                                targetVector.setByte(index, (byte)(item3 & 0xFF));
                                ++index;
                            }
                        } else {
                            for (Object item : srcValue) {
                                targetVector.setByte(index, (byte)(((Character)item).charValue() & 0xFF));
                                ++index;
                            }
                        }
                        return targetVector;
                    }
                }
                throw new IOException(srcValueFromListClassName + " can not cast to " + targetEntityClassName);
            }
            case "java.lang.Integer": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicIntVector targetVector = new BasicIntVector(size);
                        int index = 0;
                        if (srcValue instanceof Integer[]) {
                            Integer[] integers;
                            Integer[] integerArray = integers = (Integer[])srcValue;
                            int n = integerArray.length;
                            for (int item = 0; item < n; ++item) {
                                int item4 = integerArray[item];
                                targetVector.setInt(index, item4);
                                ++index;
                            }
                        } else {
                            for (Object item : srcValue) {
                                targetVector.setInt(index, (Integer)item);
                                ++index;
                            }
                        }
                        return targetVector;
                    }
                }
                throw new IOException(srcValueFromListClassName + " can not cast to " + targetEntityClassName);
            }
            case "java.lang.Short": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicShortVector targetVector = new BasicShortVector(size);
                        int index = 0;
                        if (srcValue instanceof Short[]) {
                            Short[] shorts;
                            Short[] shortArray = shorts = (Short[])srcValue;
                            int n = shortArray.length;
                            for (int item = 0; item < n; ++item) {
                                short item5 = shortArray[item];
                                targetVector.setShort(index, item5);
                                ++index;
                            }
                        } else {
                            for (Object item : srcValue) {
                                targetVector.setShort(index, (Short)item);
                                ++index;
                            }
                        }
                        return targetVector;
                    }
                }
                throw new IOException(srcValueFromListClassName + " can not cast to " + targetEntityClassName);
            }
            case "java.lang.Long": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicLongVector targetVector = new BasicLongVector(size);
                        int index = 0;
                        if (srcValue instanceof Long[]) {
                            Long[] longs;
                            Long[] longArray = longs = (Long[])srcValue;
                            int n = longArray.length;
                            for (int item = 0; item < n; ++item) {
                                long item6 = longArray[item];
                                targetVector.setLong(index, item6);
                                ++index;
                            }
                        } else {
                            for (Object item : srcValue) {
                                targetVector.setLong(index, (Long)item);
                                ++index;
                            }
                        }
                        return targetVector;
                    }
                }
                throw new IOException(srcValueFromListClassName + " can not cast to " + targetEntityClassName);
            }
            case "java.lang.Float": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicFloatVector targetVector = new BasicFloatVector(size);
                        int index = 0;
                        if (srcValue instanceof Float[]) {
                            Float[] floats;
                            Float[] floatArray = floats = (Float[])srcValue;
                            int n = floatArray.length;
                            for (int item = 0; item < n; ++item) {
                                float item7 = floatArray[item].floatValue();
                                targetVector.setFloat(index, item7);
                                ++index;
                            }
                        } else {
                            for (Object item : srcValue) {
                                targetVector.setFloat(index, ((Float)item).floatValue());
                                ++index;
                            }
                        }
                        return targetVector;
                    }
                }
                throw new IOException(srcValueFromListClassName + " can not cast to " + targetEntityClassName);
            }
            case "java.lang.Double": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicDoubleVector targetVector = new BasicDoubleVector(size);
                        int index = 0;
                        if (srcValue instanceof Double[]) {
                            Double[] doubles;
                            Double[] doubleArray = doubles = (Double[])srcValue;
                            int n = doubleArray.length;
                            for (int item = 0; item < n; ++item) {
                                double item8 = doubleArray[item];
                                targetVector.setDouble(index, item8);
                                ++index;
                            }
                        } else {
                            for (Object item : srcValue) {
                                targetVector.setDouble(index, (Double)item);
                                ++index;
                            }
                        }
                        return targetVector;
                    }
                }
                throw new IOException(srcValueFromListClassName + " can not cast to " + targetEntityClassName);
            }
            case "java.lang.String": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicString": {
                        if (srcValue instanceof String[]) {
                            String[] strings = (String[])srcValue;
                            return new BasicStringVector(strings);
                        }
                        BasicStringVector targetVector = new BasicStringVector(size);
                        int index = 0;
                        for (Object item : srcValue) {
                            targetVector.setString(index, (String)item);
                            ++index;
                        }
                        return targetVector;
                    }
                }
                throw new IOException(srcValueFromListClassName + " can not cast to " + targetEntityClassName);
            }
        }
        return null;
    }

    public static Entity basicType_db2db(Entity srcEntity, String targetEntityClassName) throws IOException {
        String srcEntityClassName = null;
        if (srcEntity.isScalar()) {
            srcEntityClassName = srcEntity.getClass().getName();
            if (!TypeCast.CheckedBasicType(srcEntityClassName, targetEntityClassName)) {
                return null;
            }
            switch (srcEntityClassName) {
                case "com.xxdb.data.BasicBoolean": 
                case "com.xxdb.data.BasicByte": 
                case "com.xxdb.data.BasicInt": 
                case "com.xxdb.data.BasicShort": 
                case "com.xxdb.data.BasicLong": 
                case "com.xxdb.data.BasicFloat": 
                case "com.xxdb.data.BasicDouble": {
                    switch (targetEntityClassName) {
                        case "com.xxdb.data.BasicBoolean": 
                        case "com.xxdb.data.BasicByte": 
                        case "com.xxdb.data.BasicInt": 
                        case "com.xxdb.data.BasicShort": 
                        case "com.xxdb.data.BasicLong": 
                        case "com.xxdb.data.BasicFloat": 
                        case "com.xxdb.data.BasicDouble": 
                        case "com.xxdb.data.BasicString": {
                            return srcEntity;
                        }
                    }
                    throw new IOException(srcEntityClassName + " can not cast " + targetEntityClassName);
                }
                case "com.xxdb.data.BasicString": {
                    switch (targetEntityClassName) {
                        case "com.xxdb.data.BasicString": {
                            return srcEntity;
                        }
                    }
                    throw new IOException(srcEntityClassName + " can not cast to " + targetEntityClassName);
                }
            }
            return null;
        }
        if (srcEntity.isVector()) {
            if (srcEntity.rows() == 0) {
                throw new IOException("Vector rows can not 0");
            }
            srcEntityClassName = srcEntity.getClass().getName();
            String srcScalarFromVectorClassName = ((Vector)srcEntity).get(0).getClass().getName();
            if (!TypeCast.CheckedBasicType(srcEntityClassName, targetEntityClassName)) {
                return null;
            }
            switch (srcEntityClassName) {
                case "com.xxdb.data.BasicBooleanVector": 
                case "com.xxdb.data.BasicByteVector": 
                case "com.xxdb.data.BasicIntVector": 
                case "com.xxdb.data.BasicShortVector": 
                case "com.xxdb.data.BasicLongVector": 
                case "com.xxdb.data.BasicFloatVector": 
                case "com.xxdb.data.BasicDoubleVector": {
                    switch (targetEntityClassName) {
                        case "com.xxdb.data.BasicBoolean": 
                        case "com.xxdb.data.BasicByte": 
                        case "com.xxdb.data.BasicInt": 
                        case "com.xxdb.data.BasicShort": 
                        case "com.xxdb.data.BasicLong": 
                        case "com.xxdb.data.BasicFloat": 
                        case "com.xxdb.data.BasicDouble": 
                        case "com.xxdb.data.BasicString": {
                            return srcEntity;
                        }
                    }
                    throw new IOException(srcEntityClassName + " can not cast " + targetEntityClassName);
                }
                case "com.xxdb.data.BasicStringVector": {
                    switch (targetEntityClassName) {
                        case "com.xxdb.data.BasicString": {
                            return srcEntity;
                        }
                    }
                    throw new IOException(srcEntityClassName + " can not cast to " + targetEntityClassName);
                }
                case "com.xxdb.data.BasicAnyVector": {
                    switch (srcScalarFromVectorClassName) {
                        case "com.xxdb.data.BasicBoolean": 
                        case "com.xxdb.data.BasicByte": 
                        case "com.xxdb.data.BasicInt": 
                        case "com.xxdb.data.BasicShort": 
                        case "com.xxdb.data.BasicLong": 
                        case "com.xxdb.data.BasicFloat": 
                        case "com.xxdb.data.BasicDouble": {
                            switch (targetEntityClassName) {
                                case "com.xxdb.data.BasicBoolean": 
                                case "com.xxdb.data.BasicByte": 
                                case "com.xxdb.data.BasicInt": 
                                case "com.xxdb.data.BasicShort": 
                                case "com.xxdb.data.BasicLong": 
                                case "com.xxdb.data.BasicFloat": 
                                case "com.xxdb.data.BasicDouble": 
                                case "com.xxdb.data.BasicString": {
                                    return srcEntity;
                                }
                            }
                            throw new IOException(srcScalarFromVectorClassName + " can not cast " + targetEntityClassName);
                        }
                        case "com.xxdb.data.BasicString": {
                            switch (targetEntityClassName) {
                                case "com.xxdb.data.BasicString": {
                                    return srcEntity;
                                }
                            }
                            throw new IOException(srcScalarFromVectorClassName + " can not cast to " + targetEntityClassName);
                        }
                    }
                    return null;
                }
            }
        } else {
            throw new IOException(srcEntity.getClass().getName() + " can not cast " + srcEntityClassName);
        }
        return null;
    }

    public static Entity basicType_java2db(Object srcValue, String targetEntityClassName) throws IOException {
        if (srcValue instanceof Entity) {
            return null;
        }
        String srcValueClassName = srcValue.getClass().getName();
        if (!TypeCast.CheckedBasicType(srcValueClassName, targetEntityClassName)) {
            return null;
        }
        switch (srcValueClassName) {
            case "java.lang.Boolean": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        return new BasicBoolean((Boolean)srcValue);
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "java.lang.Byte": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        return new BasicByte((Byte)srcValue);
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "java.lang.Character": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        return new BasicByte((byte)(((Character)srcValue).charValue() & 0xFF));
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "java.lang.Integer": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        return new BasicInt((Integer)srcValue);
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "java.lang.Short": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        return new BasicShort((Short)srcValue);
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "java.lang.Long": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        return new BasicLong((Long)srcValue);
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "java.lang.Float": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        return new BasicFloat(((Float)srcValue).floatValue());
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "java.lang.Double": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        return new BasicDouble((Double)srcValue);
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "java.lang.String": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicString": {
                        return new BasicString((String)srcValue);
                    }
                }
                throw new IOException(srcValueClassName + " can not cast to " + targetEntityClassName);
            }
            case "[Z": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        boolean[] booleans = (boolean[])srcValue;
                        BasicBooleanVector targetVector = new BasicBooleanVector(booleans.length);
                        int index = 0;
                        for (boolean item : booleans) {
                            targetVector.setBoolean(index, item);
                            ++index;
                        }
                        return targetVector;
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "[B": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicByteVector targetVector = new BasicByteVector((byte[])srcValue);
                        return targetVector;
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "[C": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        char[] chars = (char[])srcValue;
                        BasicByteVector targetVector = new BasicByteVector(chars.length);
                        int index = 0;
                        for (char item : chars) {
                            targetVector.setByte(index, (byte)(item & 0xFF));
                            ++index;
                        }
                        return targetVector;
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "[S": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicShortVector targetVector = new BasicShortVector((short[])srcValue);
                        return targetVector;
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "[I": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicIntVector targetVector = new BasicIntVector((int[])srcValue);
                        return targetVector;
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "[J": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicLongVector targetVector = new BasicLongVector((long[])srcValue);
                        return targetVector;
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "[F": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicFloatVector targetVector = new BasicFloatVector((float[])srcValue);
                        return targetVector;
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
            case "[D": {
                switch (targetEntityClassName) {
                    case "com.xxdb.data.BasicBoolean": 
                    case "com.xxdb.data.BasicByte": 
                    case "com.xxdb.data.BasicInt": 
                    case "com.xxdb.data.BasicShort": 
                    case "com.xxdb.data.BasicLong": 
                    case "com.xxdb.data.BasicFloat": 
                    case "com.xxdb.data.BasicDouble": 
                    case "com.xxdb.data.BasicString": {
                        BasicDoubleVector targetVector = new BasicDoubleVector((double[])srcValue);
                        return targetVector;
                    }
                }
                throw new IOException(srcValueClassName + " can not cast  " + targetEntityClassName);
            }
        }
        return null;
    }

    public static Temporal getTemporal(Object value) throws Exception {
        switch (value.getClass().getName()) {
            case "com.xxdb.data.BasicMonth": 
            case "com.xxdb.data.BasicDate": 
            case "com.xxdb.data.BasicTime": 
            case "com.xxdb.data.BasicMinute": 
            case "com.xxdb.data.BasicSecond": 
            case "com.xxdb.data.BasicNanoTime": 
            case "com.xxdb.data.BasicTimestamp": 
            case "com.xxdb.data.BasicDateTime": 
            case "com.xxdb.data.BasicNanoTimestamp": {
                return ((Scalar)value).getTemporal();
            }
            case "java.util.Date": {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((java.util.Date)value);
                return new BasicTimestamp(calendar).getTemporal();
            }
            case "java.sql.Date": {
                return new BasicDate(((Date)value).toLocalDate()).getTemporal();
            }
            case "java.sql.Time": {
                return new BasicNanoTime(((Time)value).toLocalTime()).getTemporal();
            }
            case "java.sql.Timestamp": {
                return new BasicNanoTimestamp(((Timestamp)value).toLocalDateTime()).getTemporal();
            }
            case "java.time.LocalDate": {
                return new BasicDate((LocalDate)value).getTemporal();
            }
            case "java.time.LocalTime": {
                return new BasicNanoTime((LocalTime)value).getTemporal();
            }
            case "java.time.LocalDateTime": {
                return new BasicNanoTimestamp((LocalDateTime)value).getTemporal();
            }
            case "java.time.YearMonth": {
                return new BasicMonth((YearMonth)value).getTemporal();
            }
        }
        return null;
    }

    public static Object entity2java(Entity entity, String targetTemporalClassName) throws Exception {
        if (entity == null || ((Scalar)entity).isNull()) {
            return null;
        }
        if (!entity.isScalar()) {
            throw new IOException(entity.getClass().getName() + " must be scalar");
        }
        if (entity.getDataCategory() != Entity.DATA_CATEGORY.TEMPORAL) {
            switch (targetTemporalClassName) {
                case "java.lang.Boolean": {
                    switch (entity.getClass().getName()) {
                        case "com.xxdb.data.BasicBoolean": {
                            return ((BasicBoolean)entity).getBoolean();
                        }
                        case "com.xxdb.data.BasicByte": {
                            return ((BasicByte)entity).getByte() != 0;
                        }
                        case "com.xxdb.data.BasicInt": {
                            return ((BasicInt)entity).getInt() != 0;
                        }
                        case "com.xxdb.data.BasicShort": {
                            return ((BasicShort)entity).getShort() != 0;
                        }
                        case "com.xxdb.data.BasicLong": {
                            return ((BasicLong)entity).getLong() != 0L;
                        }
                        case "com.xxdb.data.BasicFloat": {
                            return ((BasicFloat)entity).getFloat() != 0.0f;
                        }
                        case "com.xxdb.data.BasicDouble": {
                            return ((BasicDouble)entity).getDouble() != 0.0;
                        }
                        case "com.xxdb.data.BasicString": {
                            String str = entity.getString();
                            try {
                                char chr;
                                int i;
                                for (i = 0; i < str.length() && (Character.isDigit(chr = str.charAt(i)) || chr == '-'); ++i) {
                                }
                                int value = Integer.valueOf(str.substring(0, i));
                                return value != 0;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                    }
                    throw new IOException(entity.getClass().getName() + " can not cast  " + targetTemporalClassName);
                }
                case "java.lang.Byte": {
                    switch (entity.getClass().getName()) {
                        case "com.xxdb.data.BasicBoolean": {
                            return ((BasicBoolean)entity).getBoolean();
                        }
                        case "com.xxdb.data.BasicByte": {
                            return ((BasicByte)entity).getByte();
                        }
                        case "com.xxdb.data.BasicInt": {
                            return ((BasicInt)entity).getInt();
                        }
                        case "com.xxdb.data.BasicShort": {
                            return ((BasicShort)entity).getShort();
                        }
                        case "com.xxdb.data.BasicLong": {
                            return ((BasicLong)entity).getLong();
                        }
                        case "com.xxdb.data.BasicFloat": {
                            return Float.valueOf(((BasicFloat)entity).getFloat());
                        }
                        case "com.xxdb.data.BasicDouble": {
                            return ((BasicDouble)entity).getDouble();
                        }
                        case "com.xxdb.data.BasicString": {
                            return Byte.valueOf(entity.getString());
                        }
                    }
                    throw new IOException(entity.getClass().getName() + " can not cast  " + targetTemporalClassName);
                }
                case "java.lang.Character": {
                    switch (entity.getClass().getName()) {
                        case "com.xxdb.data.BasicBoolean": {
                            return ((BasicBoolean)entity).getBoolean();
                        }
                        case "com.xxdb.data.BasicByte": {
                            return ((BasicByte)entity).getByte();
                        }
                        case "com.xxdb.data.BasicInt": {
                            return ((BasicInt)entity).getInt();
                        }
                        case "com.xxdb.data.BasicShort": {
                            return ((BasicShort)entity).getShort();
                        }
                        case "com.xxdb.data.BasicLong": {
                            return ((BasicLong)entity).getLong();
                        }
                        case "com.xxdb.data.BasicFloat": {
                            return Float.valueOf(((BasicFloat)entity).getFloat());
                        }
                        case "com.xxdb.data.BasicDouble": {
                            return ((BasicDouble)entity).getDouble();
                        }
                    }
                    throw new IOException(entity.getClass().getName() + " can not cast  " + targetTemporalClassName);
                }
                case "java.lang.Integer": {
                    switch (entity.getClass().getName()) {
                        case "com.xxdb.data.BasicBoolean": {
                            return ((BasicBoolean)entity).getBoolean();
                        }
                        case "com.xxdb.data.BasicByte": {
                            return ((BasicByte)entity).getByte();
                        }
                        case "com.xxdb.data.BasicInt": {
                            return ((BasicInt)entity).getInt();
                        }
                        case "com.xxdb.data.BasicShort": {
                            return ((BasicShort)entity).getShort();
                        }
                        case "com.xxdb.data.BasicLong": {
                            return ((BasicLong)entity).getLong();
                        }
                        case "com.xxdb.data.BasicFloat": {
                            return Float.valueOf(((BasicFloat)entity).getFloat());
                        }
                        case "com.xxdb.data.BasicDouble": {
                            return ((BasicDouble)entity).getDouble();
                        }
                        case "com.xxdb.data.BasicString": {
                            return Integer.valueOf(entity.getString());
                        }
                    }
                    throw new IOException(entity.getClass().getName() + " can not cast  " + targetTemporalClassName);
                }
                case "java.lang.Short": {
                    switch (entity.getClass().getName()) {
                        case "com.xxdb.data.BasicBoolean": {
                            return ((BasicBoolean)entity).getBoolean();
                        }
                        case "com.xxdb.data.BasicByte": {
                            return ((BasicByte)entity).getByte();
                        }
                        case "com.xxdb.data.BasicInt": {
                            return ((BasicInt)entity).getInt();
                        }
                        case "com.xxdb.data.BasicShort": {
                            return ((BasicShort)entity).getShort();
                        }
                        case "com.xxdb.data.BasicLong": {
                            return ((BasicLong)entity).getLong();
                        }
                        case "com.xxdb.data.BasicFloat": {
                            return Float.valueOf(((BasicFloat)entity).getFloat());
                        }
                        case "com.xxdb.data.BasicDouble": {
                            return ((BasicDouble)entity).getDouble();
                        }
                        case "com.xxdb.data.BasicString": {
                            return Short.valueOf(entity.getString());
                        }
                    }
                    throw new IOException(entity.getClass().getName() + " can not cast  " + targetTemporalClassName);
                }
                case "java.lang.Long": {
                    switch (entity.getClass().getName()) {
                        case "com.xxdb.data.BasicBoolean": {
                            return ((BasicBoolean)entity).getBoolean();
                        }
                        case "com.xxdb.data.BasicByte": {
                            return ((BasicByte)entity).getByte();
                        }
                        case "com.xxdb.data.BasicInt": {
                            return ((BasicInt)entity).getInt();
                        }
                        case "com.xxdb.data.BasicShort": {
                            return ((BasicShort)entity).getShort();
                        }
                        case "com.xxdb.data.BasicLong": {
                            return ((BasicLong)entity).getLong();
                        }
                        case "com.xxdb.data.BasicFloat": {
                            return Float.valueOf(((BasicFloat)entity).getFloat());
                        }
                        case "com.xxdb.data.BasicDouble": {
                            return ((BasicDouble)entity).getDouble();
                        }
                        case "com.xxdb.data.BasicString": {
                            return Long.valueOf(entity.getString());
                        }
                    }
                    throw new IOException(entity.getClass().getName() + " can not cast  " + targetTemporalClassName);
                }
                case "java.lang.Float": {
                    switch (entity.getClass().getName()) {
                        case "com.xxdb.data.BasicBoolean": {
                            return ((BasicBoolean)entity).getBoolean();
                        }
                        case "com.xxdb.data.BasicByte": {
                            return ((BasicByte)entity).getByte();
                        }
                        case "com.xxdb.data.BasicInt": {
                            return ((BasicInt)entity).getInt();
                        }
                        case "com.xxdb.data.BasicShort": {
                            return ((BasicShort)entity).getShort();
                        }
                        case "com.xxdb.data.BasicLong": {
                            return ((BasicLong)entity).getLong();
                        }
                        case "com.xxdb.data.BasicFloat": {
                            return Float.valueOf(((BasicFloat)entity).getFloat());
                        }
                        case "com.xxdb.data.BasicDouble": {
                            return ((BasicDouble)entity).getDouble();
                        }
                        case "com.xxdb.data.BasicString": {
                            return Float.valueOf(entity.getString());
                        }
                    }
                    throw new IOException(entity.getClass().getName() + " can not cast  " + targetTemporalClassName);
                }
                case "java.lang.Double": {
                    switch (entity.getClass().getName()) {
                        case "com.xxdb.data.BasicBoolean": {
                            return ((BasicBoolean)entity).getBoolean();
                        }
                        case "com.xxdb.data.BasicByte": {
                            return ((BasicByte)entity).getByte();
                        }
                        case "com.xxdb.data.BasicInt": {
                            return ((BasicInt)entity).getInt();
                        }
                        case "com.xxdb.data.BasicShort": {
                            return ((BasicShort)entity).getShort();
                        }
                        case "com.xxdb.data.BasicLong": {
                            return ((BasicLong)entity).getLong();
                        }
                        case "com.xxdb.data.BasicFloat": {
                            return Float.valueOf(((BasicFloat)entity).getFloat());
                        }
                        case "com.xxdb.data.BasicDouble": {
                            return ((BasicDouble)entity).getDouble();
                        }
                        case "com.xxdb.data.BasicString": {
                            return Double.valueOf(entity.getString());
                        }
                    }
                    throw new IOException(entity.getClass().getName() + " can not cast " + targetTemporalClassName);
                }
                case "java.lang.String": {
                    return entity.getString();
                }
            }
            throw new IOException(entity.getClass().getName() + " can not cast " + targetTemporalClassName);
        }
        Temporal srcTemporal = ((Scalar)entity).getTemporal();
        if (srcTemporal == null) {
            return null;
        }
        String srcTemporalClassName = srcTemporal.getClass().getName();
        if (srcTemporalClassName.equals(targetTemporalClassName)) {
            return srcTemporal;
        }
        switch (targetTemporalClassName) {
            case "java.time.YearMonth": {
                switch (srcTemporalClassName) {
                    case "java.time.LocalTime": {
                        return YEARMONTH;
                    }
                    case "java.time.LocalDate": {
                        LocalDate localDate = (LocalDate)srcTemporal;
                        return YearMonth.of(localDate.getYear(), localDate.getMonthValue());
                    }
                    case "java.time.LocalDateTime": {
                        LocalDateTime localDateTime = (LocalDateTime)srcTemporal;
                        return YearMonth.of(localDateTime.getYear(), localDateTime.getMonthValue());
                    }
                }
                throw new SQLException("Unsupported temporal class " + entity.getClass().getName());
            }
            case "java.time.LocalDate": {
                switch (srcTemporalClassName) {
                    case "java.time.YearMonth": {
                        return ((YearMonth)srcTemporal).atDay(1);
                    }
                    case "java.time.LocalTime": {
                        return LOCALDATE;
                    }
                    case "java.time.LocalDateTime": {
                        return ((LocalDateTime)srcTemporal).toLocalDate();
                    }
                }
                throw new SQLException("Unsupported temporal class " + entity.getClass().getName());
            }
            case "java.time.LocalTime": {
                switch (srcTemporalClassName) {
                    case "java.time.YearMonth": {
                        return LOCALTIME;
                    }
                    case "java.time.LocalDate": {
                        return LOCALTIME;
                    }
                    case "java.time.LocalDateTime": {
                        return ((LocalDateTime)srcTemporal).toLocalTime();
                    }
                }
                throw new SQLException("Unsupported temporal class " + entity.getClass().getName());
            }
            case "java.time.LocalDateTime": {
                switch (srcTemporalClassName) {
                    case "java.time.YearMonth": {
                        return ((YearMonth)srcTemporal).atDay(1).atStartOfDay();
                    }
                    case "java.time.LocalDate": {
                        return ((LocalDate)srcTemporal).atStartOfDay();
                    }
                    case "java.time.LocalTime": {
                        LocalTime localTime = (LocalTime)srcTemporal;
                        return LocalDateTime.of(1970, 1, 1, localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano());
                    }
                }
                throw new SQLException("Unsupported temporal class " + entity.getClass().getName());
            }
            case "java.sql.Timestamp": {
                LocalDateTime localDateTime = null;
                switch (srcTemporalClassName) {
                    case "java.time.YearMonth": {
                        localDateTime = ((YearMonth)srcTemporal).atDay(1).atStartOfDay();
                        break;
                    }
                    case "java.time.LocalDate": {
                        localDateTime = ((LocalDate)srcTemporal).atStartOfDay();
                        break;
                    }
                    case "java.time.LocalTime": {
                        LocalTime localTime = (LocalTime)srcTemporal;
                        localDateTime = LocalDateTime.of(1970, 1, 1, localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano());
                        break;
                    }
                    case "java.time.LocalDateTime": {
                        localDateTime = (LocalDateTime)srcTemporal;
                        break;
                    }
                    default: {
                        throw new SQLException("Unsupported temporal class " + entity.getClass().getName());
                    }
                }
                return Timestamp.valueOf(localDateTime);
            }
            case "java.util.Date": {
                switch (srcTemporalClassName) {
                    case "java.time.YearMonth": {
                        YearMonth value = (YearMonth)srcTemporal;
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(value.getYear(), value.getMonthValue() - 1, 1, 0, 0, 0);
                        return calendar.getTime();
                    }
                    case "java.time.LocalDate": {
                        LocalDate value = (LocalDate)srcTemporal;
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(value.getYear(), value.getMonthValue() - 1, value.getDayOfMonth(), 0, 0, 0);
                        return calendar.getTime();
                    }
                    case "java.time.LocalTime": {
                        LocalTime value = (LocalTime)srcTemporal;
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(1970, 0, 1, value.getHour(), value.getMinute(), value.getSecond());
                        calendar.set(14, (int)((double)value.getNano() * 1.0E-6));
                        return calendar.getTime();
                    }
                    case "java.time.LocalDateTime": {
                        LocalDateTime value = (LocalDateTime)srcTemporal;
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(value.getYear(), value.getMonthValue() - 1, value.getDayOfMonth(), value.getHour(), value.getMinute(), value.getSecond());
                        calendar.set(14, (int)((double)value.getNano() * 1.0E-6));
                        return calendar.getTime();
                    }
                }
                throw new SQLException("Unsupported temporal class " + entity.getClass().getName());
            }
        }
        throw new SQLException(entity.getClass().getName() + " can't cast " + targetTemporalClassName);
    }

    public static Temporal castTemporal(Object srcValue, String targetTemporalClassName) {
        String srcTemporalClassName = srcValue.getClass().getName();
        Temporal srcTemporal = null;
        switch (srcTemporalClassName) {
            case "java.util.Date": {
                srcTemporal = new Timestamp(((java.util.Date)srcValue).getTime()).toLocalDateTime();
                srcTemporalClassName = srcTemporal.getClass().getName();
                break;
            }
            case "java.sql.Date": {
                srcTemporal = ((Date)srcValue).toLocalDate();
                srcTemporalClassName = srcTemporal.getClass().getName();
                break;
            }
            case "java.sql.Time": {
                srcTemporal = ((Time)srcValue).toLocalTime();
                srcTemporalClassName = srcTemporal.getClass().getName();
                break;
            }
            case "java.sql.Timestamp": {
                srcTemporal = ((Timestamp)srcValue).toLocalDateTime();
                srcTemporalClassName = srcTemporal.getClass().getName();
                break;
            }
            default: {
                srcTemporal = (Temporal)srcValue;
            }
        }
        switch (targetTemporalClassName) {
            case "java.time.YearMonth": {
                switch (srcTemporalClassName) {
                    case "java.time.LocalTime": {
                        return YEARMONTH;
                    }
                    case "java.time.LocalDate": {
                        LocalDate localDate = (LocalDate)srcTemporal;
                        return YearMonth.of(localDate.getYear(), localDate.getMonthValue());
                    }
                    case "java.time.LocalDateTime": {
                        LocalDateTime localDateTime = (LocalDateTime)srcTemporal;
                        return YearMonth.of(localDateTime.getYear(), localDateTime.getMonthValue());
                    }
                }
                return srcTemporal;
            }
            case "java.time.LocalDate": {
                switch (srcTemporalClassName) {
                    case "java.time.YearMonth": {
                        return ((YearMonth)srcTemporal).atEndOfMonth();
                    }
                    case "java.time.LocalTime": {
                        return LOCALDATE;
                    }
                    case "java.time.LocalDateTime": {
                        return ((LocalDateTime)srcTemporal).toLocalDate();
                    }
                }
                return srcTemporal;
            }
            case "java.time.LocalTime": {
                switch (srcTemporalClassName) {
                    case "java.time.YearMonth": {
                        return LOCALTIME;
                    }
                    case "java.time.LocalDate": {
                        return LOCALTIME;
                    }
                    case "java.time.LocalDateTime": {
                        return ((LocalDateTime)srcTemporal).toLocalTime();
                    }
                }
                return srcTemporal;
            }
            case "java.time.LocalDateTime": {
                switch (srcTemporalClassName) {
                    case "java.time.YearMonth": {
                        return ((YearMonth)srcTemporal).atEndOfMonth().atStartOfDay();
                    }
                    case "java.time.LocalDate": {
                        return ((LocalDate)srcTemporal).atStartOfDay();
                    }
                    case "java.time.LocalTime": {
                        LocalTime localTime = (LocalTime)srcTemporal;
                        return LocalDateTime.of(1970, 1, 1, localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano());
                    }
                }
                return srcTemporal;
            }
        }
        return srcTemporal;
    }

    static {
        String[] arr = new String[]{BASIC_VOID, BASIC_BOOLEAN, BASIC_BYTE, BASIC_SHORT, BASIC_INT, BASIC_LONG, BASIC_DATE, BASIC_MONTH, BASIC_TIME, BASIC_MINUTE, BASIC_SECOND, BASIC_DATETIME, BASIC_TIMESTAMP, BASIC_NANOTIME, BASIC_NANOTIMESTAMP, BASIC_FLOAT, BASIC_DOUBLE, "com.xxdb.data.BasicString", "com.xxdb.data.BasicString", BASIC_UUID, BASIC_DATEHOUR, BASIC_IPADDR, BASIC_INT128, "com.xxdb.data.BasicString", BASIC_COMPLEX, BASIC_POINT, BASIC_DURATION};
        Entity.DATA_TYPE[] datatypeArr = new Entity.DATA_TYPE[]{Entity.DATA_TYPE.DT_VOID, Entity.DATA_TYPE.DT_BOOL, Entity.DATA_TYPE.DT_BYTE, Entity.DATA_TYPE.DT_SHORT, Entity.DATA_TYPE.DT_INT, Entity.DATA_TYPE.DT_LONG, Entity.DATA_TYPE.DT_DATE, Entity.DATA_TYPE.DT_MONTH, Entity.DATA_TYPE.DT_TIME, Entity.DATA_TYPE.DT_MINUTE, Entity.DATA_TYPE.DT_SECOND, Entity.DATA_TYPE.DT_DATETIME, Entity.DATA_TYPE.DT_TIMESTAMP, Entity.DATA_TYPE.DT_NANOTIME, Entity.DATA_TYPE.DT_NANOTIMESTAMP, Entity.DATA_TYPE.DT_FLOAT, Entity.DATA_TYPE.DT_DOUBLE, Entity.DATA_TYPE.DT_SYMBOL, Entity.DATA_TYPE.DT_STRING, Entity.DATA_TYPE.DT_UUID, Entity.DATA_TYPE.DT_DATEHOUR, Entity.DATA_TYPE.DT_IPADDR, Entity.DATA_TYPE.DT_INT128, Entity.DATA_TYPE.DT_BLOB, Entity.DATA_TYPE.DT_COMPLEX, Entity.DATA_TYPE.DT_POINT, Entity.DATA_TYPE.DT_DURATION};
        int len = datatypeArr.length;
        for (int i = 0; i < len; ++i) {
            TYPEINT2STRING.put(datatypeArr[i].getValue(), arr[i]);
        }
        for (Scalar n : NULL) {
            n.setNull();
        }
    }
}

