/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.dolphindb.jdbc.Driver;
import com.dolphindb.jdbc.JDBCCallableStatement;
import com.dolphindb.jdbc.JDBCDataBaseMetaData;
import com.dolphindb.jdbc.JDBCPrepareStatement;
import com.dolphindb.jdbc.JDBCStatement;
import com.dolphindb.jdbc.Utils;
import com.xxdb.DBConnection;
import com.xxdb.comm.SqlStdEnum;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.Entity;
import com.xxdb.data.Vector;
import com.xxdb.io.ProgressListener;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executor;

public class JDBCConnection
implements Connection {
    private DBConnection dbConnection;
    private String hostName;
    private int port;
    private boolean success;
    private String database;
    private Vector tables;
    private String url;
    private DatabaseMetaData metaData;
    private String user;
    private String password;
    private Properties clientInfo = new Properties();

    public JDBCConnection(String url, Properties prop) throws SQLException {
        Driver.createConnection(url, prop);
    }

    protected JDBCConnection(Properties prop, String url) throws SQLException {
        this.url = url;
        this.clientInfo = prop;
        this.hostName = this.clientInfo.getProperty("hostName");
        this.port = Integer.parseInt(this.clientInfo.getProperty("port"));
        this.setUser(Optional.ofNullable(this.clientInfo.getProperty("user")).orElse(""));
        this.initDBConnectionInternal(prop);
        try {
            this.connectInternal(this.hostName, this.port, this.clientInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
            String msg = e.getMessage();
            if (msg.contains("Connection refused")) {
                throw new SQLException(MessageFormat.format("{0}  ==> hostName = {1}, port = {2}", msg, this.hostName, this.port));
            }
            throw new SQLException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initDBConnectionInternal(Properties clientInfo) {
        String sqlStdProp = this.clientInfo.getProperty("sqlStd");
        if (Objects.nonNull(sqlStdProp)) {
            SqlStdEnum sqlStd = SqlStdEnum.getByName(sqlStdProp);
            this.dbConnection = new DBConnection(sqlStd);
        } else {
            this.dbConnection = new DBConnection();
        }
    }

    public DBConnection getDBConnection() {
        return this.dbConnection;
    }

    public void setDBConnection(DBConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    private void connect(String hostname, int port, Properties prop, String appendInitScript) throws IOException, SQLException {
        String enableLoadBalanceStr;
        String tableAliasStr;
        boolean highAvailability;
        String userId = Optional.ofNullable(prop.getProperty("user")).orElse("");
        String password = Optional.ofNullable(prop.getProperty("password")).orElse("");
        String initialScript = Optional.ofNullable(prop.getProperty("initialScript")).map(Utils::changeCase).orElse("");
        if (initialScript.equals("select 1")) {
            initialScript = "select 1 as val";
        }
        if (appendInitScript != null) {
            initialScript = !initialScript.isEmpty() ? appendInitScript + "\n" + initialScript : appendInitScript;
        }
        String highAvailabilityStr = prop.getProperty("highAvailability");
        String enableHighAvailabilityStr = prop.getProperty("enableHighAvailability");
        if (highAvailabilityStr == null) {
            highAvailability = Boolean.parseBoolean(enableHighAvailabilityStr);
        } else if (enableHighAvailabilityStr == null) {
            highAvailability = Boolean.parseBoolean(highAvailabilityStr);
        } else {
            boolean param2;
            boolean param1 = Boolean.parseBoolean(highAvailabilityStr);
            if (param1 != (param2 = Boolean.parseBoolean(enableHighAvailabilityStr))) {
                throw new SQLException("The values of the \"highAvailability\" and \"enableHighAvailability\" parameters in the URL must be the same if both are configured. ");
            }
            highAvailability = param1;
        }
        String highAvailabilitySitesStr = prop.getProperty("highAvailabilitySites");
        String[] highAvailabilitySites = null;
        if (highAvailabilitySitesStr != null) {
            if (highAvailabilitySitesStr.contains(",")) {
                highAvailabilitySites = highAvailabilitySitesStr.split(",");
                highAvailabilitySites = (String[])Arrays.stream(highAvailabilitySites).map(String::trim).toArray(String[]::new);
            } else {
                highAvailabilitySites = highAvailabilitySitesStr.split(" ");
            }
        }
        if (Utils.isNotEmpty(tableAliasStr = prop.getProperty("tableAlias"))) {
            String tableAliasScript = Utils.parseTableAliasPropToScript(tableAliasStr);
            initialScript = !initialScript.isEmpty() ? initialScript + "\n" + tableAliasScript : tableAliasScript;
        }
        if (Objects.nonNull(enableLoadBalanceStr = prop.getProperty("enableLoadBalance"))) {
            boolean enableLoadBalance = Boolean.parseBoolean(enableLoadBalanceStr);
            this.success = this.dbConnection.connect(hostname, port, userId, password, initialScript, highAvailability, highAvailabilitySites, false, enableLoadBalance);
        } else {
            this.success = this.dbConnection.connect(hostname, port, userId, password, initialScript, highAvailability, highAvailabilitySites);
        }
    }

    private String loadTables(String dbName, List<String> tableNames, boolean ignoreError) {
        StringBuilder sbInitScript = new StringBuilder();
        for (String tableName : tableNames) {
            StringBuilder builder = new StringBuilder();
            builder.append("loadTable(\"").append(dbName).append("\", \"").append(tableName).append("\");");
            try {
                this.dbConnection.run(builder.toString());
                sbInitScript.append(tableName).append("=").append("loadTable(\"").append(dbName).append("\", \"").append(tableName).append("\");\n");
            }
            catch (Exception e) {
                if (ignoreError) {
                    System.out.println("Load table " + dbName + "." + tableName + " failed " + e.getMessage());
                    tableNames.remove(tableName);
                    continue;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return sbInitScript.toString();
    }

    private void connectInternal(String hostname, int port, Properties prop) throws SQLException, IOException {
        this.connect(hostname, port, prop, null);
        if (!this.success) {
            throw new SQLException("Connection is failed");
        }
        StringBuffer sbInitScript = this.buildInitialScript(prop);
        if (sbInitScript.length() > 0) {
            this.connect(hostname, port, prop, sbInitScript.toString());
        }
    }

    private StringBuffer buildInitialScript(Properties prop) throws IOException {
        int length;
        String hasScripts;
        StringBuffer sbInitScript = new StringBuffer();
        String[] key = new String[]{"databasePath"};
        String[] valueName = Utils.getProperties(prop, key);
        if (valueName[0] != null && valueName[0].length() > 0) {
            this.dbConnection.run("system_db = database(\"" + valueName[0] + "\");\n");
            if (valueName[0].trim().startsWith("dfs://")) {
                this.database = valueName[0];
                ArrayList<String> dbtables = new ArrayList<String>();
                if (Utils.isNotEmpty(prop.getProperty("tableName"))) {
                    String[] tableNames;
                    String tablename = prop.getProperty("tableName");
                    tablename = tablename.trim();
                    for (String tableName : tableNames = tablename.split(",")) {
                        if (tableName.isEmpty()) continue;
                        dbtables.add(tableName);
                    }
                    String script = this.loadTables(this.database, dbtables, false);
                    sbInitScript.append(script);
                } else {
                    Vector vector = (Vector)this.dbConnection.run("getTables(system_db)");
                    for (int i = 0; i < vector.rows(); ++i) {
                        dbtables.add(vector.getString(i));
                    }
                    String script = this.loadTables(this.database, dbtables, true);
                    sbInitScript.append(script);
                }
                this.tables = new BasicStringVector(dbtables);
            }
        }
        if ((hasScripts = prop.getProperty("length")) != null && (length = Integer.parseInt(prop.getProperty("length"))) > 0) {
            for (int i = 0; i < length; ++i) {
                sbInitScript.append(prop.getProperty("script" + i) + "\n");
            }
        }
        return sbInitScript;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkIsClosed();
        return new JDBCStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new JDBCPrepareStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new JDBCCallableStatement(this, sql);
    }

    @Override
    public String nativeSQL(String s) throws SQLException {
        this.checkIsClosed();
        return s;
    }

    @Override
    public void setAutoCommit(boolean b) throws SQLException {
        this.checkIsClosed();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkIsClosed();
        return true;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.dbConnection.close();
        this.dbConnection = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.dbConnection == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIsClosed();
        if (this.metaData == null) {
            this.metaData = new JDBCDataBaseMetaData(this, null);
        }
        return this.metaData;
    }

    @Override
    public void setReadOnly(boolean b) throws SQLException {
        this.checkIsClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkIsClosed();
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (Utils.isEmpty(catalog)) {
            throw new SQLException("The param catalog cannot be null or empty.");
        }
        StringBuilder sbInitScript = new StringBuilder();
        if (Objects.nonNull(this.tables)) {
            for (int i = 0; i < this.tables.rows(); ++i) {
                String tableName = this.tables.get(i).getString();
                try {
                    this.dbConnection.run(tableName);
                    this.dbConnection.run("undef(`" + tableName + ");");
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            this.dbConnection.run("system_db = database(\"" + catalog + "\");\n");
            ArrayList<String> dbtables = new ArrayList<String>();
            Vector vector = (Vector)this.dbConnection.run("getTables(system_db)");
            if (vector.rows() != 0) {
                for (int i = 0; i < vector.rows(); ++i) {
                    dbtables.add(vector.getString(i));
                }
            } else {
                throw new SQLException("The catalog '" + catalog + "' doesn't exist in server.");
            }
            this.database = catalog;
            String script = this.loadTables(this.database, dbtables, true);
            sbInitScript.append(script);
            this.tables = new BasicStringVector(dbtables);
            this.dbConnection.run(sbInitScript.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.database;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        Driver.unused("getTypeMap not implemented");
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        Driver.unused("setSavepoint not supported");
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        Driver.unused("setSavepoint not supported");
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Driver.unused("rollback not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Driver.unused("releaseSavepoint not supported");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIsClosed();
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIsClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIsClosed();
        return this.prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkIsClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkIsClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkIsClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        Driver.unused("createClob not implemented");
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        Driver.unused("createBlob not implemented");
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        Driver.unused("createNClob()");
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        Driver.unused("createSQLXML()");
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.dbConnection.isConnected();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.clientInfo.setProperty(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.clientInfo = properties;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        this.checkIsClosed();
        return aClass.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        this.checkIsClosed();
        return aClass.isInstance(this);
    }

    private void checkIsClosed() throws SQLException {
        if (this.dbConnection == null) {
            throw new SQLException("connection isClosed");
        }
        if (this == null || this.isClosed()) {
            throw new SQLException("connection isClosed");
        }
    }

    public Entity run(String function, List<Entity> arguments) throws IOException {
        return this.dbConnection.run(function, arguments);
    }

    public Entity run(String script) throws IOException {
        return this.dbConnection.run(script);
    }

    public Entity run(String script, int fetchSize) throws IOException {
        return this.dbConnection.run(script, (ProgressListener)null, 4, 2, fetchSize);
    }

    protected void upload(Map<String, Entity> variableObjectMap) throws IOException {
        this.dbConnection.upload(variableObjectMap);
    }

    public String getUrl() {
        return this.url;
    }

    public String getHostName() {
        if (this.dbConnection != null) {
            return this.dbConnection.getHostName();
        }
        return null;
    }

    public int getPort() {
        if (this.dbConnection != null) {
            return this.dbConnection.getPort();
        }
        return -1;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Deprecated
    public String getPassword() {
        return this.password;
    }

    @Deprecated
    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }
}

