/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import io.confluent.connect.jdbc.util.BytesUtil;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.QuoteMethod;

public class ExpressionBuilder {
    protected static final QuoteMethod DEFAULT_QUOTE_METHOD = QuoteMethod.ALWAYS;
    private final IdentifierRules rules;
    private final StringBuilder sb = new StringBuilder();
    private QuoteMethod quoteSqlIdentifiers = DEFAULT_QUOTE_METHOD;

    public static Transform<String> quote() {
        return (builder, input) -> builder.appendColumnName((String)input);
    }

    public static Transform<ColumnId> columnNames() {
        return (builder, input) -> builder.appendColumnName(input.name());
    }

    public static Transform<ColumnId> columnNamesWith(String appended) {
        return (builder, input) -> {
            builder.appendColumnName(input.name());
            builder.append(appended);
        };
    }

    public static Transform<ColumnId> placeholderInsteadOfColumnNames(String str) {
        return (builder, input) -> builder.append(str);
    }

    public static Transform<ColumnId> columnNamesWithPrefix(String prefix) {
        return (builder, input) -> {
            builder.append(prefix);
            builder.appendColumnName(input.name());
        };
    }

    public static ExpressionBuilder create() {
        return new ExpressionBuilder();
    }

    public ExpressionBuilder() {
        this(null);
    }

    public ExpressionBuilder(IdentifierRules rules) {
        this.rules = rules != null ? rules : IdentifierRules.DEFAULT;
    }

    public ExpressionBuilder setQuoteIdentifiers(QuoteMethod method) {
        this.quoteSqlIdentifiers = method != null ? method : DEFAULT_QUOTE_METHOD;
        return this;
    }

    public ExpressionBuilder escapeQuotesWith(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return this;
        }
        return new ExpressionBuilder(this.rules.escapeQuotesWith(prefix));
    }

    public ExpressionBuilder appendIdentifierDelimiter() {
        this.sb.append(this.rules.identifierDelimiter());
        return this;
    }

    public ExpressionBuilder appendLeadingQuote() {
        return this.appendLeadingQuote(QuoteMethod.ALWAYS);
    }

    protected ExpressionBuilder appendLeadingQuote(QuoteMethod method) {
        switch (method) {
            case ALWAYS: {
                this.sb.append(this.rules.leadingQuoteString());
                break;
            }
        }
        return this;
    }

    public ExpressionBuilder appendTrailingQuote() {
        return this.appendTrailingQuote(QuoteMethod.ALWAYS);
    }

    protected ExpressionBuilder appendTrailingQuote(QuoteMethod method) {
        switch (method) {
            case ALWAYS: {
                this.sb.append(this.rules.trailingQuoteString());
                break;
            }
        }
        return this;
    }

    public ExpressionBuilder appendStringQuote() {
        this.sb.append("'");
        return this;
    }

    public ExpressionBuilder appendStringQuoted(Object name) {
        this.appendStringQuote();
        this.sb.append(name);
        this.appendStringQuote();
        return this;
    }

    @Deprecated
    public ExpressionBuilder appendIdentifier(String name, boolean quoted) {
        return this.appendIdentifier(name, quoted ? QuoteMethod.ALWAYS : QuoteMethod.NEVER);
    }

    public ExpressionBuilder appendIdentifier(String name, QuoteMethod quoted) {
        this.appendLeadingQuote(quoted);
        this.sb.append(name);
        this.appendTrailingQuote(quoted);
        return this;
    }

    public ExpressionBuilder appendTableName(String name) {
        return this.appendTableName(name, this.quoteSqlIdentifiers);
    }

    public ExpressionBuilder appendTableName(String name, QuoteMethod quote) {
        this.appendLeadingQuote(quote);
        this.sb.append(name);
        this.appendTrailingQuote(quote);
        return this;
    }

    public ExpressionBuilder appendColumnName(String name) {
        return this.appendColumnName(name, this.quoteSqlIdentifiers);
    }

    public ExpressionBuilder appendColumnName(String name, QuoteMethod quote) {
        this.appendLeadingQuote(quote);
        this.sb.append(name);
        this.appendTrailingQuote(quote);
        return this;
    }

    public ExpressionBuilder appendIdentifierQuoted(String name) {
        this.appendLeadingQuote();
        this.sb.append(name);
        this.appendTrailingQuote();
        return this;
    }

    public ExpressionBuilder appendBinaryLiteral(byte[] value) {
        return this.append("x'").append(BytesUtil.toHex(value)).append("'");
    }

    public ExpressionBuilder appendNewLine() {
        this.sb.append(System.lineSeparator());
        return this;
    }

    @Deprecated
    public ExpressionBuilder append(Object obj, boolean useQuotes) {
        return this.append(obj, useQuotes ? QuoteMethod.ALWAYS : QuoteMethod.NEVER);
    }

    public ExpressionBuilder append(Object obj, QuoteMethod useQuotes) {
        if (obj instanceof Expressable) {
            ((Expressable)obj).appendTo(this, useQuotes);
        } else if (obj != null) {
            this.sb.append(obj);
        }
        return this;
    }

    public ExpressionBuilder append(Object obj) {
        return this.append(obj, this.quoteSqlIdentifiers);
    }

    public <T> ExpressionBuilder append(T obj, Transform<T> transform) {
        if (transform != null) {
            transform.apply(this, obj);
        } else {
            this.append(obj);
        }
        return this;
    }

    public ListBuilder<Object> appendList() {
        return new BasicListBuilder<Object>();
    }

    public ExpressionBuilder appendMultiple(String delimiter, String expression, int times) {
        for (int i = 0; i < times; ++i) {
            if (i > 0) {
                this.append(delimiter);
            }
            this.append(expression);
        }
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    @FunctionalInterface
    public static interface Transform<T> {
        public void apply(ExpressionBuilder var1, T var2);
    }

    @FunctionalInterface
    public static interface Expressable {
        public void appendTo(ExpressionBuilder var1, boolean var2);

        default public void appendTo(ExpressionBuilder builder, QuoteMethod useQuotes) {
            switch (useQuotes) {
                case ALWAYS: {
                    this.appendTo(builder, true);
                    break;
                }
            }
        }
    }

    protected class BasicListBuilder<T>
    implements ListBuilder<T> {
        private final String delimiter;
        private final Transform<T> transform;
        private boolean first = true;

        BasicListBuilder() {
            this(", ", null);
        }

        BasicListBuilder(String delimiter, Transform<T> transform) {
            this.delimiter = delimiter;
            this.transform = transform != null ? transform : ExpressionBuilder::append;
        }

        @Override
        public ListBuilder<T> delimitedBy(String delimiter) {
            return new BasicListBuilder<T>(delimiter, this.transform);
        }

        @Override
        public <R> ListBuilder<R> transformedBy(Transform<R> transform) {
            return new BasicListBuilder<R>(this.delimiter, transform);
        }

        @Override
        public ExpressionBuilder of(Iterable<? extends T> objects) {
            for (T obj : objects) {
                if (this.first) {
                    this.first = false;
                } else {
                    ExpressionBuilder.this.append(this.delimiter);
                }
                ExpressionBuilder.this.append(obj, this.transform);
            }
            return ExpressionBuilder.this;
        }
    }

    public static interface ListBuilder<T> {
        public ListBuilder<T> delimitedBy(String var1);

        public <R> ListBuilder<R> transformedBy(Transform<R> var1);

        public ExpressionBuilder of(Iterable<? extends T> var1);

        default public ExpressionBuilder of(Iterable<? extends T> objects1, Iterable<? extends T> objects2) {
            this.of(objects1);
            return this.of(objects2);
        }

        default public ExpressionBuilder of(Iterable<? extends T> objects1, Iterable<? extends T> objects2, Iterable<? extends T> objects3) {
            this.of(objects1);
            this.of(objects2);
            return this.of(objects3);
        }
    }
}

