/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink.metadata;

import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.metadata.SchemaPair;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

public class FieldsMetadata {
    public final Set<String> keyFieldNames;
    public final Set<String> nonKeyFieldNames;
    public final Map<String, SinkRecordField> allFields;

    public FieldsMetadata(Set<String> keyFieldNames, Set<String> nonKeyFieldNames, Map<String, SinkRecordField> allFields) {
        boolean allFieldsContained;
        boolean fieldCountsMatch = keyFieldNames.size() + nonKeyFieldNames.size() == allFields.size();
        boolean bl = allFieldsContained = allFields.keySet().containsAll(keyFieldNames) && allFields.keySet().containsAll(nonKeyFieldNames);
        if (!fieldCountsMatch || !allFieldsContained) {
            throw new IllegalArgumentException(String.format("Validation fail -- keyFieldNames:%s nonKeyFieldNames:%s allFields:%s", keyFieldNames, nonKeyFieldNames, allFields));
        }
        this.keyFieldNames = keyFieldNames;
        this.nonKeyFieldNames = nonKeyFieldNames;
        this.allFields = allFields;
    }

    public static FieldsMetadata extract(String tableName, JdbcSinkConfig.PrimaryKeyMode pkMode, List<String> configuredPkFields, Set<String> fieldsWhitelist, SchemaPair schemaPair) {
        return FieldsMetadata.extract(tableName, pkMode, configuredPkFields, fieldsWhitelist, schemaPair.keySchema, schemaPair.valueSchema);
    }

    public static FieldsMetadata extract(String tableName, JdbcSinkConfig.PrimaryKeyMode pkMode, List<String> configuredPkFields, Set<String> fieldsWhitelist, Schema keySchema, Schema valueSchema) {
        if (valueSchema != null && valueSchema.type() != Schema.Type.STRUCT) {
            throw new ConnectException("Value schema must be of type Struct");
        }
        HashMap<String, SinkRecordField> allFields = new HashMap<String, SinkRecordField>();
        LinkedHashSet<String> keyFieldNames = new LinkedHashSet<String>();
        switch (pkMode) {
            case NONE: {
                break;
            }
            case KAFKA: {
                FieldsMetadata.extractKafkaPk(tableName, configuredPkFields, allFields, keyFieldNames);
                break;
            }
            case RECORD_KEY: {
                FieldsMetadata.extractRecordKeyPk(tableName, configuredPkFields, keySchema, allFields, keyFieldNames);
                break;
            }
            case RECORD_VALUE: {
                FieldsMetadata.extractRecordValuePk(tableName, configuredPkFields, valueSchema, allFields, keyFieldNames);
                break;
            }
            default: {
                throw new ConnectException("Unknown primary key mode: " + pkMode);
            }
        }
        LinkedHashSet<String> nonKeyFieldNames = new LinkedHashSet<String>();
        if (valueSchema != null) {
            for (Object field : valueSchema.fields()) {
                if (keyFieldNames.contains(field.name()) || !fieldsWhitelist.isEmpty() && !fieldsWhitelist.contains(field.name())) continue;
                nonKeyFieldNames.add(field.name());
                Schema fieldSchema = field.schema();
                allFields.put(field.name(), new SinkRecordField(fieldSchema, field.name(), false));
            }
        }
        if (allFields.isEmpty()) {
            throw new ConnectException("No fields found using key and value schemas for table: " + tableName);
        }
        LinkedHashMap<String, SinkRecordField> allFieldsOrdered = new LinkedHashMap<String, SinkRecordField>();
        for (String fieldName : JdbcSinkConfig.DEFAULT_KAFKA_PK_NAMES) {
            if (!allFields.containsKey(fieldName)) continue;
            allFieldsOrdered.put(fieldName, (SinkRecordField)allFields.get(fieldName));
        }
        if (valueSchema != null) {
            for (Field field : valueSchema.fields()) {
                String fieldName = field.name();
                if (!allFields.containsKey(fieldName)) continue;
                allFieldsOrdered.put(fieldName, (SinkRecordField)allFields.get(fieldName));
            }
        }
        if (allFieldsOrdered.size() < allFields.size()) {
            ArrayList fieldKeys = new ArrayList(allFields.keySet());
            Collections.sort(fieldKeys);
            for (String fieldName : fieldKeys) {
                if (allFieldsOrdered.containsKey(fieldName)) continue;
                allFieldsOrdered.put(fieldName, (SinkRecordField)allFields.get(fieldName));
            }
        }
        return new FieldsMetadata(keyFieldNames, nonKeyFieldNames, allFieldsOrdered);
    }

    private static void extractKafkaPk(String tableName, List<String> configuredPkFields, Map<String, SinkRecordField> allFields, Set<String> keyFieldNames) {
        if (configuredPkFields.isEmpty()) {
            keyFieldNames.addAll(JdbcSinkConfig.DEFAULT_KAFKA_PK_NAMES);
        } else if (configuredPkFields.size() == 3) {
            keyFieldNames.addAll(configuredPkFields);
        } else {
            throw new ConnectException(String.format("PK mode for table '%s' is %s so there should either be no field names defined for defaults %s to be applicable, or exactly 3, defined fields are: %s", new Object[]{tableName, JdbcSinkConfig.PrimaryKeyMode.KAFKA, JdbcSinkConfig.DEFAULT_KAFKA_PK_NAMES, configuredPkFields}));
        }
        Iterator<String> it = keyFieldNames.iterator();
        String topicFieldName = it.next();
        allFields.put(topicFieldName, new SinkRecordField(Schema.STRING_SCHEMA, topicFieldName, true));
        String partitionFieldName = it.next();
        allFields.put(partitionFieldName, new SinkRecordField(Schema.INT32_SCHEMA, partitionFieldName, true));
        String offsetFieldName = it.next();
        allFields.put(offsetFieldName, new SinkRecordField(Schema.INT64_SCHEMA, offsetFieldName, true));
    }

    private static void extractRecordKeyPk(String tableName, List<String> configuredPkFields, Schema keySchema, Map<String, SinkRecordField> allFields, Set<String> keyFieldNames) {
        if (keySchema == null) {
            throw new ConnectException(String.format("PK mode for table '%s' is %s, but record key schema is missing", new Object[]{tableName, JdbcSinkConfig.PrimaryKeyMode.RECORD_KEY}));
        }
        Schema.Type keySchemaType = keySchema.type();
        if (keySchemaType.isPrimitive()) {
            if (configuredPkFields.size() != 1) {
                throw new ConnectException(String.format("Need exactly one PK column defined since the key schema for records is a primitive type, defined columns are: %s", configuredPkFields));
            }
            String fieldName = configuredPkFields.get(0);
            keyFieldNames.add(fieldName);
            allFields.put(fieldName, new SinkRecordField(keySchema, fieldName, true));
        } else if (keySchemaType == Schema.Type.STRUCT) {
            if (configuredPkFields.isEmpty()) {
                for (Field keyField : keySchema.fields()) {
                    keyFieldNames.add(keyField.name());
                }
            } else {
                for (String fieldName : configuredPkFields) {
                    Field keyField = keySchema.field(fieldName);
                    if (keyField != null) continue;
                    throw new ConnectException(String.format("PK mode for table '%s' is %s with configured PK fields %s, but record key schema does not contain field: %s", new Object[]{tableName, JdbcSinkConfig.PrimaryKeyMode.RECORD_KEY, configuredPkFields, fieldName}));
                }
                keyFieldNames.addAll(configuredPkFields);
            }
            for (String fieldName : keyFieldNames) {
                Schema fieldSchema = keySchema.field(fieldName).schema();
                allFields.put(fieldName, new SinkRecordField(fieldSchema, fieldName, true));
            }
        } else {
            throw new ConnectException("Key schema must be primitive type or Struct, but is of type: " + keySchemaType);
        }
    }

    private static void extractRecordValuePk(String tableName, List<String> configuredPkFields, Schema valueSchema, Map<String, SinkRecordField> allFields, Set<String> keyFieldNames) {
        if (valueSchema == null) {
            throw new ConnectException(String.format("PK mode for table '%s' is %s, but record value schema is missing", new Object[]{tableName, JdbcSinkConfig.PrimaryKeyMode.RECORD_VALUE}));
        }
        if (configuredPkFields.isEmpty()) {
            for (Field keyField : valueSchema.fields()) {
                keyFieldNames.add(keyField.name());
            }
        } else {
            for (String fieldName : configuredPkFields) {
                if (valueSchema.field(fieldName) != null) continue;
                throw new ConnectException(String.format("PK mode for table '%s' is %s with configured PK fields %s, but record value schema does not contain field: %s", new Object[]{tableName, JdbcSinkConfig.PrimaryKeyMode.RECORD_VALUE, configuredPkFields, fieldName}));
            }
            keyFieldNames.addAll(configuredPkFields);
        }
        for (String fieldName : keyFieldNames) {
            Schema fieldSchema = valueSchema.field(fieldName).schema();
            allFields.put(fieldName, new SinkRecordField(fieldSchema, fieldName, true));
        }
    }

    public String toString() {
        return "FieldsMetadata{keyFieldNames=" + this.keyFieldNames + ", nonKeyFieldNames=" + this.nonKeyFieldNames + ", allFields=" + this.allFields + "}";
    }
}

