/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.DropOptions;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.PreparedStatementBinder;
import io.confluent.connect.jdbc.sink.metadata.FieldsMetadata;
import io.confluent.connect.jdbc.sink.metadata.SchemaPair;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.QuoteMethod;
import io.confluent.connect.jdbc.util.TableDefinition;
import io.confluent.connect.jdbc.util.TableId;
import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.jdbc.OraclePreparedStatement;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

public class OracleDatabaseDialect
extends GenericDatabaseDialect {
    public OracleDatabaseDialect(AbstractConfig config) {
        super(config, new IdentifierRules(".", "\"", "\""));
    }

    @Override
    protected String currentTimestampDatabaseQuery() {
        return "select CURRENT_TIMESTAMP from dual";
    }

    @Override
    protected String checkConnectionQuery() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    public DatabaseDialect.StatementBinder statementBinder(PreparedStatement statement, JdbcSinkConfig.PrimaryKeyMode pkMode, SchemaPair schemaPair, FieldsMetadata fieldsMetadata, TableDefinition tableDefinition, JdbcSinkConfig.InsertMode insertMode) {
        return new PreparedStatementBinder(this, statement, pkMode, schemaPair, fieldsMetadata, tableDefinition, insertMode);
    }

    @Override
    public void bindField(PreparedStatement statement, int index, Schema schema, Object value, ColumnDefinition colDef) throws SQLException {
        if (value == null) {
            statement.setObject(index, null);
        } else {
            boolean bound = this.maybeBindLogical(statement, index, schema, value);
            if (!bound) {
                bound = this.maybeBindPrimitive(statement, index, schema, value, colDef);
            }
            if (!bound) {
                throw new ConnectException("Unsupported source data type: " + schema.type());
            }
        }
    }

    protected boolean maybeBindPrimitive(PreparedStatement statement, int index, Schema schema, Object value, ColumnDefinition colDef) throws SQLException {
        if (colDef == null) {
            return super.maybeBindPrimitive(statement, index, schema, value);
        }
        switch (schema.type()) {
            case STRING: {
                return this.maybeBindStringPrimitive(statement, index, schema, value, colDef);
            }
            case BYTES: {
                if (colDef.type() != 2004) break;
                if (value instanceof ByteBuffer) {
                    statement.setBlob(index, new ByteArrayInputStream(((ByteBuffer)value).array()));
                } else if (value instanceof byte[]) {
                    statement.setBlob(index, new ByteArrayInputStream((byte[])value));
                } else {
                    return super.maybeBindPrimitive(statement, index, schema, value);
                }
                return true;
            }
            case FLOAT32: {
                ((OraclePreparedStatement)statement).setBinaryFloat(index, ((Float)value).floatValue());
                return true;
            }
            case FLOAT64: {
                ((OraclePreparedStatement)statement).setBinaryDouble(index, ((Double)value).doubleValue());
                return true;
            }
        }
        return super.maybeBindPrimitive(statement, index, schema, value);
    }

    private boolean maybeBindStringPrimitive(PreparedStatement statement, int index, Schema schema, Object value, ColumnDefinition colDef) throws SQLException {
        switch (colDef.type()) {
            case 2005: {
                String insertMode;
                int upsertValueLimit = 4000;
                boolean valueBinded = false;
                long valueLength = ((String)value).length();
                if (this.config instanceof JdbcSinkConfig && (insertMode = this.config.getString("insert.mode")) != null && !insertMode.isEmpty() && JdbcSinkConfig.InsertMode.valueOf(insertMode.toUpperCase()) == JdbcSinkConfig.InsertMode.UPSERT) {
                    if (valueLength < 4000L) {
                        statement.setCharacterStream(index, (Reader)new StringReader((String)value), valueLength);
                    } else {
                        statement.setCharacterStream(index, new StringReader((String)value));
                    }
                    valueBinded = true;
                }
                if (!valueBinded) {
                    statement.setCharacterStream(index, (Reader)new StringReader((String)value), valueLength);
                }
                return true;
            }
            case 2011: {
                statement.setNCharacterStream(index, new StringReader((String)value));
                return true;
            }
            case -15: 
            case -9: {
                statement.setNString(index, (String)value);
                return true;
            }
        }
        return super.maybeBindPrimitive(statement, index, schema, value);
    }

    @Override
    protected String getSqlType(SinkRecordField field) {
        if (field.schemaName() != null) {
            switch (field.schemaName()) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "NUMBER(*," + field.schemaParameters().get("scale") + ")";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "TIMESTAMP";
                }
            }
        }
        switch (field.schemaType()) {
            case INT8: {
                return "NUMBER(3,0)";
            }
            case INT16: {
                return "NUMBER(5,0)";
            }
            case INT32: {
                return "NUMBER(10,0)";
            }
            case INT64: {
                return "NUMBER(19,0)";
            }
            case FLOAT32: {
                return "BINARY_FLOAT";
            }
            case FLOAT64: {
                return "BINARY_DOUBLE";
            }
            case BOOLEAN: {
                return "NUMBER(1,0)";
            }
            case STRING: {
                return "VARCHAR2(4000)";
            }
            case BYTES: {
                return "BLOB";
            }
        }
        return super.getSqlType(field);
    }

    @Override
    public String buildDropTableStatement(TableId table, DropOptions options) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("DROP TABLE ");
        builder.append(table);
        if (options.cascade()) {
            builder.append(" CASCADE CONSTRAINTS");
        }
        String dropStatement = builder.toString();
        if (!options.ifExists()) {
            return dropStatement;
        }
        builder = this.expressionBuilder();
        builder.append("BEGIN ");
        builder.append("EXECUTE IMMEDIATE '" + dropStatement + "' ");
        builder.append("EXCEPTION ");
        builder.append("WHEN OTHERS THEN ");
        builder.append("IF SQLCODE != -942 THEN ");
        builder.append("    RAISE;");
        builder.append("END IF;");
        builder.append("END;");
        return builder.toString();
    }

    @Override
    public List<String> buildAlterTable(TableId table, Collection<SinkRecordField> fields) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("ALTER TABLE ");
        builder.append(table);
        builder.append(" ADD(");
        this.writeColumnsSpec(builder, fields);
        builder.append(")");
        return Collections.singletonList(builder.toString());
    }

    @Override
    public String buildUpsertQueryStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns) {
        ExpressionBuilder.Transform<ColumnId> transform = (builder, col) -> builder.append(table).append(".").appendColumnName(col.name()).append("=incoming.").appendColumnName(col.name());
        ExpressionBuilder builder2 = this.expressionBuilder();
        builder2.append("merge into ");
        builder2.append(table);
        builder2.append(" using (select ");
        builder2.appendList().delimitedBy(", ").transformedBy(ExpressionBuilder.columnNamesWithPrefix("? ")).of(keyColumns, nonKeyColumns);
        builder2.append(" FROM dual) incoming on(");
        builder2.appendList().delimitedBy(" and ").transformedBy(transform).of(keyColumns);
        builder2.append(")");
        if (nonKeyColumns != null && !nonKeyColumns.isEmpty()) {
            builder2.append(" when matched then update set ");
            builder2.appendList().delimitedBy(",").transformedBy(transform).of(nonKeyColumns);
        }
        builder2.append(" when not matched then insert(");
        builder2.appendList().delimitedBy(",").of(nonKeyColumns, keyColumns);
        builder2.append(") values(");
        builder2.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNamesWithPrefix("incoming.")).of(nonKeyColumns, keyColumns);
        builder2.append(")");
        return builder2.toString();
    }

    @Override
    protected String sanitizedUrl(String url) {
        return super.sanitizedUrl(url).replaceAll("(:thin:[^/]*)/([^@]*)@", "$1/****@").replaceAll("(:oci[^:]*:[^/]*)/([^@]*)@", "$1/****@");
    }

    @Override
    public TableId parseTableIdentifier(String fqn) {
        TableId tableId = super.parseTableIdentifier(fqn);
        if (this.quoteSqlIdentifiers == QuoteMethod.NEVER) {
            tableId = new TableId(tableId.catalogName(), tableId.schemaName(), tableId.tableName().toUpperCase());
        }
        return tableId;
    }

    public static class Provider
    extends DatabaseDialectProvider.SubprotocolBasedProvider {
        public Provider() {
            super(OracleDatabaseDialect.class.getSimpleName(), "oracle");
        }

        @Override
        public DatabaseDialect create(AbstractConfig config) {
            return new OracleDatabaseDialect(config);
        }
    }
}

