/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DropOptions;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.metadata.FieldsMetadata;
import io.confluent.connect.jdbc.sink.metadata.SchemaPair;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.source.ColumnMapping;
import io.confluent.connect.jdbc.source.JdbcSourceConnectorConfig;
import io.confluent.connect.jdbc.source.TimestampIncrementingCriteria;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.ConnectionProvider;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.TableDefinition;
import io.confluent.connect.jdbc.util.TableId;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;

public interface DatabaseDialect
extends ConnectionProvider {
    public String name();

    public PreparedStatement createPreparedStatement(Connection var1, String var2) throws SQLException;

    public TableId parseTableIdentifier(String var1);

    public IdentifierRules identifierRules();

    public ExpressionBuilder expressionBuilder();

    public Timestamp currentTimeOnDB(Connection var1, Calendar var2) throws SQLException, ConnectException;

    public List<TableId> tableIds(Connection var1) throws SQLException;

    public boolean tableExists(Connection var1, TableId var2) throws SQLException;

    public void setConnectionIsolationMode(Connection var1, JdbcSourceConnectorConfig.TransactionIsolationMode var2);

    public Map<ColumnId, ColumnDefinition> describeColumns(Connection var1, String var2, String var3) throws SQLException;

    public Map<ColumnId, ColumnDefinition> describeColumns(Connection var1, String var2, String var3, String var4, String var5) throws SQLException;

    public Map<ColumnId, ColumnDefinition> describeColumns(ResultSetMetaData var1) throws SQLException;

    public TableDefinition describeTable(Connection var1, TableId var2) throws SQLException;

    public Map<ColumnId, ColumnDefinition> describeColumnsByQuerying(Connection var1, TableId var2) throws SQLException;

    public TimestampIncrementingCriteria criteriaFor(ColumnId var1, List<ColumnId> var2);

    public String addFieldToSchema(ColumnDefinition var1, SchemaBuilder var2);

    public void applyDdlStatements(Connection var1, List<String> var2) throws SQLException;

    @Deprecated
    public String buildInsertStatement(TableId var1, Collection<ColumnId> var2, Collection<ColumnId> var3);

    default public String buildInsertStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns, TableDefinition definition) {
        return this.buildInsertStatement(table, keyColumns, nonKeyColumns);
    }

    @Deprecated
    public String buildUpdateStatement(TableId var1, Collection<ColumnId> var2, Collection<ColumnId> var3);

    default public String buildUpdateStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns, TableDefinition definition) {
        return this.buildUpdateStatement(table, keyColumns, nonKeyColumns);
    }

    @Deprecated
    public String buildUpsertQueryStatement(TableId var1, Collection<ColumnId> var2, Collection<ColumnId> var3);

    default public String buildUpsertQueryStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns, TableDefinition definition) {
        return this.buildUpsertQueryStatement(table, keyColumns, nonKeyColumns);
    }

    default public String buildDeleteStatement(TableId table, Collection<ColumnId> keyColumns) {
        throw new UnsupportedOperationException();
    }

    public String buildDropTableStatement(TableId var1, DropOptions var2);

    public String buildCreateTableStatement(TableId var1, Collection<SinkRecordField> var2);

    public List<String> buildAlterTable(TableId var1, Collection<SinkRecordField> var2);

    @Deprecated
    public StatementBinder statementBinder(PreparedStatement var1, JdbcSinkConfig.PrimaryKeyMode var2, SchemaPair var3, FieldsMetadata var4, JdbcSinkConfig.InsertMode var5);

    default public StatementBinder statementBinder(PreparedStatement statement, JdbcSinkConfig.PrimaryKeyMode pkMode, SchemaPair schemaPair, FieldsMetadata fieldsMetadata, TableDefinition tableDefinition, JdbcSinkConfig.InsertMode insertMode) {
        return this.statementBinder(statement, pkMode, schemaPair, fieldsMetadata, insertMode);
    }

    public void validateSpecificColumnTypes(ResultSetMetaData var1, List<ColumnId> var2) throws ConnectException;

    @Deprecated
    public void bindField(PreparedStatement var1, int var2, Schema var3, Object var4) throws SQLException;

    default public void bindField(PreparedStatement statement, int index, Schema schema, Object value, ColumnDefinition colDef) throws SQLException {
        this.bindField(statement, index, schema, value);
    }

    public ColumnConverter createColumnConverter(ColumnMapping var1);

    @FunctionalInterface
    public static interface StatementBinder {
        public void bindRecord(SinkRecord var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface ColumnConverter {
        public Object convert(ResultSet var1) throws SQLException, IOException;
    }
}

