/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialects;
import io.confluent.connect.jdbc.source.JdbcSourceConnectorConfig;
import io.confluent.connect.jdbc.source.JdbcSourceTask;
import io.confluent.connect.jdbc.source.TableMonitorThread;
import io.confluent.connect.jdbc.util.CachedConnectionProvider;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.TableId;
import io.confluent.connect.jdbc.util.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.util.ConnectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSourceConnector
extends SourceConnector {
    private static final Logger log = LoggerFactory.getLogger(JdbcSourceConnector.class);
    private static final long MAX_TIMEOUT = 10000L;
    private Map<String, String> configProperties;
    private JdbcSourceConnectorConfig config;
    private CachedConnectionProvider cachedConnectionProvider;
    private TableMonitorThread tableMonitorThread;
    private DatabaseDialect dialect;

    public String version() {
        return Version.getVersion();
    }

    public void start(Map<String, String> properties) throws ConnectException {
        HashSet<String> blacklistSet;
        log.info("Starting JDBC Source Connector");
        try {
            this.configProperties = properties;
            this.config = new JdbcSourceConnectorConfig(this.configProperties);
        }
        catch (ConfigException e) {
            throw new ConnectException("Couldn't start JdbcSourceConnector due to configuration error", (Throwable)e);
        }
        String dbUrl = this.config.getString("connection.url");
        int maxConnectionAttempts = this.config.getInt("connection.attempts");
        long connectionRetryBackoff = this.config.getLong("connection.backoff.ms");
        this.dialect = DatabaseDialects.findBestFor(dbUrl, this.config);
        this.cachedConnectionProvider = this.connectionProvider(maxConnectionAttempts, connectionRetryBackoff);
        log.info("Initial connection attempt with the database.");
        this.cachedConnectionProvider.getConnection();
        long tablePollMs = this.config.getLong("table.poll.interval.ms");
        long tableStartupLimitMs = this.config.getLong("table.monitoring.startup.polling.limit.ms");
        List whitelist = this.config.getList("table.whitelist");
        HashSet<String> whitelistSet = whitelist.isEmpty() ? null : new HashSet(whitelist);
        List blacklist = this.config.getList("table.blacklist");
        HashSet<String> hashSet = blacklistSet = blacklist.isEmpty() ? null : new HashSet<String>(blacklist);
        if (whitelistSet != null && blacklistSet != null) {
            throw new ConnectException("table.whitelist and table.blacklist are exclusive.");
        }
        String query = this.config.getString("query");
        if (!query.isEmpty()) {
            if (whitelistSet != null || blacklistSet != null) {
                throw new ConnectException("query may not be combined with whole-table copying settings.");
            }
            whitelistSet = Collections.emptySet();
        }
        this.tableMonitorThread = new TableMonitorThread(this.dialect, this.cachedConnectionProvider, this.context, tableStartupLimitMs, tablePollMs, whitelistSet, blacklistSet, Time.SYSTEM);
        if (query.isEmpty()) {
            this.tableMonitorThread.start();
        }
    }

    protected CachedConnectionProvider connectionProvider(int maxConnAttempts, long retryBackoff) {
        return new CachedConnectionProvider(this.dialect, maxConnAttempts, retryBackoff);
    }

    public Class<? extends Task> taskClass() {
        return JdbcSourceTask.class;
    }

    public Config validate(Map<String, String> connectorConfigs) {
        Config config = super.validate(connectorConfigs);
        JdbcSourceConnectorConfig jdbcSourceConnectorConfig = new JdbcSourceConnectorConfig(connectorConfigs);
        jdbcSourceConnectorConfig.validateMultiConfigs(config);
        return config;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> taskConfigs;
        String query = this.config.getString("query");
        if (!query.isEmpty()) {
            HashMap<String, String> taskProps = new HashMap<String, String>(this.configProperties);
            taskProps.put("tables", "");
            taskProps.put("tables.fetched", "true");
            List<Map<String, String>> taskConfigs2 = Collections.singletonList(taskProps);
            log.trace("Producing task configs with custom query");
            return taskConfigs2;
        }
        List<TableId> currentTables = this.tableMonitorThread.tables();
        if (currentTables == null || currentTables.isEmpty()) {
            taskConfigs = new ArrayList<Map<String, String>>(1);
            HashMap<String, String> taskProps = new HashMap<String, String>(this.configProperties);
            taskProps.put("tables", "");
            if (currentTables == null) {
                taskProps.put("tables.fetched", "false");
                log.warn("The connector has not been able to read the list of tables from the database yet.");
            } else {
                taskProps.put("tables.fetched", "true");
                log.warn("No tables were found so there's no work to be done.");
            }
            taskConfigs.add(taskProps);
        } else {
            int numGroups = Math.min(currentTables.size(), maxTasks);
            List tablesGrouped = ConnectorUtils.groupPartitions(currentTables, (int)numGroups);
            taskConfigs = new ArrayList(tablesGrouped.size());
            for (List taskTables : tablesGrouped) {
                HashMap<String, String> taskProps = new HashMap<String, String>(this.configProperties);
                ExpressionBuilder builder = this.dialect.expressionBuilder();
                builder.appendList().delimitedBy(",").of(taskTables);
                taskProps.put("tables", builder.toString());
                taskProps.put("tables.fetched", "true");
                taskConfigs.add(taskProps);
            }
            log.trace("Producing task configs with no custom query for tables: {}", currentTables.toArray());
        }
        return taskConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws ConnectException {
        log.info("Stopping table monitoring thread");
        this.tableMonitorThread.shutdown();
        try {
            this.tableMonitorThread.join(10000L);
            return;
        }
        catch (InterruptedException t) {
            try {
                this.cachedConnectionProvider.close(true);
                return;
            }
            finally {
                try {
                    if (this.dialect != null) {
                        this.dialect.close();
                    }
                }
                catch (Throwable t2) {
                    log.warn("Error while closing the {} dialect: ", (Object)this.dialect, (Object)t2);
                }
                finally {
                    this.dialect = null;
                }
            }
        }
        finally {
            try {
                this.cachedConnectionProvider.close(true);
            }
            finally {
                try {
                    if (this.dialect != null) {
                        this.dialect.close();
                    }
                }
                catch (Throwable t) {
                    log.warn("Error while closing the {} dialect: ", (Object)this.dialect, (Object)t);
                }
                finally {
                    this.dialect = null;
                }
            }
        }
    }

    public ConfigDef config() {
        return JdbcSourceConnectorConfig.CONFIG_DEF;
    }
}

