/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.multithreadedtablewriter;

import com.xxdb.DBConnection;
import com.xxdb.comm.ErrorCodeInfo;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicArrayVector;
import com.xxdb.data.BasicBooleanVector;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.multithreadedtablewriter.Callback;
import com.xxdb.route.Domain;
import com.xxdb.route.DomainFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class MultithreadedTableWriter {
    private Logger logger_ = Logger.getLogger(this.getClass().getName());
    private String dbName_;
    private String tableName_;
    private int batchSize_;
    private int throttleMilsecond_;
    private boolean isPartionedTable_;
    private boolean hasError_;
    private boolean isExiting_ = false;
    private int[] compressTypes_ = null;
    private Domain partitionDomain_;
    private int partitionColumnIdx_;
    private int threadByColIndexForNonPartion_;
    private int sentRowsAfterGc_;
    private List<WriterThread> threads_ = new ArrayList<WriterThread>();
    private ErrorCodeInfo errorCodeInfo_ = new ErrorCodeInfo();
    private Mode mode_;
    private String[] pModeOption_;
    private boolean ifCallback_ = false;
    private ColInfo[] colInfos_;

    public MultithreadedTableWriter(String hostName, int port, String userId, String password, String dbName, String tableName, boolean useSSL, boolean enableHighAvailability, String[] highAvailabilitySites, int batchSize, float throttle, int threadCount, String partitionCol, int[] compressTypes, Mode mode, String[] pModeOption) throws Exception {
        this.init(hostName, port, userId, password, dbName, tableName, useSSL, enableHighAvailability, highAvailabilitySites, batchSize, throttle, threadCount, partitionCol, compressTypes, mode, pModeOption, null);
    }

    public MultithreadedTableWriter(String hostName, int port, String userId, String password, String dbName, String tableName, boolean useSSL, boolean enableHighAvailability, String[] highAvailabilitySites, int batchSize, float throttle, int threadCount, String partitionCol, int[] compressTypes) throws Exception {
        this.init(hostName, port, userId, password, dbName, tableName, useSSL, enableHighAvailability, highAvailabilitySites, batchSize, throttle, threadCount, partitionCol, compressTypes, Mode.M_Append, null, null);
    }

    public MultithreadedTableWriter(String hostName, int port, String userId, String password, String dbName, String tableName, boolean useSSL, boolean enableHighAvailability, String[] highAvailabilitySites, int batchSize, float throttle, int threadCount, String partitionCol) throws Exception {
        this.init(hostName, port, userId, password, dbName, tableName, useSSL, enableHighAvailability, highAvailabilitySites, batchSize, throttle, threadCount, partitionCol, null, Mode.M_Append, null, null);
    }

    public MultithreadedTableWriter(String hostName, int port, String userId, String password, String dbName, String tableName, boolean useSSL, boolean enableHighAvailability, String[] highAvailabilitySites, int batchSize, float throttle, int threadCount, String partitionCol, int[] compressTypes, Callback callbackHandler) throws Exception {
        this.init(hostName, port, userId, password, dbName, tableName, useSSL, enableHighAvailability, highAvailabilitySites, batchSize, throttle, threadCount, partitionCol, compressTypes, Mode.M_Append, null, callbackHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(String hostName, int port, String userId, String password, String dbName, String tableName, boolean useSSL, boolean enableHighAvailability, String[] highAvailabilitySites, int batchSize, float throttle, int threadCount, String partitionCol, int[] compressTypes, Mode mode, String[] pModeOption, Callback callbackHandler) throws Exception {
        DBConnection pConn;
        this.dbName_ = dbName;
        this.tableName_ = tableName;
        this.batchSize_ = batchSize;
        this.throttleMilsecond_ = (int)throttle * 1000;
        this.hasError_ = false;
        this.mode_ = mode == null ? Mode.M_Append : mode;
        this.pModeOption_ = pModeOption;
        if (threadCount < 1) {
            throw new RuntimeException("The parameter threadCount must be greater than or equal to 1.");
        }
        if (batchSize < 1) {
            throw new RuntimeException("The parameter batchSize must be greater than or equal to 1.");
        }
        if (throttle < 0.0f) {
            throw new RuntimeException("The parameter throttle must be greater than or equal to 0.");
        }
        if (threadCount > 1 && partitionCol.length() < 1) {
            throw new RuntimeException("The parameter partitionCol must be specified when threadCount is greater than 1.");
        }
        boolean isCompress = false;
        if (compressTypes != null && compressTypes.length > 0) {
            for (int one : compressTypes) {
                if (one == 1 || one == 2) continue;
                throw new RuntimeException("Unsupported compress method " + one);
            }
            isCompress = true;
            this.compressTypes_ = new int[compressTypes.length];
            System.arraycopy(compressTypes, 0, this.compressTypes_, 0, compressTypes.length);
        }
        if ((pConn = this.newConn(hostName, port, userId, password, dbName, tableName, useSSL, enableHighAvailability, highAvailabilitySites, isCompress)) == null) {
            throw new RuntimeException("Failed to connect to server " + hostName + ":" + port);
        }
        BasicDictionary schema = dbName.isEmpty() ? (BasicDictionary)pConn.run("schema(" + tableName + ")") : (BasicDictionary)pConn.run("schema(loadTable(\"" + dbName + "\",\"" + tableName + "\"))");
        Entity partColNames = schema.get(new BasicString("partitionColumnName"));
        if (partColNames != null) {
            this.isPartionedTable_ = true;
        } else {
            if (!dbName.isEmpty() && threadCount > 1) {
                throw new RuntimeException("The parameter threadCount must be 1 for a dimension table.");
            }
            this.isPartionedTable_ = false;
        }
        BasicTable colDefs = (BasicTable)schema.get(new BasicString("colDefs"));
        BasicIntVector colDefsTypeInt = (BasicIntVector)colDefs.getColumn("typeInt");
        int columnSize = colDefs.rows();
        if (this.compressTypes_ != null && this.compressTypes_.length != columnSize) {
            throw new RuntimeException("The number of elements in parameter compressMethods does not match the column size " + columnSize);
        }
        if (callbackHandler != null) {
            this.ifCallback_ = true;
            this.colInfos_ = new ColInfo[columnSize + 1];
        } else {
            this.colInfos_ = new ColInfo[columnSize];
        }
        for (int i = 0; i < this.colInfos_.length; ++i) {
            ColInfo colInfo;
            this.colInfos_[i] = colInfo = new ColInfo();
        }
        BasicIntVector colExtra = (BasicIntVector)colDefs.getColumn("extra");
        BasicStringVector colDefsName = (BasicStringVector)colDefs.getColumn("name");
        int colDefsIndex = 0;
        for (int i = 0; i < this.colInfos_.length; ++i) {
            if (i == 0 && this.ifCallback_) {
                this.colInfos_[i].type_ = Entity.DATA_TYPE.DT_STRING;
                this.colInfos_[i].name_ = colDefsName.getString(0) + "_id";
                this.colInfos_[i].extra_ = -1;
                continue;
            }
            this.colInfos_[i].name_ = colDefsName.getString(colDefsIndex);
            if (colExtra != null) {
                this.colInfos_[i].extra_ = colExtra.getInt(colDefsIndex);
            }
            if (this.compressTypes_ != null) {
                boolean check = AbstractVector.checkCompressedMethod(Entity.DATA_TYPE.valueOf(colDefsTypeInt.getInt(colDefsIndex)), this.compressTypes_[colDefsIndex]);
                if (!check) throw new RuntimeException("Compression Failed: only support integral and temporal data, not support " + (Object)((Object)Entity.DATA_TYPE.valueOf(colDefsTypeInt.getInt(colDefsIndex))));
                this.colInfos_[i].type_ = Entity.DATA_TYPE.valueOf(colDefsTypeInt.getInt(colDefsIndex));
            } else {
                this.colInfos_[i].type_ = Entity.DATA_TYPE.valueOf(colDefsTypeInt.getInt(colDefsIndex));
            }
            ++colDefsIndex;
        }
        if (this.isPartionedTable_) {
            int partitionType;
            Entity partitionSchema;
            if (partColNames.isScalar()) {
                if (!partColNames.getString().equals(partitionCol)) {
                    throw new RuntimeException("The parameter partionCol must be the partitioning column " + partColNames.getString() + " in the table.");
                }
                this.partitionColumnIdx_ = ((BasicInt)schema.get(new BasicString("partitionColumnIndex"))).getInt();
                partitionSchema = schema.get(new BasicString("partitionSchema"));
                partitionType = ((BasicInt)schema.get(new BasicString("partitionType"))).getInt();
            } else {
                BasicStringVector partColNamesVec = (BasicStringVector)partColNames;
                int dims = partColNamesVec.rows();
                if (dims > 1 && partitionCol.isEmpty()) {
                    throw new RuntimeException("The parameter partitionCol must be specified for a partitioned table.");
                }
                int index = -1;
                for (int i = 0; i < dims; ++i) {
                    if (!partColNamesVec.getString(i).equals(partitionCol)) continue;
                    index = i;
                    break;
                }
                if (index < 0) {
                    throw new RuntimeException("The parameter partionCol must be the partitioning columns in the partitioned table. ");
                }
                this.partitionColumnIdx_ = ((BasicIntVector)schema.get(new BasicString("partitionColumnIndex"))).getInt(index);
                partitionSchema = ((BasicAnyVector)schema.get(new BasicString("partitionSchema"))).getEntity(index);
                partitionType = ((BasicIntVector)schema.get(new BasicString("partitionType"))).getInt(index);
            }
            if (this.ifCallback_) {
                ++this.partitionColumnIdx_;
            }
            Entity.DATA_TYPE dataColType = this.colInfos_[this.partitionColumnIdx_].type_;
            Entity.PARTITION_TYPE partitionColtype = Entity.PARTITION_TYPE.values()[partitionType];
            this.partitionDomain_ = DomainFactory.createDomain(partitionColtype, dataColType, partitionSchema);
        } else if (!partitionCol.isEmpty()) {
            int threadcolindex = -1;
            for (int i = 0; i < this.colInfos_.length; ++i) {
                if (!this.colInfos_[i].name_.equals(partitionCol)) continue;
                threadcolindex = i;
                break;
            }
            if (threadcolindex < 0) {
                throw new RuntimeException("No match found for " + partitionCol);
            }
            this.threadByColIndexForNonPartion_ = threadcolindex;
        }
        for (int i = 0; i < threadCount; ++i) {
            if (pConn == null) {
                pConn = this.newConn(hostName, port, userId, password, dbName, tableName, useSSL, enableHighAvailability, highAvailabilitySites, isCompress);
            }
            WriterThread writerThread = new WriterThread(this, pConn, callbackHandler);
            this.threads_.add(writerThread);
            pConn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Entity>> getUnwrittenData() {
        if (this.ifCallback_) {
            throw new RuntimeException("getUnwrittenData is disabled when callback is enabled.");
        }
        ArrayList<List<Entity>> unwrittenData = new ArrayList<List<Entity>>();
        for (WriterThread writeThread : this.threads_) {
            Object object = writeThread.busyLock_;
            synchronized (object) {
                List<List<Entity>> list = writeThread.failedQueue_;
                synchronized (list) {
                    unwrittenData.addAll(writeThread.failedQueue_);
                    writeThread.failedQueue_.clear();
                }
                list = writeThread.writeQueue_;
                synchronized (list) {
                    int cols = this.colInfos_.length;
                    int size = writeThread.writeQueue_.size();
                    for (int i = 0; i < size; ++i) {
                        int rows = writeThread.writeQueue_.get(i).get(0).rows();
                        for (int row = 0; row < rows; ++row) {
                            ArrayList<Entity> tmp = new ArrayList<Entity>();
                            for (int j = 0; j < cols; ++j) {
                                tmp.add(writeThread.writeQueue_.get(i).get(j).get(row));
                            }
                            unwrittenData.add(tmp);
                        }
                    }
                    writeThread.writeQueue_.clear();
                    writeThread.writeQueue_.add(this.createListVector());
                }
            }
        }
        return unwrittenData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Entity>> getFailedData() throws InterruptedException {
        ArrayList<List<Entity>> failedData = new ArrayList<List<Entity>>();
        for (WriterThread writeThread : this.threads_) {
            Object object = writeThread.busyLock_;
            synchronized (object) {
                List<List<Entity>> list = writeThread.failedQueue_;
                synchronized (list) {
                    failedData.addAll(writeThread.failedQueue_);
                    writeThread.failedQueue_.clear();
                }
            }
        }
        return failedData;
    }

    public Status getStatus() {
        Status status = new Status();
        status.errorCode = this.errorCodeInfo_.errorCode;
        status.errorInfo = this.errorCodeInfo_.errorInfo;
        status.unsentRows = 0L;
        status.sentRows = 0L;
        status.sendFailedRows = 0L;
        status.isExiting = this.isExiting();
        for (WriterThread writeThread : this.threads_) {
            ThreadStatus threadStatus = new ThreadStatus();
            writeThread.getStatus(threadStatus);
            status.threadStatusList.add(threadStatus);
            status.sentRows += threadStatus.sentRows;
            status.unsentRows += threadStatus.unsentRows;
            status.sendFailedRows += threadStatus.sendFailedRows;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForThreadCompletion() throws InterruptedException {
        this.isExiting_ = true;
        for (WriterThread one : this.threads_) {
            one.exit();
        }
        for (WriterThread one : this.threads_) {
            Thread thread = one.writeThread_;
            synchronized (thread) {
                if (!one.isFinished_) {
                    one.writeThread_.wait();
                }
            }
            one.conn_ = null;
        }
        this.setError(ErrorCodeInfo.Code.EC_None, "");
    }

    public ErrorCodeInfo insertUnwrittenData(List<List<Entity>> records) {
        if (this.isExiting()) {
            throw new RuntimeException("Thread is exiting. ");
        }
        if (this.threads_.size() > 1) {
            if (this.isPartionedTable_) {
                Vector pvector = BasicEntityFactory.instance().createVectorWithDefaultValue(this.colInfos_[this.partitionColumnIdx_].type_, records.size(), -1);
                int rowindex = 0;
                try {
                    for (List<Entity> row : records) {
                        if (row.size() != this.colInfos_.length) {
                            return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidParameter, "Column counts don't match.");
                        }
                        if (row.get(this.partitionColumnIdx_) != null) {
                            Scalar scalar = (Scalar)row.get(this.partitionColumnIdx_);
                            if (scalar != null) {
                                pvector.set(rowindex, scalar);
                            } else {
                                pvector.setNull(rowindex);
                            }
                        } else {
                            pvector.setNull(rowindex);
                        }
                        ++rowindex;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidParameter, "Row in records " + rowindex + " mismatch type " + (Object)((Object)this.colInfos_[this.partitionColumnIdx_].type_));
                }
                List<Integer> threadindexes = this.partitionDomain_.getPartitionKeys(pvector);
                try {
                    for (int row = 0; row < threadindexes.size(); ++row) {
                        this.insertThreadWrite(threadindexes.get(row), records.get(row));
                    }
                }
                catch (Exception row) {}
            } else {
                Vector partionvector = BasicEntityFactory.instance().createVectorWithDefaultValue(this.colInfos_[this.threadByColIndexForNonPartion_].type_, records.size(), -1);
                int rowindex = 0;
                try {
                    for (List<Entity> row : records) {
                        if (row.size() != this.colInfos_.length) {
                            return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidParameter, "Column counts don't match.");
                        }
                        Scalar scalar = (Scalar)row.get(this.threadByColIndexForNonPartion_);
                        if (scalar != null) {
                            partionvector.set(rowindex, scalar);
                        } else {
                            partionvector.setNull(rowindex);
                        }
                        ++rowindex;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidParameter, "Row in records " + rowindex + " mismatch type " + (Object)((Object)this.colInfos_[this.partitionColumnIdx_].type_));
                }
                try {
                    for (rowindex = 0; rowindex < records.size(); ++rowindex) {
                        int threadindex = partionvector.hashBucket(rowindex, this.threads_.size());
                        this.insertThreadWrite(threadindex, records.get(rowindex));
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            try {
                for (List<Entity> row : records) {
                    this.insertThreadWrite(0, row);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ErrorCodeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertThreadWrite(int threadhashkey, List<Entity> row) throws Exception {
        if (threadhashkey < 0) {
            threadhashkey = 0;
        }
        int threadIndex = threadhashkey % this.threads_.size();
        WriterThread writerThread = this.threads_.get(threadIndex);
        List<List<Vector>> list = writerThread.writeQueue_;
        synchronized (list) {
            int rows = writerThread.writeQueue_.get(writerThread.writeQueue_.size() - 1).get(0).rows();
            if (rows > WriterThread.vectorSize) {
                writerThread.writeQueue_.add(this.createListVector());
            }
            int size = row.size();
            for (int i = 0; i < size; ++i) {
                if (this.colInfos_[i].type_.getValue() < 65) {
                    writerThread.writeQueue_.get(writerThread.writeQueue_.size() - 1).get(i).Append((Scalar)row.get(i));
                    continue;
                }
                writerThread.writeQueue_.get(writerThread.writeQueue_.size() - 1).get(i).Append((Vector)row.get(i));
            }
            writerThread.writeQueue_.notify();
        }
    }

    public ErrorCodeInfo insert(Object ... args) {
        if (this.isExiting()) {
            throw new RuntimeException("Thread is exiting. ");
        }
        if (args.length != this.colInfos_.length) {
            return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidParameter, "Column counts don't match.");
        }
        try {
            int threadindex;
            ArrayList<Entity> prow = new ArrayList<Entity>();
            int colindex = 0;
            boolean isAllNull = true;
            for (Object one : args) {
                Entity.DATA_TYPE dataType = this.colInfos_[colindex].type_;
                isAllNull = false;
                Entity entity = BasicEntityFactory.createScalar(dataType, one, this.colInfos_[colindex].extra_);
                if (entity == null) {
                    return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidObject, "Data conversion error: " + (Object)((Object)dataType));
                }
                prow.add(entity);
                ++colindex;
            }
            if (isAllNull) {
                return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidObject, "Can't insert a Null row.");
            }
            if (this.threads_.size() > 1) {
                if (this.isPartionedTable_) {
                    try {
                        threadindex = this.partitionDomain_.getPartitionKey((Scalar)prow.get(this.partitionColumnIdx_));
                    }
                    catch (Exception e) {
                        return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidObject, e.getMessage());
                    }
                } else {
                    threadindex = prow.get(this.threadByColIndexForNonPartion_) != null ? ((Scalar)prow.get(this.threadByColIndexForNonPartion_)).hashBucket(this.threads_.size()) : 0;
                }
            } else {
                threadindex = 0;
            }
            this.insertThreadWrite(threadindex, prow);
            return new ErrorCodeInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ErrorCodeInfo(ErrorCodeInfo.Code.EC_InvalidObject, "Invalid object error " + e);
        }
    }

    private List<Vector> createListVector() {
        ArrayList<Vector> tmp = new ArrayList<Vector>();
        int cols = this.colInfos_.length;
        for (int i = 0; i < cols; ++i) {
            Entity.DATA_TYPE type = this.colInfos_[i].type_;
            if (type.getValue() >= 65) {
                tmp.add(new BasicArrayVector(type, 1, this.colInfos_[i].extra_));
                continue;
            }
            Vector value = BasicEntityFactory.instance().createVectorWithDefaultValue(type, 0, this.colInfos_[i].extra_);
            if (type == Entity.DATA_TYPE.DT_DECIMAL32 || type == Entity.DATA_TYPE.DT_DECIMAL64 || type == Entity.DATA_TYPE.DT_DECIMAL128) {
                ((AbstractVector)value).setExtraParamForType(this.colInfos_[i].extra_);
            }
            tmp.add(value);
        }
        return tmp;
    }

    private boolean isExiting() {
        return this.hasError_ || this.isExiting_;
    }

    private DBConnection newConn(String hostName, int port, String userId, String password, String dbName, String tableName, boolean useSSL, boolean enableHighAvailability, String[] highAvailabilitySites, boolean compress) throws IOException {
        DBConnection pConn = new DBConnection(false, useSSL, compress);
        boolean ret = pConn.connect(hostName, port, userId, password, null, enableHighAvailability, highAvailabilitySites);
        if (!ret) {
            return null;
        }
        return pConn;
    }

    private void setError(ErrorCodeInfo.Code code, String info) {
        if (this.hasError_) {
            return;
        }
        this.hasError_ = true;
        this.errorCodeInfo_ = new ErrorCodeInfo(code, info);
    }

    static class WriterThread
    implements Runnable {
        MultithreadedTableWriter tableWriter_;
        DBConnection conn_;
        Object busyLock_ = new Object();
        Callback callbackHandler_;
        String scriptTableInsert_;
        String scriptSaveTable_;
        List<List<Vector>> writeQueue_ = new ArrayList<List<Vector>>();
        List<List<Entity>> failedQueue_ = new ArrayList<List<Entity>>();
        Thread writeThread_;
        long sentRows_;
        boolean exit_;
        boolean isFinished_;
        public static int vectorSize = 65536;

        WriterThread(MultithreadedTableWriter tableWriter, DBConnection conn, Callback callbackHandler) {
            this.tableWriter_ = tableWriter;
            this.sentRows_ = 0L;
            this.conn_ = conn;
            this.callbackHandler_ = callbackHandler;
            this.exit_ = false;
            this.isFinished_ = false;
            this.writeQueue_.add(this.tableWriter_.createListVector());
            this.writeThread_ = new Thread(this);
            this.writeThread_.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            block19: {
                if (!this.init()) {
                    return;
                }
                try {
                    int i;
                    while (!this.isExiting()) {
                        object = this.writeQueue_;
                        synchronized (object) {
                            this.writeQueue_.wait();
                            if (!this.isExiting() && this.tableWriter_.batchSize_ > 1 && this.tableWriter_.throttleMilsecond_ > 0) {
                                long diff;
                                long batchWaitTimeout = System.currentTimeMillis() + (long)this.tableWriter_.throttleMilsecond_;
                                while (!this.isExiting() && (this.writeQueue_.size() - 1) * vectorSize + this.writeQueue_.get(this.writeQueue_.size() - 1).get(0).rows() < this.tableWriter_.batchSize_ && (diff = batchWaitTimeout - System.currentTimeMillis()) > 0L) {
                                    this.writeQueue_.wait(diff);
                                }
                            }
                        }
                        while (!this.isExiting() && this.writeAllData()) {
                        }
                    }
                    while (!this.tableWriter_.hasError_ && this.writeAllData()) {
                    }
                    if (!this.tableWriter_.ifCallback_ || !this.tableWriter_.hasError_) break block19;
                    ArrayList<Vector> callbackList = new ArrayList<Vector>();
                    BasicStringVector bs = new BasicStringVector(0);
                    callbackList.add(bs);
                    int allLength = 0;
                    List<List<Vector>> list = this.writeQueue_;
                    synchronized (list) {
                        for (i = 0; i < this.writeQueue_.size(); ++i) {
                            List<Vector> notInsertV = this.writeQueue_.get(i);
                            Vector id = notInsertV.get(0);
                            ((Vector)callbackList.get(0)).Append(id);
                            allLength += id.rows();
                        }
                    }
                    boolean[] bArray = new boolean[allLength];
                    for (i = 0; i < allLength; ++i) {
                        bArray[i] = false;
                    }
                    BasicBooleanVector bv = new BasicBooleanVector(bArray);
                    callbackList.add(bv);
                    ArrayList<String> callbackColNames = new ArrayList<String>();
                    callbackColNames.add("callbackId");
                    callbackColNames.add("isSuccess");
                    this.callbackHandler_.writeCompletion(new BasicTable(callbackColNames, callbackList));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.tableWriter_.hasError_ = true;
                    this.tableWriter_.errorCodeInfo_.set(ErrorCodeInfo.Code.EC_None, e.getMessage());
                }
            }
            object = this.writeThread_;
            synchronized (object) {
                this.conn_.close();
                this.isFinished_ = true;
                this.writeThread_.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean writeAllData() {
            Object object = this.busyLock_;
            synchronized (object) {
                List<Vector> items;
                ArrayList<Vector> callbackList = new ArrayList<Vector>();
                int callbackRows = 0;
                int addRowCount = 0;
                List<List<Vector>> list = this.writeQueue_;
                synchronized (list) {
                    items = this.writeQueue_.get(0);
                    addRowCount = items.get(0).rows();
                    if (addRowCount < 1) {
                        return false;
                    }
                    this.writeQueue_.remove(0);
                    if (this.writeQueue_.size() == 0) {
                        this.writeQueue_.add(this.tableWriter_.createListVector());
                    }
                }
                boolean isWriteDone = true;
                BasicTable writeTable = null;
                ArrayList<String> colNames = new ArrayList<String>();
                for (int i = 0; i < this.tableWriter_.colInfos_.length; ++i) {
                    colNames.add(((MultithreadedTableWriter)this.tableWriter_).colInfos_[i].name_);
                }
                if (this.tableWriter_.ifCallback_) {
                    callbackList.add(items.get(0));
                    items.remove(0);
                    colNames.remove(0);
                }
                try {
                    writeTable = new BasicTable(colNames, items);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.tableWriter_.logger_.warning("threadid=" + this.writeThread_.getId() + " sendindex=" + this.sentRows_ + " create table error: " + e);
                    this.tableWriter_.setError(ErrorCodeInfo.Code.EC_Server, "Failed to createTable: " + e);
                    isWriteDone = false;
                }
                if (isWriteDone) {
                    String runscript = "";
                    try {
                        ArrayList<Entity> args = new ArrayList<Entity>();
                        args.add(writeTable);
                        runscript = this.scriptTableInsert_;
                        this.conn_.run(runscript, args);
                        if (this.scriptSaveTable_ != null && !this.scriptSaveTable_.isEmpty()) {
                            runscript = this.scriptSaveTable_;
                            this.conn_.run(runscript);
                        }
                        this.sentRows_ += (long)addRowCount;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.tableWriter_.logger_.warning("threadid=" + this.writeThread_.getId() + " sendindex=" + this.sentRows_ + " Save table error: " + e + " script:" + runscript);
                        this.tableWriter_.setError(ErrorCodeInfo.Code.EC_Server, "Failed to save the inserted data: " + e + " script: " + runscript);
                        isWriteDone = false;
                        this.tableWriter_.hasError_ = true;
                    }
                }
                if (!isWriteDone) {
                    List<List<Entity>> runscript = this.failedQueue_;
                    synchronized (runscript) {
                        int cols = items.size();
                        int rows = items.get(0).rows();
                        for (int i = 0; i < rows; ++i) {
                            ArrayList<Entity> tmp = new ArrayList<Entity>();
                            if (this.tableWriter_.ifCallback_) {
                                tmp.add(((Vector)callbackList.get(0)).get(i));
                            }
                            for (int j = 0; j < cols; ++j) {
                                tmp.add(items.get(j).get(i));
                            }
                            this.failedQueue_.add(tmp);
                        }
                    }
                }
                if (this.tableWriter_.ifCallback_) {
                    int i;
                    callbackRows = ((Vector)callbackList.get(0)).rows();
                    boolean[] bArray = new boolean[callbackRows];
                    if (!isWriteDone) {
                        for (i = 0; i < callbackRows; ++i) {
                            bArray[i] = false;
                        }
                    } else {
                        for (i = 0; i < callbackRows; ++i) {
                            bArray[i] = true;
                        }
                    }
                    BasicBooleanVector bv = new BasicBooleanVector(bArray);
                    callbackList.add(bv);
                    ArrayList<String> callbackColNames = new ArrayList<String>();
                    callbackColNames.add("callbackId");
                    callbackColNames.add("isSuccess");
                    this.callbackHandler_.writeCompletion(new BasicTable(callbackColNames, callbackList));
                }
                boolean startgc = false;
                MultithreadedTableWriter multithreadedTableWriter = this.tableWriter_;
                synchronized (multithreadedTableWriter) {
                    MultithreadedTableWriter multithreadedTableWriter2 = this.tableWriter_;
                    multithreadedTableWriter2.sentRowsAfterGc_ = multithreadedTableWriter2.sentRowsAfterGc_ + addRowCount;
                    if (this.tableWriter_.sentRowsAfterGc_ > 10000) {
                        this.tableWriter_.sentRowsAfterGc_ = 0;
                        startgc = true;
                    }
                }
                if (startgc && Runtime.getRuntime().freeMemory() < 0x6400000L) {
                    System.gc();
                }
            }
            return true;
        }

        boolean init() {
            if (this.tableWriter_.mode_ == Mode.M_Append) {
                this.scriptTableInsert_ = this.tableWriter_.dbName_.isEmpty() ? "tableInsert{\"" + this.tableWriter_.tableName_ + "\"}" : "tableInsert{loadTable(\"" + this.tableWriter_.dbName_ + "\",\"" + this.tableWriter_.tableName_ + "\")}";
            } else if (this.tableWriter_.mode_ == Mode.M_Upsert) {
                StringBuilder sb = new StringBuilder();
                if (this.tableWriter_.dbName_.isEmpty()) {
                    sb.append("upsert!{" + this.tableWriter_.tableName_);
                } else {
                    sb.append("upsert!{loadTable(\"" + this.tableWriter_.dbName_ + "\",\"" + this.tableWriter_.tableName_ + "\")");
                }
                sb.append(",");
                if (this.tableWriter_.pModeOption_ != null && this.tableWriter_.pModeOption_.length != 0) {
                    for (String one : this.tableWriter_.pModeOption_) {
                        sb.append("," + one);
                    }
                }
                sb.append("}");
                this.scriptTableInsert_ = sb.toString();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void getStatus(ThreadStatus status) {
            status.threadId = this.writeThread_.getId();
            status.sentRows = this.sentRows_;
            List<List<Vector>> list = this.writeQueue_;
            synchronized (list) {
                status.unsentRows = (long)(this.writeQueue_.size() - 1) * (long)vectorSize + (long)this.writeQueue_.get(this.writeQueue_.size() - 1).get(0).rows();
            }
            status.sendFailedRows = this.failedQueue_.size();
        }

        boolean isExiting() {
            return this.exit_ || this.tableWriter_.hasError_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void exit() {
            List<List<Vector>> list = this.writeQueue_;
            synchronized (list) {
                this.exit_ = true;
                this.writeQueue_.notify();
            }
        }
    }

    public static class Status
    extends ErrorCodeInfo {
        public boolean isExiting;
        public long sentRows;
        public long unsentRows;
        public long sendFailedRows;
        public List<ThreadStatus> threadStatusList = new ArrayList<ThreadStatus>();

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("errorCode     : " + this.errorCode + "\n");
            sb.append("errorInfo     : " + this.errorInfo + "\n");
            sb.append("isExiting     : " + this.isExiting + "\n");
            sb.append("sentRows      : " + this.sentRows + "\n");
            sb.append("unsentRows    : " + this.unsentRows + "\n");
            sb.append("sendFailedRows: " + this.sendFailedRows + "\n");
            sb.append("threadStatus  :\n");
            sb.append(String.format("%16s", "threadId") + String.format("%16s", "sentRows") + String.format("%16s", "unsentRows") + String.format("%16s", "sendFailedRows") + "\n");
            for (int i = 0; i < this.threadStatusList.size(); ++i) {
                sb.append(this.threadStatusList.get(i).toString());
            }
            return sb.toString();
        }
    }

    public static enum Mode {
        M_Append(0),
        M_Upsert(1);

        private int value;

        private Mode(int value) {
            this.value = value;
        }
    }

    static class ColInfo {
        public Entity.DATA_TYPE type_ = Entity.DATA_TYPE.DT_OBJECT;
        public String name_ = "";
        public int extra_ = 0;
    }

    public static class ThreadStatus {
        public long threadId;
        public long sentRows;
        public long unsentRows;
        public long sendFailedRows;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%16s", this.threadId) + String.format("%16s", this.sentRows) + String.format("%16s", this.unsentRows) + String.format("%16s", this.unsentRows) + "\n");
            return sb.toString();
        }
    }
}

