/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SymbolBase {
    private ArrayList<String> syms = new ArrayList();
    private Map<String, Integer> symMap = null;
    private int id;

    public SymbolBase(int id) {
        this.id = id;
    }

    public SymbolBase(ExtendedDataInput in) throws IOException {
        this(in.readInt(), in);
    }

    public SymbolBase(int id, ExtendedDataInput in) throws IOException {
        this.id = id;
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.syms.add(in.readString());
        }
    }

    public int getId() {
        return this.id;
    }

    public int size() {
        return this.syms.size();
    }

    public String getSymbol(int index) {
        return this.syms.get(index);
    }

    public int find(String key) {
        if (this.symMap == null) {
            this.symMap = new HashMap<String, Integer>();
            if (this.syms.size() > 0 && !this.syms.get(0).isEmpty()) {
                throw new RuntimeException("A symbol base's first key must be empty string.");
            }
            if (this.syms.size() == 0) {
                this.symMap.put("", 0);
                this.syms.add("");
            } else {
                int count = this.syms.size();
                for (int i = 0; i < count; ++i) {
                    this.symMap.put(this.syms.get(i), i);
                }
            }
        }
        return this.symMap.getOrDefault(key, -1);
    }

    public int find(String key, boolean insertIfNotPresent) {
        Integer index;
        if (key == null) {
            throw new RuntimeException("A symbol base key string can't be null.");
        }
        if (this.symMap == null) {
            this.symMap = new HashMap<String, Integer>();
            if (this.syms.size() > 0 && !this.syms.get(0).isEmpty()) {
                throw new RuntimeException("A symbol base's first key must be empty string.");
            }
            if (this.syms.size() == 0) {
                this.symMap.put("", 0);
                this.syms.add("");
            } else {
                int count = this.syms.size();
                for (int i = 0; i < count; ++i) {
                    this.symMap.put(this.syms.get(i), i);
                }
            }
        }
        if ((index = this.symMap.get(key)) == null) {
            index = this.symMap.size();
            this.symMap.put(key, index);
            this.syms.add(key);
        }
        return index;
    }

    public void write(ExtendedDataOutput out) throws IOException {
        int count = this.syms.size();
        out.writeInt(0);
        out.writeInt(count);
        for (int i = 0; i < count; ++i) {
            out.writeString(this.syms.get(i));
        }
    }
}

