/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicIntMatrix;
import com.xxdb.data.BasicTime;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalTime;
import java.util.List;

public class BasicTimeMatrix
extends BasicIntMatrix {
    public BasicTimeMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public BasicTimeMatrix(int rows, int columns, List<int[]> listOfArrays) throws Exception {
        super(rows, columns, listOfArrays);
    }

    public BasicTimeMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setTime(int row, int column, LocalTime value) {
        this.setInt(row, column, Utils.countMilliseconds(value));
    }

    public LocalTime getTime(int row, int column) {
        return Utils.parseTime(this.getInt(row, column));
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicTime(this.getInt(row, column));
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_TIME;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicTime.class;
    }
}

