/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.SymbolBase;
import com.xxdb.data.SymbolBaseCollection;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

public class BasicSymbolVector
extends AbstractVector {
    private SymbolBase base;
    private int[] values;
    private int size;
    private int capaticy;

    public BasicSymbolVector(int size) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.base = new SymbolBase(0);
        this.values = new int[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicSymbolVector(SymbolBase base, int size) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.base = base;
        this.values = new int[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicSymbolVector(List<String> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.base = new SymbolBase(0);
        this.values = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.values[i] = list.get(i) != null ? this.base.find(list.get(i), true) : 0;
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicSymbolVector(SymbolBase base, int[] values, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.base = base;
        if (copy) {
            this.values = new int[values.length];
            System.arraycopy(values, 0, this.values, 0, values.length);
        } else {
            this.values = values;
        }
        this.size = values.length;
        this.capaticy = values.length;
    }

    protected BasicSymbolVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        ByteOrder bo;
        int rows = in.readInt();
        int columns = in.readInt();
        int size = rows * columns;
        this.values = new int[size];
        this.base = new SymbolBase(in);
        int totalBytes = size * 4;
        byte[] buf = new byte[4096];
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(buf, 0, len);
            int start = off / 4;
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getInt(i * 4);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicSymbolVector(Entity.DATA_FORM df, ExtendedDataInput in, SymbolBaseCollection collection) throws IOException {
        super(df);
        int len;
        ByteOrder bo;
        int rows = in.readInt();
        int columns = in.readInt();
        int size = rows * columns;
        this.values = new int[size];
        this.base = collection.add(in);
        int totalBytes = size * 4;
        byte[] buf = new byte[4096];
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(buf, 0, len);
            int start = off / 4;
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getInt(i * 4);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public Entity get(int index) {
        return new BasicString(this.base.getSymbol(this.values[index]));
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        int[] sub = new int[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicSymbolVector(this.base, sub, false);
    }

    @Override
    public String getString(int index) {
        return this.base.getSymbol(this.values[index]);
    }

    @Override
    public int getUnitLength() {
        return 4;
    }

    public void add(String value) {
        throw new RuntimeException("SymbolVector does not support add");
    }

    public void addRange(String[] valueList) {
        throw new RuntimeException("SymbolVector does not support addRange");
    }

    @Override
    public void Append(Scalar value) {
        if (this.size + 1 > this.capaticy) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
            this.capaticy = this.values.length;
        }
        this.values[this.size] = this.base.find(value.getString(), true);
        ++this.size;
    }

    @Override
    public void Append(Vector value) {
        throw new RuntimeException("SymbolVector does not support append a vector");
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        this.values[index] = this.base.find(value.getString(), true);
    }

    public void setString(int index, String value) {
        this.values[index] = this.base.find(value, true);
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return BasicString.hashBucket(this.base.getSymbol(this.values[index]), buckets);
    }

    @Override
    public Vector combine(Vector vector) {
        BasicSymbolVector v = (BasicSymbolVector)vector;
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        if (v.base == this.base) {
            System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        } else {
            SymbolBase vBase = v.base;
            int length = vBase.size();
            int[] mapper = new int[length];
            for (int i = 0; i < length; ++i) {
                mapper[i] = this.base.find(vBase.getSymbol(i), true);
            }
            length = v.rows();
            int[] vValues = v.values;
            int baseRow = this.rows();
            for (int i = 0; i < length; ++i) {
                newValue[baseRow + i] = mapper[vValues[i]];
            }
        }
        return new BasicSymbolVector(this.base, newValue, false);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == 0;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = 0;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.LITERAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_SYMBOL;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicString.class;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeInt(this.values[start + i]);
        }
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        int[] data = new int[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        this.base.write(out);
        out.writeIntArray(data);
    }

    public void write(ExtendedDataOutput out, SymbolBaseCollection collection) throws IOException {
        int dataType = this.getDataType().getValue() + 128;
        int flag = (Entity.DATA_FORM.DF_VECTOR.ordinal() << 8) + dataType;
        int[] data = new int[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        out.writeShort(flag);
        out.writeInt(this.rows());
        out.writeInt(this.columns());
        collection.write(out, this.base);
        out.writeIntArray(data);
    }

    @Override
    public int asof(Scalar value) {
        String target = value.getString();
        int start = 0;
        int end = this.size - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.base.getSymbol(this.values[mid]).compareTo(target) <= 0) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return end;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            out.putInt(this.values[indexStart + i]);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement * 4;
    }
}

