/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractMatrix;
import com.xxdb.data.BasicShort;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class BasicShortMatrix
extends AbstractMatrix {
    private short[] values;

    public BasicShortMatrix(int rows, int columns) {
        super(rows, columns);
        this.values = new short[rows * columns];
    }

    public BasicShortMatrix(int rows, int columns, List<short[]> list) throws Exception {
        super(rows, columns);
        this.values = new short[rows * columns];
        if (list == null || list.size() != columns) {
            throw new Exception("input list of arrays does not have " + columns + " columns");
        }
        for (int i = 0; i < columns; ++i) {
            short[] array = list.get(i);
            if (array == null || array.length != rows) {
                throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
            }
            System.arraycopy(array, 0, this.values, i * rows, rows);
        }
    }

    public BasicShortMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setShort(int row, int column, short value) {
        this.values[this.getIndex((int)row, (int)column)] = value;
    }

    public short getShort(int row, int column) {
        return this.values[this.getIndex(row, column)];
    }

    @Override
    public boolean isNull(int row, int column) {
        return this.values[this.getIndex(row, column)] == Short.MIN_VALUE;
    }

    @Override
    public void setNull(int row, int column) {
        this.values[this.getIndex((int)row, (int)column)] = Short.MIN_VALUE;
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicShort(this.values[this.getIndex(row, column)]);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_SHORT;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicShort.class;
    }

    @Override
    protected void readMatrixFromInputStream(int rows, int columns, ExtendedDataInput in) throws IOException {
        int len;
        ByteOrder bo;
        int size = rows * columns;
        this.values = new short[size];
        long totalBytes = (long)size * 2L;
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (long off = 0L; off < totalBytes; off += (long)len) {
            len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = (int)(off / 2L);
            int end = len / 2;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getShort(i * 2);
            }
        }
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        for (short value : this.values) {
            out.writeShort(value);
        }
    }
}

