/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicLongVector;
import com.xxdb.data.BasicNanoTime;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalTime;
import java.util.List;

public class BasicNanoTimeVector
extends BasicLongVector {
    public BasicNanoTimeVector(int size) {
        super(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicNanoTimeVector(List<Long> list) {
        super(list);
    }

    public BasicNanoTimeVector(long[] array) {
        super(array);
    }

    protected BasicNanoTimeVector(long[] array, boolean copy) {
        super(array, copy);
    }

    protected BasicNanoTimeVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicNanoTimeVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_NANOTIME;
    }

    @Override
    public Entity get(int index) {
        return new BasicNanoTime(this.getLong(index));
    }

    @Override
    public Vector getSubVector(int[] indices) {
        return new BasicNanoTimeVector(this.getSubArray(indices), false);
    }

    public LocalTime getNanoTime(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return Utils.parseNanoTime(this.getLong(index));
    }

    public void setNanoTime(int index, LocalTime time) {
        this.setLong(index, Utils.countNanoseconds(time));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicNanoTime.class;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicNanoTimeVector v = (BasicNanoTimeVector)vector;
        int newSize = this.rows() + v.rows();
        long[] newValue = new long[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicNanoTimeVector(newValue);
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().longValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicNanoTimeVector)value).getdataArray());
    }
}

