/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.compression.EncoderFactory;
import com.xxdb.data.AbstractEntity;
import com.xxdb.data.BasicSymbolVector;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class AbstractVector
extends AbstractEntity
implements Vector {
    private Entity.DATA_FORM df_;
    protected int compressedMethod = 1;

    protected abstract void writeVectorToOutputStream(ExtendedDataOutput var1) throws IOException;

    public AbstractVector(Entity.DATA_FORM df) {
        this.df_ = df;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        throw new RuntimeException("Vector.serialize not implemented yet.");
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        throw new RuntimeException("Vector.deserialize not implemented yet.");
    }

    @Override
    public Entity.DATA_FORM getDataForm() {
        return this.df_;
    }

    @Override
    public int columns() {
        return 1;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return -1;
    }

    @Override
    public String getString(int index) {
        return this.get(index).getString();
    }

    @Override
    public String getJsonString(int rowIndex) {
        throw new RuntimeException("Only ArrayVector Support getJsonString");
    }

    @Override
    public String getString() {
        StringBuilder sb = new StringBuilder("[");
        int size = Math.min(10, this.rows());
        if (size > 0) {
            sb.append(this.getString(0));
        }
        for (int i = 1; i < size; ++i) {
            sb.append(',');
            sb.append(this.getString(i));
        }
        if (size < this.rows()) {
            sb.append(",...");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(ExtendedDataOutput out) throws IOException {
        int dataType = this.getDataType().getValue();
        int flag = (this.df_.ordinal() << 8) + dataType;
        if (this instanceof BasicSymbolVector) {
            flag += 128;
        }
        out.writeShort(flag);
        out.writeInt(this.rows());
        out.writeInt(this.columns());
        if (Entity.DATA_TYPE.valueOf(dataType) == Entity.DATA_TYPE.DT_DECIMAL32_ARRAY || Entity.DATA_TYPE.valueOf(dataType) == Entity.DATA_TYPE.DT_DECIMAL64_ARRAY || Entity.DATA_TYPE.valueOf(dataType) == Entity.DATA_TYPE.DT_DECIMAL128_ARRAY) {
            out.writeInt(this.getExtraParamForType());
        }
        this.writeVectorToOutputStream(out);
    }

    @Override
    public abstract int getUnitLength();

    @Override
    public abstract void Append(Scalar var1) throws Exception;

    @Override
    public abstract void Append(Vector var1) throws Exception;

    public static boolean checkCompressedMethod(Entity.DATA_TYPE type, int compressedMethod) {
        if (compressedMethod == 2) {
            if (type.getValue() > 64) {
                return false;
            }
            switch (type) {
                case DT_SHORT: 
                case DT_INT: 
                case DT_DATE: 
                case DT_MONTH: 
                case DT_TIME: 
                case DT_MINUTE: 
                case DT_SECOND: 
                case DT_DATETIME: 
                case DT_DATEHOUR: 
                case DT_DATEMINUTE: 
                case DT_LONG: 
                case DT_NANOTIME: 
                case DT_TIMESTAMP: 
                case DT_NANOTIMESTAMP: {
                    return true;
                }
            }
            return false;
        }
        return compressedMethod == 1;
    }

    public void setCompressedMethod(int method) {
        Entity.DATA_TYPE type = this.getDataType();
        boolean check = AbstractVector.checkCompressedMethod(type, method);
        if (!check) {
            throw new RuntimeException("Compression Failed: only support integral and temporal data, not support " + this.getDataType().name());
        }
        this.compressedMethod = method;
    }

    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        throw new RuntimeException("Invalid datatype to write to buffer");
    }

    public static int getUnitLength(Entity.DATA_TYPE type) {
        int unitLength;
        if (type.getValue() > 64) {
            type = Entity.DATA_TYPE.valueOf(type.getValue() - 64);
        }
        switch (type) {
            case DT_STRING: 
            case DT_BLOB: {
                unitLength = 0;
                break;
            }
            case DT_BOOL: 
            case DT_BYTE: {
                unitLength = 1;
                break;
            }
            case DT_SHORT: {
                unitLength = 2;
                break;
            }
            case DT_INT: 
            case DT_DATE: 
            case DT_MONTH: 
            case DT_TIME: 
            case DT_MINUTE: 
            case DT_SECOND: 
            case DT_DATETIME: 
            case DT_DATEHOUR: 
            case DT_DATEMINUTE: 
            case DT_FLOAT: 
            case DT_SYMBOL: 
            case DT_DECIMAL32: {
                unitLength = 4;
                break;
            }
            case DT_LONG: 
            case DT_NANOTIME: 
            case DT_TIMESTAMP: 
            case DT_NANOTIMESTAMP: 
            case DT_DOUBLE: 
            case DT_DURATION: 
            case DT_DECIMAL64: {
                unitLength = 8;
                break;
            }
            case DT_INT128: 
            case DT_UUID: 
            case DT_IPADDR: 
            case DT_COMPLEX: 
            case DT_POINT: 
            case DT_DECIMAL128: {
                unitLength = 16;
                break;
            }
            default: {
                throw new RuntimeException("Compression Failed: only support integral and temporal data, not support " + type.name());
            }
        }
        return unitLength;
    }

    public int getExtraParamForType() {
        throw new RuntimeException("Not support yet");
    }

    public void setExtraParamForType(int scale) {
        throw new RuntimeException("Not support yet");
    }

    @Override
    public void writeCompressed(ExtendedDataOutput output) throws IOException {
        int dataType = this.getDataType().getValue();
        int unitLength = AbstractVector.getUnitLength(this.getDataType());
        int elementCount = this.rows();
        int maxCompressedLength = this.rows() * 8 * 8 * 2 + 192;
        ByteBuffer out = output instanceof LittleEndianDataOutputStream ? ByteBuffer.allocate(Math.max(maxCompressedLength, 655360)).order(ByteOrder.LITTLE_ENDIAN) : ByteBuffer.allocate(Math.max(maxCompressedLength, 655360)).order(ByteOrder.BIG_ENDIAN);
        short flag = (short)(Entity.DATA_FORM.DF_VECTOR.ordinal() << 8 | Entity.DATA_TYPE.DT_COMPRESS.getValue() & 0xFF);
        out.putShort(flag);
        out.putInt(0);
        out.putInt(1);
        out.put((byte)0);
        out.put((byte)1);
        out.put((byte)-1);
        out.put((byte)this.compressedMethod);
        out.put((byte)dataType);
        out.put((byte)unitLength);
        if (Entity.DATA_TYPE.valueOf(dataType) == Entity.DATA_TYPE.DT_DECIMAL32 || Entity.DATA_TYPE.valueOf(dataType) == Entity.DATA_TYPE.DT_DECIMAL64 || Entity.DATA_TYPE.valueOf(dataType) == Entity.DATA_TYPE.DT_DECIMAL128 || Entity.DATA_TYPE.valueOf(dataType) == Entity.DATA_TYPE.DT_DECIMAL32_ARRAY || Entity.DATA_TYPE.valueOf(dataType) == Entity.DATA_TYPE.DT_DECIMAL64_ARRAY || Entity.DATA_TYPE.valueOf(dataType) == Entity.DATA_TYPE.DT_DECIMAL128_ARRAY) {
            out.put((byte)this.getExtraParamForType());
        } else {
            out.position(out.position() + 1);
        }
        out.position(out.position() + 1);
        out.putInt(-1);
        out.putInt(elementCount);
        out.putInt(-1);
        out = EncoderFactory.get(this.compressedMethod).compress(this, elementCount, unitLength, maxCompressedLength, out);
        int compressedLength = out.position() - 10;
        out.putInt(2, compressedLength);
        output.write(out.array(), 0, compressedLength + 10);
    }

    public static class Offect {
        public int offect;

        public Offect(int offect) {
            this.offect = offect;
        }
    }

    public static class NumElementAndPartial {
        public int numElement;
        public int partial;

        public NumElementAndPartial(int numElement, int partial) {
            this.partial = partial;
            this.numElement = numElement;
        }
    }
}

