/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.comm;

public class ErrorCodeInfo {
    public String errorCode;
    public String errorInfo;

    public ErrorCodeInfo() {
        this.set(0, "");
    }

    public ErrorCodeInfo(int code, String info) {
        this.set(code, info);
    }

    public ErrorCodeInfo(Code code, String info) {
        this.set(code, info);
    }

    public ErrorCodeInfo(ErrorCodeInfo src) {
        this.set(src.errorCode, src.errorInfo);
    }

    public void set(ErrorCodeInfo errorCodeInfo) {
        this.set(errorCodeInfo.errorCode, errorCodeInfo.errorInfo);
    }

    public void set(int code, String info) {
        this.set(ErrorCodeInfo.formatApiCode(code), info);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("code=").append(this.errorCode).append(" info=").append(this.errorInfo);
        return sb.toString();
    }

    public void set(Code code, String info) {
        this.set(ErrorCodeInfo.formatApiCode(code.value), info);
    }

    public void set(String code, String info) {
        this.errorCode = code;
        this.errorInfo = info;
    }

    public void clearError() {
        this.errorCode = "";
        this.errorInfo = "";
    }

    public boolean hasError() {
        return !this.errorCode.isEmpty();
    }

    public boolean succeed() {
        return this.errorCode.isEmpty();
    }

    public static String formatApiCode(int code) {
        if (code != Code.EC_None.value) {
            return "A" + code;
        }
        return "";
    }

    public static enum Code {
        EC_None(0),
        EC_InvalidObject(1),
        EC_InvalidParameter(2),
        EC_InvalidTable(3),
        EC_InvalidColumnType(4),
        EC_Server(5),
        EC_UserBreak(6),
        EC_DestroyedObject(7),
        EC_OTHER(8);

        public int value;

        private Code(int value) {
            this.value = value;
        }
    }
}

