/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.dolphindb.jdbc.Driver;
import com.dolphindb.jdbc.JDBCConnection;
import com.dolphindb.jdbc.JDBCResultSet;
import com.dolphindb.jdbc.Utils;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.EntityBlockReader;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Queue;

public class JDBCStatement
implements Statement {
    protected JDBCConnection connection;
    protected ResultSet resultSet;
    protected StringBuilder batch;
    protected Queue<Object> objectQueue;
    protected Object result;
    protected Deque<ResultSet> resultSets;
    protected HashMap<String, String> tableTypes;
    protected static final String IN_MEMORY_TABLE = "IN-MEMORY TABLE";
    protected boolean isClosed;
    private int timeout = 100;
    private int fetchSize = 0;

    public JDBCStatement(JDBCConnection cnn) {
        this.connection = cnn;
        this.objectQueue = new LinkedList<Object>();
        this.resultSets = new LinkedList<ResultSet>();
        this.batch = new StringBuilder();
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return 0L;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return new long[0];
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return 0L;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return 0L;
    }

    private String getTableType(String tableName) throws SQLException {
        String tableType;
        if (this.tableTypes == null) {
            this.tableTypes = new LinkedHashMap<String, String>();
        }
        if ((tableType = this.tableTypes.get(tableName)) == null) {
            try {
                tableType = this.connection.run("typestr " + tableName).getString();
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            this.tableTypes.put(tableName, tableType);
            return tableType;
        }
        return tableType;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        sql = Utils.changeCase(sql, this.connection);
        sql = sql.trim();
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        if ((sql = sql.trim()) != null && sql.equals("select 1")) {
            sql = "select 1 as val";
        }
        sql = Utils.outerJoinToFullJoin(sql);
        sql = Utils.oracleToDolphin(sql);
        String[] strings = sql.split(";");
        String lastStatement = strings[strings.length - 1].trim();
        int dml = Utils.getDml(lastStatement);
        switch (dml) {
            case 1: 
            case 2: 
            case 3: {
                throw new SQLException("The given SQL statement produces anything other than a single ResultSet object.");
            }
            case -1: 
            case 0: 
            case 4: {
                try {
                    Entity entity;
                    if (this.fetchSize != 0) {
                        if (this.fetchSize < 8192) {
                            throw new SQLException("The fetchSize param must be greater than 8192.");
                        }
                        entity = this.connection.run(sql, this.fetchSize);
                    } else {
                        entity = this.connection.run(sql);
                    }
                    if (entity instanceof BasicTable) {
                        this.resultSet = new JDBCResultSet(this.connection, this, entity, sql);
                        return this.resultSet;
                    }
                    if (entity instanceof EntityBlockReader) {
                        this.resultSet = new JDBCResultSet(this.connection, this, (EntityBlockReader)entity, sql);
                        return this.resultSet;
                    }
                    if (entity.getDataForm() == Entity.DATA_FORM.DF_VECTOR) {
                        this.resultSet = new JDBCResultSet(this.connection, this, entity, sql);
                        return this.resultSet;
                    }
                    if (entity.getDataForm() == Entity.DATA_FORM.DF_SCALAR) {
                        this.resultSet = new JDBCResultSet(this.connection, this, entity, sql);
                        return this.resultSet;
                    }
                    throw new SQLException("The given SQL statement produces anything other than a single ResultSet object.");
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            }
        }
        throw new SQLException("The given SQL statement produces anything other than a single ResultSet object.");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        Entity entity;
        sql = sql.trim();
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        String[] strings = sql.split(";");
        String lastStatement = strings[strings.length - 1].trim();
        String tableName = Utils.getTableName(lastStatement);
        int dml = Utils.getDml(lastStatement);
        switch (dml) {
            case 1: {
                if (tableName != null) {
                    String tableType = this.getTableType(tableName);
                    if (tableType.equals(IN_MEMORY_TABLE)) {
                        try {
                            return this.tableInsert(tableName, sql).getInt();
                        }
                        catch (IOException e) {
                            throw new SQLException(e);
                        }
                    }
                    String[] values = lastStatement.substring(lastStatement.indexOf("values") + "values".length()).replaceAll("\\(|\\)", "").split(",");
                    StringBuilder sqlSb = new StringBuilder("append!(").append(tableName).append(",").append("table(");
                    String colName = "col";
                    int colIndex = 1;
                    for (String value : values) {
                        sqlSb.append(value).append(" as ").append(colName + colIndex).append(",");
                        ++colIndex;
                    }
                    sqlSb.delete(sqlSb.length() - ",".length(), sqlSb.length());
                    sqlSb.append("))");
                    try {
                        this.connection.run(sqlSb.toString());
                        return -2;
                    }
                    catch (IOException e) {
                        new SQLException(e);
                    }
                } else {
                    throw new SQLException("check the SQL " + sql);
                }
            }
            case 2: 
            case 3: {
                if (tableName != null) {
                    try {
                        this.connection.run(sql);
                        return -2;
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                }
                throw new SQLException("check the Query " + sql);
            }
            case 0: 
            case 4: {
                throw new SQLException("Can not issue SELECT or EXEC via executeUpdate()");
            }
        }
        try {
            entity = this.connection.run(sql);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        if (entity instanceof BasicTable) {
            throw new SQLException("Can not produces ResultSet");
        }
        return 0;
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        this.batch = null;
        this.result = null;
        if (this.objectQueue != null) {
            this.objectQueue.clear();
            this.objectQueue = null;
        }
        if (this.resultSet != null) {
            this.resultSet.close();
            this.objectQueue = null;
        }
        if (this.tableTypes != null) {
            this.tableTypes.clear();
            this.tableTypes = null;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        Driver.unused();
    }

    @Override
    public void setEscapeProcessing(boolean b) throws SQLException {
        Driver.unused();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    @Override
    public void setQueryTimeout(int queryTimeout) throws SQLException {
        this.timeout = queryTimeout * 1000;
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String cursorName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public String trimFirstAndLastChar(String str, String element) {
        boolean beginIndexFlag = true;
        boolean endIndexFlag = true;
        do {
            int beginIndex = str.indexOf(element) == 0 ? 1 : 0;
            int endIndex = str.lastIndexOf(element) + 1 == str.length() ? str.lastIndexOf(element) : str.length();
            str = str.substring(beginIndex, endIndex);
            beginIndexFlag = str.indexOf(element) == 0;
            boolean bl = endIndexFlag = str.lastIndexOf(element) + 1 == str.length();
        } while (beginIndexFlag || endIndexFlag);
        return str;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        sql = Utils.changeCase(sql);
        sql = sql.trim();
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        if ((sql = sql.trim()) != null && sql.equals("select 1")) {
            sql = "select 1 as val";
        }
        if (sql.startsWith("[") && sql.endsWith("]")) {
            String[] strings;
            String temp = this.trimFirstAndLastChar(sql, "[");
            sql = this.trimFirstAndLastChar(temp, "]");
            String[] statementbatch = strings = sql.split(",");
            for (int i = 0; i < statementbatch.length; ++i) {
                ResultSet resultSet_batch = this.executeQuery(statementbatch[i]);
                this.resultSets.offerLast(resultSet_batch);
                this.objectQueue.offer(resultSet_batch);
            }
            if (this.objectQueue.isEmpty()) {
                return false;
            }
            this.result = this.objectQueue.poll();
            return this.result instanceof ResultSet;
        }
        String[] strings = sql.split(";");
        String lastStatement = strings[strings.length - 1].trim();
        int dml = Utils.getDml(lastStatement);
        switch (dml) {
            case 0: 
            case 4: {
                ResultSet resultSet_ = this.executeQuery(sql);
                this.resultSets.offerLast(resultSet_);
                this.objectQueue.offer(resultSet_);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.objectQueue.offer(this.executeUpdate(sql));
                break;
            }
            default: {
                Entity entity;
                try {
                    entity = this.connection.run(sql);
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                if (!(entity instanceof BasicTable)) break;
                JDBCResultSet resultSet_ = new JDBCResultSet(this.connection, this, entity, sql);
                this.resultSets.offerLast(resultSet_);
                this.objectQueue.offer(resultSet_);
            }
        }
        if (this.objectQueue.isEmpty()) {
            return false;
        }
        this.result = this.objectQueue.poll();
        return this.result instanceof ResultSet;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.resultSet = this.result == null ? null : (this.result instanceof ResultSet ? (JDBCResultSet)this.result : null);
        this.result = null;
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int updateCount = this.result == null ? -1 : (this.result instanceof Integer ? (Integer)this.result : -1);
        this.result = null;
        return updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        while (!this.resultSets.isEmpty()) {
            ResultSet resultSet_ = this.resultSets.pollFirst();
            if (resultSet_ != null) continue;
            resultSet_.close();
        }
        if (!this.objectQueue.isEmpty()) {
            this.result = this.objectQueue.poll();
            return this.result instanceof ResultSet;
        }
        return false;
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        Driver.unused();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        Driver.unused();
        return 0;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.fetchSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        Driver.unused();
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        Driver.unused();
        return 0;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.batch.append(sql).append(";\n");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batch.delete(0, this.batch.length());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        String[] strings = this.batch.toString().split(";");
        int[] arr_int = new int[strings.length];
        int index = 0;
        try {
            for (String item : strings) {
                arr_int[index] = this.executeUpdate(item);
                ++index;
            }
            this.batch.delete(0, this.batch.length());
            return arr_int;
        }
        catch (SQLException e) {
            this.batch.delete(0, this.batch.length());
            throw new BatchUpdateException(e.getMessage(), Arrays.copyOf(arr_int, index));
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        switch (current) {
            case 3: {
                while (!this.resultSets.isEmpty()) {
                    ResultSet resultSet_ = this.resultSets.pollLast();
                    if (resultSet_ == null) continue;
                    resultSet_.close();
                }
                break;
            }
            case 1: {
                if (this.resultSet == null) break;
                this.resultSet.close();
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new SQLException("The argument supplied is not one of the following:\nStatement.CLOSE_CURRENT_RESULT,\nStatement.KEEP_CURRENT_RESULT or\n Statement.CLOSE_ALL_RESULTS");
            }
        }
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Driver.unused();
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        Driver.unused();
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean b) throws SQLException {
        Driver.unused();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        Driver.unused();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        Driver.unused();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        Driver.unused();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        return aClass.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return aClass.isInstance(this);
    }

    protected BasicInt tableInsert(String tableName, String sql) throws IOException {
        if (sql.startsWith("tableInsert")) {
            return (BasicInt)this.connection.run(sql);
        }
        int index = sql.indexOf(";");
        String values = index == -1 ? sql.substring(sql.indexOf("values") + "values".length()) : sql.substring(sql.indexOf("values") + "values".length(), index);
        String new_sql = MessageFormat.format("tableInsert({0},{1})", tableName, values);
        BasicInt n = (BasicInt)this.connection.run(new_sql);
        return n;
    }
}

