/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.dolphindb.jdbc.Driver;
import com.dolphindb.jdbc.JDBCCallableStatement;
import com.dolphindb.jdbc.JDBCDataBaseMetaData;
import com.dolphindb.jdbc.JDBCPrepareStatement;
import com.dolphindb.jdbc.JDBCStatement;
import com.dolphindb.jdbc.Utils;
import com.xxdb.DBConnection;
import com.xxdb.comm.SqlStdEnum;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.Entity;
import com.xxdb.data.Vector;
import com.xxdb.io.ProgressListener;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;

public class JDBCConnection
implements Connection {
    private DBConnection dbConnection;
    private final String hostName;
    private final int port;
    private boolean success;
    private String databases;
    private Vector tables;
    private final String url;
    private DatabaseMetaData metaData;
    private String user;
    private String password;
    private Properties clientInfo = new Properties();

    public JDBCConnection(String url, Properties prop) throws SQLException {
        this.url = url;
        String sqlStdProp = prop.getProperty("sqlStd");
        if (Objects.nonNull(sqlStdProp)) {
            SqlStdEnum sqlStd = SqlStdEnum.getByName(sqlStdProp);
            this.dbConnection = new DBConnection(sqlStd);
        } else {
            this.dbConnection = new DBConnection();
        }
        this.hostName = prop.getProperty("hostName");
        this.port = Integer.parseInt(prop.getProperty("port"));
        this.setUser(null);
        this.setPassword(null);
        this.clientInfo = prop;
        try {
            this.open(this.hostName, this.port, prop);
        }
        catch (IOException e) {
            e.printStackTrace();
            String s = e.getMessage();
            if (s.contains("Connection refused")) {
                throw new SQLException(MessageFormat.format("{0}  ==> hostName = {1}, port = {2}", s, this.hostName, this.port));
            }
            throw new SQLException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DBConnection getDBConnection() {
        return this.dbConnection;
    }

    public void setDBConnection(DBConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    private void connect(String hostname, int port, Properties prop, String appendInitScript) throws IOException, SQLException {
        String tableAliasValue;
        String userId = prop.getProperty("user");
        String password = prop.getProperty("password");
        String initialScript = prop.getProperty("initialScript");
        if ((initialScript = Utils.changeCase(initialScript)) != null && initialScript.equals("select 1")) {
            initialScript = "select 1 as val";
        }
        if (appendInitScript != null) {
            initialScript = initialScript != null ? appendInitScript + "\n" + initialScript : appendInitScript;
        }
        String highAvailabilityStr = prop.getProperty("highAvailability");
        String enableHighAvailabilityStr = prop.getProperty("enableHighAvailability");
        Boolean highAvailability = false;
        if (highAvailabilityStr == null) {
            highAvailability = Boolean.valueOf(enableHighAvailabilityStr);
        } else if (enableHighAvailabilityStr == null) {
            highAvailability = Boolean.valueOf(highAvailabilityStr);
        } else {
            Boolean param2;
            Boolean param1 = Boolean.valueOf(highAvailabilityStr);
            if (param1 != (param2 = Boolean.valueOf(enableHighAvailabilityStr))) {
                throw new SQLException("The values of the \"highAvailability\" and \"enableHighAvailability\" parameters in the URL must be the same if both are configured. ");
            }
            highAvailability = param1;
        }
        String rowHighAvailabilitySites = prop.getProperty("highAvailabilitySites");
        String[] highAvailabilitySites = null;
        if (rowHighAvailabilitySites != null) {
            if (rowHighAvailabilitySites.contains(",")) {
                highAvailabilitySites = rowHighAvailabilitySites.split(",");
                highAvailabilitySites = (String[])Arrays.stream(highAvailabilitySites).map(String::trim).toArray(String[]::new);
            } else {
                highAvailabilitySites = rowHighAvailabilitySites.split(" ");
            }
        }
        if (Utils.isNotEmpty(tableAliasValue = prop.getProperty("tableAlias"))) {
            String tableAliasScript = Utils.parseTableAliasPropToScript(tableAliasValue);
            initialScript = Objects.nonNull(initialScript) ? initialScript + "\n" + tableAliasScript : tableAliasScript;
        }
        this.success = userId != null && password != null ? (highAvailability.booleanValue() ? this.dbConnection.connect(hostname, port, userId, password, initialScript, highAvailability, highAvailabilitySites) : this.dbConnection.connect(hostname, port, userId, password, initialScript, false, null, true)) : (initialScript != null && highAvailabilitySites != null ? this.dbConnection.connect(hostname, port, initialScript, highAvailabilitySites) : this.dbConnection.connect(this.hostName, port, "", "", null, false, null, true));
    }

    private String loadTables(String dbName, List<String> tableNames, boolean ignoreError) {
        StringBuilder sbInitScript = new StringBuilder();
        for (String tableName : tableNames) {
            StringBuilder builder = new StringBuilder();
            builder.append("loadTable(\"").append(dbName).append("\", \"").append(tableName).append("\");");
            try {
                this.dbConnection.run(builder.toString());
                sbInitScript.append(tableName).append("=").append("loadTable(\"").append(dbName).append("\", \"").append(tableName).append("\");\n");
            }
            catch (Exception e) {
                if (ignoreError) {
                    System.out.println("Load table " + dbName + "." + tableName + " failed " + e.getMessage());
                    tableNames.remove(tableName);
                    continue;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return sbInitScript.toString();
    }

    private void open(String hostname, int port, Properties prop) throws SQLException, IOException {
        int length;
        String hasScripts;
        this.connect(hostname, port, prop, null);
        if (!this.success) {
            throw new SQLException("Connection is failed");
        }
        StringBuffer sbInitScript = new StringBuffer();
        String[] key = new String[]{"databasePath"};
        String[] valueName = Utils.getProperties(prop, key);
        if (valueName[0] != null && valueName[0].length() > 0) {
            this.dbConnection.run("system_db = database(\"" + valueName[0] + "\");\n");
            if (valueName[0].trim().startsWith("dfs://")) {
                this.databases = valueName[0];
                ArrayList<String> dbtables = new ArrayList<String>();
                if (Utils.isNotEmpty(prop.getProperty("tableName"))) {
                    String[] tableNames;
                    String tablename = prop.getProperty("tableName");
                    tablename = tablename.trim();
                    for (String tableName : tableNames = tablename.split(",")) {
                        if (tableName.isEmpty()) continue;
                        dbtables.add(tableName);
                    }
                    String script = this.loadTables(this.databases, dbtables, false);
                    sbInitScript.append(script);
                } else {
                    Vector vector = (Vector)this.dbConnection.run("getTables(system_db)");
                    for (int i = 0; i < vector.rows(); ++i) {
                        dbtables.add(vector.getString(i));
                    }
                    String script = this.loadTables(this.databases, dbtables, true);
                    sbInitScript.append(script);
                }
                this.tables = new BasicStringVector(dbtables);
            }
        }
        if ((hasScripts = prop.getProperty("length")) != null && (length = Integer.parseInt(prop.getProperty("length"))) > 0) {
            for (int i = 0; i < length; ++i) {
                sbInitScript.append(prop.getProperty("script" + i) + "\n");
            }
        }
        if (sbInitScript.length() > 0) {
            this.connect(hostname, port, prop, sbInitScript.toString());
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkIsClosed();
        return new JDBCStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new JDBCPrepareStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new JDBCCallableStatement(this, sql);
    }

    @Override
    public String nativeSQL(String s) throws SQLException {
        this.checkIsClosed();
        return s;
    }

    @Override
    public void setAutoCommit(boolean b) throws SQLException {
        this.checkIsClosed();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkIsClosed();
        return true;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.dbConnection.close();
        this.dbConnection = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.dbConnection == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIsClosed();
        if (this.metaData == null) {
            this.metaData = new JDBCDataBaseMetaData(this, null);
        }
        return this.metaData;
    }

    @Override
    public void setReadOnly(boolean b) throws SQLException {
        this.checkIsClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkIsClosed();
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        Driver.unused("setCatalog not implemented");
    }

    @Override
    public String getCatalog() throws SQLException {
        StringBuilder sb = new StringBuilder();
        if (this.databases != null) {
            return this.databases;
        }
        try {
            BasicStringVector dbs = (BasicStringVector)this.dbConnection.run("getClusterDFSDatabases()");
            for (int i = 0; i < dbs.rows(); ++i) {
                sb.append(dbs.getString(i) + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        Driver.unused("getTypeMap not implemented");
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        Driver.unused("setSavepoint not supported");
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        Driver.unused("setSavepoint not supported");
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Driver.unused("rollback not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Driver.unused("releaseSavepoint not supported");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIsClosed();
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIsClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIsClosed();
        return this.prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkIsClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkIsClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkIsClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        Driver.unused("createClob not implemented");
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        Driver.unused("createBlob not implemented");
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        Driver.unused("createNClob()");
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        Driver.unused("createSQLXML()");
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.dbConnection.isConnected();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.clientInfo.setProperty(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.clientInfo = properties;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        this.checkIsClosed();
        return aClass.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        this.checkIsClosed();
        return aClass.isInstance(this);
    }

    private void checkIsClosed() throws SQLException {
        if (this.dbConnection == null) {
            throw new SQLException("connection isClosed");
        }
        if (this == null || this.isClosed()) {
            throw new SQLException("connection isClosed");
        }
    }

    public Entity run(String function, List<Entity> arguments) throws IOException {
        return this.dbConnection.run(function, arguments);
    }

    public Entity run(String script) throws IOException {
        return this.dbConnection.run(script);
    }

    public Entity run(String script, int fetchSize) throws IOException {
        return this.dbConnection.run(script, (ProgressListener)null, 4, 2, fetchSize);
    }

    public String getUrl() {
        return this.url;
    }

    public String getHostName() {
        if (this.dbConnection != null) {
            return this.dbConnection.getHostName();
        }
        return null;
    }

    public int getPort() {
        if (this.dbConnection != null) {
            return this.dbConnection.getPort();
        }
        return -1;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.databases;
    }
}

