/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderImplEnum;
import com.alibaba.fastjson2.reader.ObjectReaderImplEnum2X4;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;

final class ObjectReaderSeeAlso<T>
extends ObjectReaderAdapter<T> {
    ObjectReaderSeeAlso(Class objectType, Supplier<T> defaultCreator, String typeKey, Class[] seeAlso, String[] seeAlsoNames, Class seeAlsoDefault, FieldReader ... fieldReaders) {
        super(objectType, typeKey, null, JSONReader.Feature.SupportAutoType.mask, null, defaultCreator, null, seeAlso, seeAlsoNames, seeAlsoDefault, fieldReaders);
    }

    ObjectReaderSeeAlso addSubType(Class subTypeClass, String subTypeClassName) {
        JSONType jsonType;
        for (Class item : this.seeAlso) {
            if (item != subTypeClass) continue;
            return this;
        }
        Class[] seeAlso1 = Arrays.copyOf(this.seeAlso, this.seeAlso.length + 1);
        String[] seeAlsoNames1 = Arrays.copyOf(this.seeAlsoNames, this.seeAlsoNames.length + 1);
        seeAlso1[seeAlso1.length - 1] = subTypeClass;
        if (subTypeClassName == null && (jsonType = subTypeClass.getAnnotation(JSONType.class)) != null) {
            subTypeClassName = jsonType.typeName();
        }
        if (subTypeClassName != null) {
            seeAlsoNames1[seeAlsoNames1.length - 1] = subTypeClassName;
        }
        return new ObjectReaderSeeAlso<T>(this.objectClass, this.creator, this.typeKey, seeAlso1, seeAlsoNames1, this.seeAlsoDefault, this.fieldReaders);
    }

    @Override
    public T createInstance(long features) {
        if (this.creator == null) {
            return null;
        }
        return this.creator.get();
    }

    @Override
    public T readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if (jsonReader.nextIfNull()) {
            jsonReader.nextIfMatch(',');
            return null;
        }
        if (jsonReader.isString()) {
            long valueHashCode = jsonReader.readValueHashCode();
            for (Class seeAlsoType : this.seeAlso) {
                if (!Enum.class.isAssignableFrom(seeAlsoType)) continue;
                ObjectReader seeAlsoTypeReader = jsonReader.getObjectReader(seeAlsoType);
                Enum e = null;
                if (seeAlsoTypeReader instanceof ObjectReaderImplEnum) {
                    e = ((ObjectReaderImplEnum)seeAlsoTypeReader).getEnumByHashCode(valueHashCode);
                } else if (seeAlsoTypeReader instanceof ObjectReaderImplEnum2X4) {
                    e = ((ObjectReaderImplEnum2X4)seeAlsoTypeReader).getEnumByHashCode(valueHashCode);
                }
                if (e == null) continue;
                return (T)e;
            }
            String strVal = jsonReader.getString();
            throw new JSONException(jsonReader.info("not support input " + strVal));
        }
        JSONReader.SavePoint savePoint = jsonReader.mark();
        long featuresAll = jsonReader.features(this.getFeatures() | features);
        if (jsonReader.isArray()) {
            if ((featuresAll & JSONReader.Feature.SupportArrayToBean.mask) != 0L) {
                return this.readArrayMappingObject(jsonReader, fieldType, fieldName, features);
            }
            return this.processObjectInputSingleItemArray(jsonReader, fieldType, fieldName, featuresAll);
        }
        Object object = null;
        boolean objectStart = jsonReader.nextIfMatch('{');
        if (!objectStart) {
            char ch = jsonReader.current();
            if (ch == 't' || ch == 'f') {
                jsonReader.readBoolValue();
                return null;
            }
            if (ch != '\"' && ch != '\'' && ch != '}') {
                throw new JSONException(jsonReader.info());
            }
        }
        int i = 0;
        while (true) {
            long features3;
            if (jsonReader.nextIfMatch('}')) {
                if (object != null) break;
                object = this.createInstance(jsonReader.getContext().getFeatures() | features);
                break;
            }
            JSONReader.Context context = jsonReader.getContext();
            long hash = jsonReader.readFieldNameHashCode();
            JSONReader.AutoTypeBeforeHandler autoTypeFilter = context.getContextAutoTypeBeforeHandler();
            if (hash == this.getTypeKeyHash() && (((features3 = features | this.getFeatures() | context.getFeatures()) & JSONReader.Feature.SupportAutoType.mask) != 0L || autoTypeFilter != null)) {
                Class<?> filterClass;
                ObjectReader reader = null;
                long typeHash = jsonReader.readTypeHashCode();
                Number typeNumber = null;
                String typeNumberStr = null;
                if (typeHash == -1L && jsonReader.isNumber()) {
                    typeNumber = jsonReader.readNumber();
                    typeNumberStr = typeNumber.toString();
                    typeHash = Fnv.hashCode64(typeNumberStr);
                }
                if (autoTypeFilter != null && (filterClass = autoTypeFilter.apply(typeHash, this.objectClass, features3)) == null && (filterClass = autoTypeFilter.apply(jsonReader.getString(), this.objectClass, features3)) != null) {
                    reader = context.getObjectReader(filterClass);
                }
                if (reader == null) {
                    reader = this.autoType(context, typeHash);
                }
                String typeName = null;
                if (reader == null) {
                    typeName = jsonReader.getString();
                    reader = context.getObjectReaderAutoType(typeName, this.objectClass, features3);
                    if (reader == null && this.seeAlsoDefault != null) {
                        reader = context.getObjectReader(this.seeAlsoDefault);
                    }
                    if (reader == null) {
                        throw new JSONException(jsonReader.info("No suitable ObjectReader found for" + typeName));
                    }
                }
                if (reader != this) {
                    FieldReader fieldReader = reader.getFieldReader(hash);
                    if (fieldReader != null && typeName == null) {
                        typeName = typeNumberStr != null ? typeNumberStr : jsonReader.getString();
                    }
                    if (i != 0) {
                        jsonReader.reset(savePoint);
                    }
                    object = reader.readObject(jsonReader, fieldType, fieldName, features | this.getFeatures());
                    if (fieldReader != null) {
                        if (typeNumber != null) {
                            fieldReader.accept(object, typeNumber);
                        } else {
                            fieldReader.accept(object, typeName);
                        }
                    }
                    return object;
                }
            } else {
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.getFeatures())) {
                    long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                    fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
                }
                if (object == null) {
                    object = this.createInstance(jsonReader.getContext().getFeatures() | features);
                }
                if (fieldReader == null) {
                    this.processExtra(jsonReader, object);
                } else {
                    fieldReader.readFieldValue(jsonReader, object);
                }
            }
            ++i;
        }
        jsonReader.nextIfMatch(',');
        Function buildFunction = this.getBuildFunction();
        if (buildFunction != null) {
            object = buildFunction.apply(object);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }
}

