/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterUTF16;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;

public final class JSONWriterUTF16JDK8UF
extends JSONWriterUTF16 {
    JSONWriterUTF16JDK8UF(JSONWriter.Context ctx) {
        super(ctx);
    }

    @Override
    public void writeString(String str) {
        if (str == null) {
            this.writeStringNull();
            return;
        }
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        char[] value = (char[])UnsafeUtils.UNSAFE.getObject(str, JDKUtils.FIELD_STRING_VALUE_OFFSET);
        int strlen = value.length;
        boolean escape = false;
        for (int i = 0; i < strlen; ++i) {
            char c0 = value[i];
            if (c0 != this.quote && c0 != '\\' && c0 >= ' ' && (!browserSecure || c0 != '<' && c0 != '>' && c0 != '(' && c0 != ')') && (!escapeNoneAscii || c0 <= '\u007f')) continue;
            escape = true;
            break;
        }
        if (!escape) {
            int off = this.off;
            int minCapacity = off + strlen + 2;
            if (minCapacity >= this.chars.length) {
                this.ensureCapacity(minCapacity);
            }
            char[] chars = this.chars;
            chars[off++] = this.quote;
            System.arraycopy(value, 0, chars, off, value.length);
            chars[off += strlen] = this.quote;
            this.off = off + 1;
            return;
        }
        this.writeStringEscape(str);
    }
}

