/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathCompilerReflect;
import com.alibaba.fastjson2.JSONPathCompilerReflectASM;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;

public final class JSONFactory {
    static volatile Throwable initErrorLast;
    public static final String CREATOR;
    public static final String PROPERTY_DENY_PROPERTY = "fastjson2.parser.deny";
    public static final String PROPERTY_AUTO_TYPE_ACCEPT = "fastjson2.autoTypeAccept";
    public static final String PROPERTY_AUTO_TYPE_HANDLER = "fastjson2.autoTypeHandler";
    public static final String PROPERTY_AUTO_TYPE_BEFORE_HANDLER = "fastjson2.autoTypeBeforeHandler";
    public static final boolean MIXED_HASH_ALGORITHM;
    protected static boolean useJacksonAnnotation;
    static long defaultReaderFeatures;
    static String defaultReaderFormat;
    static long defaultWriterFeatures;
    static String defaultWriterFormat;
    static Supplier<Map> defaultObjectSupplier;
    static Supplier<List> defaultArraySupplier;
    static final NameCacheEntry[] NAME_CACHE;
    static final NameCacheEntry2[] NAME_CACHE2;
    static final Function<JSONWriter.Context, JSONWriter> INCUBATOR_VECTOR_WRITER_CREATOR_UTF8;
    static final Function<JSONWriter.Context, JSONWriter> INCUBATOR_VECTOR_WRITER_CREATOR_UTF16;
    static final JSONReaderUTF8Creator INCUBATOR_VECTOR_READER_CREATOR_ASCII;
    static final JSONReaderUTF8Creator INCUBATOR_VECTOR_READER_CREATOR_UTF8;
    static final JSONReaderUTF16Creator INCUBATOR_VECTOR_READER_CREATOR_UTF16;
    static final BigDecimal LOW;
    static final BigDecimal HIGH;
    static final BigInteger LOW_BIGINT;
    static final BigInteger HIGH_BIGINT;
    static final char[] CA;
    static final int[] DIGITS2;
    static final float[] FLOAT_10_POW;
    static final double[] DOUBLE_10_POW;
    static final Double DOUBLE_ZERO;
    static final CacheItem[] CACHE_ITEMS;
    static final int CACHE_THRESHOLD = 0x100000;
    static final AtomicReferenceFieldUpdater<CacheItem, char[]> CHARS_UPDATER;
    static final AtomicReferenceFieldUpdater<CacheItem, byte[]> BYTES_UPDATER;
    static final Properties DEFAULT_PROPERTIES;
    static ObjectWriterProvider defaultObjectWriterProvider;
    static ObjectReaderProvider defaultObjectReaderProvider;
    static final JSONPathCompiler defaultJSONPathCompiler;
    static final ThreadLocal<ObjectReaderCreator> readerCreatorLocal;
    static final ThreadLocal<ObjectReaderProvider> readerProviderLocal;
    static final ThreadLocal<ObjectWriterCreator> writerCreatorLocal;
    static final ThreadLocal<JSONPathCompiler> jsonPathCompilerLocal;
    static final ObjectReader<JSONArray> ARRAY_READER;
    static final ObjectReader<JSONObject> OBJECT_READER;
    static final char[] UUID_LOOKUP;
    static final byte[] UUID_VALUES;

    public static String getProperty(String key) {
        return DEFAULT_PROPERTIES.getProperty(key);
    }

    public static boolean isUseJacksonAnnotation() {
        return useJacksonAnnotation;
    }

    public static void setUseJacksonAnnotation(boolean useJacksonAnnotation) {
        JSONFactory.useJacksonAnnotation = useJacksonAnnotation;
    }

    public static void setDefaultObjectSupplier(Supplier<Map> objectSupplier) {
        defaultObjectSupplier = objectSupplier;
    }

    public static void setDefaultArraySupplier(Supplier<List> arraySupplier) {
        defaultArraySupplier = arraySupplier;
    }

    public static Supplier<Map> getDefaultObjectSupplier() {
        return defaultObjectSupplier;
    }

    public static Supplier<List> getDefaultArraySupplier() {
        return defaultArraySupplier;
    }

    public static JSONWriter.Context createWriteContext() {
        return new JSONWriter.Context(defaultObjectWriterProvider);
    }

    public static JSONWriter.Context createWriteContext(ObjectWriterProvider provider, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(provider);
        context.config(features);
        return context;
    }

    public static JSONWriter.Context createWriteContext(JSONWriter.Feature ... features) {
        return new JSONWriter.Context(defaultObjectWriterProvider, features);
    }

    public static JSONReader.Context createReadContext() {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        return new JSONReader.Context(provider);
    }

    public static JSONReader.Context createReadContext(long features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        return new JSONReader.Context(provider, features);
    }

    public static JSONReader.Context createReadContext(JSONReader.Feature ... features) {
        JSONReader.Context context = new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider());
        context.config(features);
        return context;
    }

    public static JSONReader.Context createReadContext(ObjectReaderProvider provider, JSONReader.Feature ... features) {
        if (provider == null) {
            provider = JSONFactory.getDefaultObjectReaderProvider();
        }
        JSONReader.Context context = new JSONReader.Context(provider);
        context.config(features);
        return context;
    }

    public static JSONReader.Context createReadContext(SymbolTable symbolTable) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        return new JSONReader.Context(provider, symbolTable);
    }

    public static JSONReader.Context createReadContext(SymbolTable symbolTable, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, symbolTable);
        context.config(features);
        return context;
    }

    public static JSONReader.Context createReadContext(Supplier<Map> objectSupplier, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        context.setObjectSupplier(objectSupplier);
        context.config(features);
        return context;
    }

    public static JSONReader.Context createReadContext(Supplier<Map> objectSupplier, Supplier<List> arraySupplier, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        context.setObjectSupplier(objectSupplier);
        context.setArraySupplier(arraySupplier);
        context.config(features);
        return context;
    }

    public static ObjectWriterProvider getDefaultObjectWriterProvider() {
        return defaultObjectWriterProvider;
    }

    public static ObjectReaderProvider getDefaultObjectReaderProvider() {
        ObjectReaderProvider providerLocal = readerProviderLocal.get();
        if (providerLocal != null) {
            return providerLocal;
        }
        return defaultObjectReaderProvider;
    }

    public static JSONPathCompiler getDefaultJSONPathCompiler() {
        JSONPathCompiler compilerLocal = jsonPathCompilerLocal.get();
        if (compilerLocal != null) {
            return compilerLocal;
        }
        return defaultJSONPathCompiler;
    }

    public static void setContextReaderCreator(ObjectReaderCreator creator) {
        readerCreatorLocal.set(creator);
    }

    public static void setContextObjectReaderProvider(ObjectReaderProvider creator) {
        readerProviderLocal.set(creator);
    }

    public static ObjectReaderCreator getContextReaderCreator() {
        return readerCreatorLocal.get();
    }

    public static void setContextJSONPathCompiler(JSONPathCompiler compiler) {
        jsonPathCompilerLocal.set(compiler);
    }

    public static void setContextWriterCreator(ObjectWriterCreator creator) {
        writerCreatorLocal.set(creator);
    }

    public static ObjectWriterCreator getContextWriterCreator() {
        return writerCreatorLocal.get();
    }

    static {
        int c;
        NAME_CACHE = new NameCacheEntry[8192];
        NAME_CACHE2 = new NameCacheEntry2[8192];
        LOW = BigDecimal.valueOf(-9007199254740991L);
        HIGH = BigDecimal.valueOf(0x1FFFFFFFFFFFFFL);
        LOW_BIGINT = BigInteger.valueOf(-9007199254740991L);
        HIGH_BIGINT = BigInteger.valueOf(0x1FFFFFFFFFFFFFL);
        CA = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        DIGITS2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15};
        FLOAT_10_POW = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
        DOUBLE_10_POW = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
        DOUBLE_ZERO = 0.0;
        Properties properties = new Properties();
        InputStream inputStream = AccessController.doPrivileged(() -> {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String resourceFile = "fastjson2.properties";
            if (cl != null) {
                return cl.getResourceAsStream("fastjson2.properties");
            }
            return ClassLoader.getSystemResourceAsStream("fastjson2.properties");
        });
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.close(inputStream);
            }
        }
        DEFAULT_PROPERTIES = properties;
        String property = System.getProperty("fastjson2.creator");
        if (property != null) {
            property = property.trim();
        }
        if ((property == null || property.isEmpty()) && (property = properties.getProperty("fastjson2.creator")) != null) {
            property = property.trim();
        }
        CREATOR = property == null ? "asm" : property;
        property = System.getProperty("fastjson2.hash-algorithm");
        if (property != null) {
            property = property.trim();
        }
        if ((property == null || property.isEmpty()) && (property = properties.getProperty("fastjson2.hash-algorithm")) != null) {
            property = property.trim();
        }
        MIXED_HASH_ALGORITHM = "mixed".equals(property) ? true : JDKUtils.JVM_VERSION > 8;
        property = System.getProperty("fastjson2.useJacksonAnnotation");
        if (property != null) {
            property = property.trim();
        }
        if ((property == null || property.isEmpty()) && (property = properties.getProperty("fastjson2.useJacksonAnnotation")) != null) {
            property = property.trim();
        }
        useJacksonAnnotation = !"false".equals(property);
        int readerVector = 0;
        String property2 = System.getProperty("fastjson2.readerVector");
        if (property2 != null) {
            if (((property2 = property2.trim()) == null || property2.isEmpty()) && (property2 = properties.getProperty("fastjson2.readerVector")) != null) {
                property2 = property2.trim();
            }
            readerVector = !"false".equals(property2) ? 1 : 0;
        }
        Function incubatorVectorCreatorUTF8 = null;
        Function incubatorVectorCreatorUTF16 = null;
        JSONReaderUTF8Creator readerCreatorASCII = null;
        JSONReaderUTF8Creator readerCreatorUTF8 = null;
        JSONReaderUTF16Creator readerCreatorUTF16 = null;
        if (JDKUtils.VECTOR_SUPPORT) {
            Class<?> factoryClass;
            if (JDKUtils.VECTOR_BIT_LENGTH >= 64) {
                try {
                    factoryClass = Class.forName("com.alibaba.fastjson2.JSONWriterUTF8Vector$Factory");
                    incubatorVectorCreatorUTF8 = (Function)factoryClass.newInstance();
                }
                catch (Throwable ignored) {
                    initErrorLast = ignored;
                }
                try {
                    factoryClass = Class.forName("com.alibaba.fastjson2.JSONWriterUTF16Vector$Factory");
                    incubatorVectorCreatorUTF16 = (Function)factoryClass.newInstance();
                }
                catch (Throwable ignored) {
                    initErrorLast = ignored;
                }
                if (readerVector != 0) {
                    try {
                        factoryClass = Class.forName("com.alibaba.fastjson2.JSONReaderASCIIVector$Factory");
                        readerCreatorASCII = (JSONReaderUTF8Creator)factoryClass.newInstance();
                    }
                    catch (Throwable ignored) {
                        initErrorLast = ignored;
                    }
                    try {
                        factoryClass = Class.forName("com.alibaba.fastjson2.JSONReaderUTF8Vector$Factory");
                        readerCreatorUTF8 = (JSONReaderUTF8Creator)factoryClass.newInstance();
                    }
                    catch (Throwable ignored) {
                        initErrorLast = ignored;
                    }
                }
            }
            if (JDKUtils.VECTOR_BIT_LENGTH >= 128 && readerVector != 0) {
                try {
                    factoryClass = Class.forName("com.alibaba.fastjson2.JSONReaderUTF16Vector$Factory");
                    readerCreatorUTF16 = (JSONReaderUTF16Creator)factoryClass.newInstance();
                }
                catch (Throwable ignored) {
                    initErrorLast = ignored;
                }
            }
        }
        INCUBATOR_VECTOR_WRITER_CREATOR_UTF8 = incubatorVectorCreatorUTF8;
        INCUBATOR_VECTOR_WRITER_CREATOR_UTF16 = incubatorVectorCreatorUTF16;
        INCUBATOR_VECTOR_READER_CREATOR_ASCII = readerCreatorASCII;
        INCUBATOR_VECTOR_READER_CREATOR_UTF8 = readerCreatorUTF8;
        INCUBATOR_VECTOR_READER_CREATOR_UTF16 = readerCreatorUTF16;
        CacheItem[] items = new CacheItem[16];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new CacheItem();
        }
        CACHE_ITEMS = items;
        CHARS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CacheItem.class, char[].class, "chars");
        BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CacheItem.class, byte[].class, "bytes");
        defaultObjectWriterProvider = new ObjectWriterProvider();
        defaultObjectReaderProvider = new ObjectReaderProvider();
        JSONPathCompilerReflect compiler = null;
        switch (CREATOR) {
            case "reflect": 
            case "lambda": {
                compiler = JSONPathCompilerReflect.INSTANCE;
                break;
            }
            default: {
                try {
                    if (!JDKUtils.ANDROID && !JDKUtils.GRAAL) {
                        compiler = JSONPathCompilerReflectASM.INSTANCE;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (compiler != null) break;
                compiler = JSONPathCompilerReflect.INSTANCE;
            }
        }
        defaultJSONPathCompiler = compiler;
        readerCreatorLocal = new ThreadLocal();
        readerProviderLocal = new ThreadLocal();
        writerCreatorLocal = new ThreadLocal();
        jsonPathCompilerLocal = new ThreadLocal();
        ARRAY_READER = JSONFactory.getDefaultObjectReaderProvider().getObjectReader((Type)((Object)JSONArray.class));
        OBJECT_READER = JSONFactory.getDefaultObjectReaderProvider().getObjectReader((Type)((Object)JSONObject.class));
        UUID_LOOKUP = new char[256];
        UUID_VALUES = new byte[55];
        for (int i = 0; i < 256; ++i) {
            int hi = i >> 4 & 0xF;
            int lo = i & 0xF;
            JSONFactory.UUID_LOOKUP[i] = (char)(((hi < 10 ? 48 + hi : 97 + hi - 10) << 8) + (lo < 10 ? 48 + lo : 97 + lo - 10));
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            JSONFactory.UUID_VALUES[c - 48] = (byte)(c - 48);
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            JSONFactory.UUID_VALUES[c - 48] = (byte)(c - 97 + 10);
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            JSONFactory.UUID_VALUES[c - 48] = (byte)(c - 65 + 10);
        }
    }

    public static interface JSONPathCompiler {
        public JSONPath compile(Class var1, JSONPath var2);
    }

    static final class NameCacheEntry {
        final String name;
        final long value;

        public NameCacheEntry(String name, long value) {
            this.name = name;
            this.value = value;
        }
    }

    static final class NameCacheEntry2 {
        final String name;
        final long value0;
        final long value1;

        public NameCacheEntry2(String name, long value0, long value1) {
            this.name = name;
            this.value0 = value0;
            this.value1 = value1;
        }
    }

    static interface JSONReaderUTF8Creator {
        public JSONReader create(JSONReader.Context var1, String var2, byte[] var3, int var4, int var5);
    }

    static interface JSONReaderUTF16Creator {
        public JSONReader create(JSONReader.Context var1, String var2, char[] var3, int var4, int var5);
    }

    static final class CacheItem {
        volatile char[] chars;
        volatile byte[] bytes;

        CacheItem() {
        }
    }
}

