# top {#top}

The top clause is used to specify the number of records to return. Specify a scalar after the keyword to select the first *N* number of records, or specify a range \(with exclusive lower bound\) to select the records within the range. Note that the first row is at index 0, not index 1.

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

## Examples {#emp_top}

```
sym = `C`MS`MS`MS`IBM`IBM`C`C`C$SYMBOL
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800
timestamp = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12]
t1 = table(timestamp, sym, qty, price);

t1;
```

```
select top 3 * from t1;
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:34:07|C|2200|49.6|
|09:36:42|MS|1900|29.46|
|09:36:51|MS|2100|29.52|

```
select top 2:4 * from t1;
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:36:51|MS|2100|29.52|
|09:36:59|MS|3200|30.02|

The scalar or range specified in the \#\# top clause must be an integer\(s\). Variables or expressions are not supported.

```
x=2;
select top x * from t1;
// Syntax Error: [line #2] integer constant expected after keyword top
```

```
select top (1+2) * from t1;
// Syntax Error: [line #1] integer constant expected after keyword top
```

The top clause cannot be used with the `pivot by` clause. It can be used with the `group by` clause or the `context by` clause \(see [context by](contextBy.md)\).

