# nullIf {#nullif}

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

## Syntax {#syntax}

nullIf\(X, Y\)

## Arguments {#arguments}

**X**/**Y** can be a scalar or vector, or an expression that returns a scalar or vector.

## Details {#details}

-   For two scalars, the function returns a null value if the values and data types of *X* and *Y* are equal. Otherwise, returns *X*.

-   For two vectors of equal length, the function conducts the aforementioned calculation with each pair of elements in *X* and *Y* at the same position.

-   For a scalar and a vector, the function conducts the aforementioned calculation on the scalar and each element of the vector.


## Examples {#examples}

```python
t = table(`APPL`IBM`AMZN`IBM`APPL`AMZN as sym, 10.1 11.2 11.3 12 10.6 10.8 as val)
select nullIf(sym, `AMZN) from t
```

|nullIf\_sym|
|-----------|
|APPL|
|IBM|
||
|IBM|
|APPL|
| |

```python
select * from t where nullIf(sym, `AMZN)!=NULL
```

|sym|val|
|---|---|
|APPL|10.1|
|IBM|11.2|
|IBM|12|
|APPL|10.6|

