# notBetween/NOTBETWEEN {#notbetween_notbetween}

The NOTBETWEEN...AND is the inverse operation of between...and, used to select values outside a given range \(including the start and end values\). It is equivalent to function [notBetween](../../Functions/n/notbetween.md) and predicate NOT BETWEEN.

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

## Syntax {#topic_odt_321_d2c}

``` {#codeblock_qj2_m21_d2c}
select col(s)
from table
where col notBetween value1 and value2
```

## Arguments {#topic_yb2_j21_d2c}

**col\(s\)** is column name\(s\) to select. It can be one or more column names or `*` \(indicating all columns\).

**table** is the table name to query.

**col** is the column to be filtered.

**value1, value2** is any valid expression.*value1* indicates the starting value, and *value2* indicates the ending value. *value1*, *value2* and *col* must have the same data type.

## Examples {#topic_i1j_l21_d2c}

Query records where the price column values are not between 2 and 4:

``` {#codeblock_mbf_w21_d2c}
timeCols = 2024.11.14+1..6
symCols = `APPL`AMZN`IBM`IBM`AAPL`AMZN
priceCols = 1.8 2.3 3.7 3.1 4.2 2.8

t = table(timeCols as time, symCols as sym, priceCols as price);
select * from t where price notBetween 2 and 4

// equivalent to select * from t where price notBetween 2:4
// equivalent to select * from t where price not between 2 and 4
```

|time|sym|price|
|----|---|-----|
|2024.11.15|APPL|1.8|
|2024.11.19|AAPL|4.2|

Query all records where the date in the time column is not between 2024.11.16 and 2024.11.18.

``` {#codeblock_y2j_x21_d2c}
select * from t where time notBetween 2024.11.16 and 2024.11.18
```

|time|sym|price|
|----|---|-----|
|2024.11.15|APPL|1.8|
|2024.11.19|AAPL|4.2|
|2024.11.20|AMZN|2.8|

