# limit {#limit}

DolphinDB supports the limit clause to select a limited number of records. The limit clause can use either integers or variables representing integers.

The limit clause is similar to the top clause with the following differences:

-   The top clause cannot use negative intergers. When used with the context by clause, the limit clause can use a negative integer to select a limited number of records in the end of each group. In all other cases the limit clause can only use positive integers.
-   The limit clause can select a limited number of rows starting from a specified row.

```
sym = `C`MS`MS`MS`IBM`IBM`C`C`C$SYMBOL
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800
timestamp = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12]
t = table(timestamp, sym, qty, price);
t;
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:34:07|C|2200|49.6|
|09:36:42|MS|1900|29.46|
|09:36:51|MS|2100|29.52|
|09:36:59|MS|3200|30.02|
|09:32:47|IBM|6800|174.97|
|09:35:26|IBM|5400|175.23|
|09:34:16|C|1300|50.76|
|09:34:26|C|2500|50.32|
|09:38:12|C|8800|51.2|

```
select * from t limit 2;
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:34:07|C|2200|49.6|
|09:36:42|MS|1900|29.46|

```
select * from t limit 2, 5;
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:36:51|MS|2100|29.52|
|09:36:59|MS|3200|30.02|
|09:32:47|IBM|6800|174.97|
|09:35:26|IBM|5400|175.23|
|09:34:16|C|1300|50.76|

```
rowOffset = 2
rowCount = 5
select * from t limit rowOffset, rowCount;
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:36:51|MS|2100|29.52|
|09:36:59|MS|3200|30.02|
|09:32:47|IBM|6800|174.97|
|09:35:26|IBM|5400|175.23|
|09:34:16|C|1300|50.76|

```
select * from t context by sym order by qty limit -1;
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:36:59|MS|3200|30.02|
|09:35:26|IBM|5400|175.23|
|09:38:12|C|8800|51.29|

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

