# insert into {#insert-into}

Insert new records to a table.

Note: To insert values into DFS tables, please configure *enableInsertStatementForDFSTable*=true.

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

## Syntax {#syntax}

```
insert into
  table_name1
  values (X, [Y, ...]) | select col_name(s) from table_name2
```

## Examples {#examples}

```
t=table(`XOM`GS`FB as ticker, 100 80 120 as volume);
t;
```

|ticker|volume|
|------|------|
|XOM|100|
|GS|80|
|FB|120|

```
insert into t values(`GOOG, 200);
t;
```

|ticker|volume|
|------|------|
|XOM|100|
|GS|80|
|FB|120|
|GOOG|200|

```
insert into t values(`AMZN`NFLX, 300 250);
t;
```

|ticker|volume|
|------|------|
|XOM|100|
|GS|80|
|FB|120|
|GOOG|200|
|AMZN|300|
|NFLX|250|

```
insert into t values(('AMD','NVDA'), (60 400));
t;
```

|ticker|volume|
|------|------|
|XOM|100|
|GS|80|
|FB|120|
|GOOG|200|
|AMZN|300|
|NFLX|250|
|AMD|60|
|NVDA|400|

The above code example can also be written in a way that follows the ANSI SQL standard for inserting multiple rows into the table directly. This alternative approach yields the same result.

``` {#codeblock_ugf_1vr_zbc}
insert into t values ('AMD', 60), ('NVDA', 400);
t;
```

|ticker|volume|
|:-----|:-----|
|XOM|100|
|GS|80|
|FB|120|
|GOOG|200|
|AMZN|300|
|NFLX|250|
|AMD|60|
|NVDA|400|

To only insert values for a subset of columns:

```
insert into t(ticker, volume) values(`UBER`LYFT, 0 0);
t;
```

|ticker|price|volume|
|------|-----|------|
|XOM|98.5|100|
|GS|12.3|80|
|FB|40.6|120|
|GOOG|100.6|200|
|AMZN|120|300|
|NFLX|56.6|250|
|AMD|78.6|60|
|NVDA|33.1|400|
|UBER||0|
|LYFT||0|

