# Hints {#hints}

A hint is an addition to the SQL standard that instructs the database engine on how to execute the query. Hints can be uesd to improve performance by forcing the optimizer to use a more efficient plan.

The following list demonstrates HINT keywords supported by DolphinDB.

|Keyword|flag|Description|Example|
|-------|----|-----------|-------|
|\[HINT\_LOCAL\]|\[1\]|Obtains only the calculation results on the local nodes in a distributed cluster.|select \[HINT\_LOCAL\] sum\(\*\) from pt|
|\[HINT\_HASH\]|\[32\]|Groups data with the hash algorithm by default when performing `group by`.|select \[HINT\_HASH\] count\(\*\) from t group by sym|
|\[HINT\_SNAPSHOT\]|\[64\]|Queries data from a DFS table with a snapshot engine registered with `registerSnapshotEngine`.|select \[HINT\_SNAPSHOT\] \* from loadTable\(dbName,tableName\)|
|\[HINT\_KEEPORDER\]|\[128\]|Keeps the order of output records consistent with the input for each `context by` group.|select \[HINT\_KEEPORDER\] cumsu\(vol\) from t context by date, sym|
|\[HINT\_SEQ\]|\[512\]|Executes queries on partitions serially to save the concurrency overhead when memory is limited.|timer select \[HINT\_SEQ\] avg\(vol\) from t|
|\[HINT\_NOMERGE\]|\[1024\]|Skips the merge step of intermediate results from map clause. Instead of returning the merged results in an in-memory table, only the handles of DFS tables are returned.|select \[HINT\_NOMERGE\] price from pt context by ticker|
|\[HINT\_PRELOAD\]|\[4096\]|\[TSDB only\] Loads all data into memory before filtering with where-conditions.|select \[HINT\_PRELOAD\] sum\(price\) from t where volume &gt; 100000|
|\[HINT\_EXPLAIN\]|\[32768\]|Prints the query execution plan to monitor the real-time performance and execution order of a SQL query for SQL performance tuning.|select \[HINT\_EXPLAIN\] \* from tb where id &gt; 20|
|\[HINT\_SORT\]|\[524288\]|Uses sorting algorithm for data grouping during `group by` operations.|select \[HINT\_SORT\] avg\(price\) from trades group by sym|
|\[HINT\_VECTORIZED\]|\[4194304\]|Uses vectorization for data grouping during `group by` operations.|select \[HINT\_VECTORIZED\] sum\(price\) from trades group by sym|

-   **[\[HINT\_EXPLAIN\]](../../../Programming/SQLStatements/hint/hint_explain.md)**  


**Parent topic:**[SQL Reference](../../../Programming/SQLStatements/SQLStatement.md)

