# between {#between}

The `between` operator selects values within a given range where begin and end values are included. It is used with keyword and, which is equivalent to the function [between](../../Functions/b/between.md).

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

## Syntax {#syntax}

```
select col(s)
from table
where col [not] between value1 and value2
```

## Examples {#examples}

```
t = table(`APPL`AMZN`IBM`IBM`AAPL`AMZN as sym, 1.8 2.3 3.7 3.1 4.2 2.8 as price);
select * from t where price between 2 and 4
// equivalent to `select * from t where price between 2:4`
```

|sym|price|
|---|-----|
|AMZN|2.3|
|IBM|3.7|
|IBM|3.1|
|AMZN|2.8|

```

    
    $ select * from t where sym between `A and `H
```

|sym|price|
|---|-----|
|APPL|1.8|
|AMZN|2.3|
|APPL|4.2|
|AMZN|2.8|

