# any/all {#anyall}

The `any` and `all` operators are used with `where` or `having`.

```python
where/having col optr any(sub_query)
where/having col optr all(sub_query)
```

where *optr* is a comparison operator, and *sub\_query* is a SQL query or a vector.

The any and all keywords allow you to perform a comparison between an operand \(i.e., a single column value\) and a range of other values:

-   `any`: Returns true if any of the subqueries values meet the condition, otherwise false.

-   `all`: Returns true if all of the subqueries values meet the condition, otherwise false.


Note:

-   "=any" is equivalent to "in", and "= all" is equivalent to "!= any";

-   The SQL operator `any`/`all` is similar to DolphinDB's built-in function `any`/`all`. See the difference from the following examples:


SQL `any` keyword:

```
x > any([n1,n2,n3]) 
```

`any` function:

```
any([x>n1, x>n2, x>n3])
```

**Examples**

```python
sym = `C`MS`MS`MS`IBM`IBM`C`C`C$SYMBOL
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800
timestamp = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12]
t1 = table(timestamp, sym, qty, price);
t2 = table(`C`MS`IBM as sym, 1 0 1 as flag)

select * from t1 where sym = any(select sym from t2 where flag=1)
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:34:07|C|2,200|49.6|
|09:32:47|IBM|6,800|174.97|
|09:35:26|IBM|5,400|175.23|
|09:34:16|C|1,300|50.76|
|09:34:26|C|2,500|50.32|
|09:38:12|C|8,800|51.29|

```
select * from t1 where sym != all(select sym from t2 where flag = 1)
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:36:42|MS|1,900|29.46|
|09:36:51|MS|2,100|29.52|
|09:36:59|MS|3,200|30.02|

```
t3 = select wavg(price, qty) as wavg from t1 group by sym
select * from t1 where price >= all(select wavg from t3)
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:35:26|IBM|5,400|175.23|

```
select * from t1 where price >= any(select wavg from t3)
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:34:07|C|2,200|49.6|
|09:36:59|MS|3,200|30.02|
|09:32:47|IBM|6,800|174.97|
|09:35:26|IBM|5,400|175.23|
|09:34:16|C|1,300|50.76|
|09:34:26|C|2,500|50.32|
|09:38:12|C|8,800|51.29|

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

