# alter {#alter}

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

## Syntax {#syntax}

```
alter table tableObj add columnName columnType;
alter table tableObj drop [column] columnName;
alter table tableObj rename [column] columnName to newColumnName;
```

## Arguments {#arguments}

**tableObj** can be an in-memory table, a stream table, a DFS table, or a dimension table.

**colNames** is a string scalar indicating the name of the column to be added.

**newColNames** is a string scalar indicating the name of the column to be modified.

**colTypes** is a scalar indicating the data type of the column.

## Details {#details}

The `alter` statement is used to add, delete or rename columns to an existing table.Note that the TSDB engine only supports the add operation.

## Examples {#examples}

```
if(existsDatabase("dfs://test")) dropDatabase("dfs://test")
create database "dfs://test" partitioned by VALUE(1..10), HASH([SYMBOL, 40]), engine='OLAP', atomic='TRANS', chunkGranularity='TABLE'

create table "dfs://test"."pt"(
    id INT,
    deviceId SYMBOL,
    date DATE[comment="time_col", compress="delta"],
    value DOUBLE,
     isFin BOOL
)
partitioned by ID, deviceID

pt = loadTable("dfs://test", `pt)
alter table pt add location SYMBOL;
pt = loadTable("dfs://test", `pt)
pt.schema().colDefs
```

|name|typeString|typeInt|extra|comment|
|----|----------|-------|-----|-------|
|id|INT|4|||
|deviceId|SYMBOL|17|||
|date|DATE|6||time\_col|
|value|DOUBLE|16|||
|isFin|BOOL|1|||
|location|SYMBOL|17|||

```
alter table pt rename location to loc
pt = loadTable("dfs://test", `pt)
pt.schema().colDefs
```

|name|typeString|typeInt|extra|comment|
|----|----------|-------|-----|-------|
|id|INT|4|||
|deviceId|SYMBOL|17|||
|date|DATE|6||time\_col|
|value|DOUBLE|16|||
|isFin|BOOL|1|||
|loc|SYMBOL|17|||

```
alter table pt drop value
pt = loadTable("dfs://test", `pt)
pt.schema().colDefs
```

|name|typeString|typeInt|extra|comment|
|----|----------|-------|-----|-------|
|id|INT|4|||
|deviceId|SYMBOL|17|||
|date|DATE|6||time\_col|
|isFin|BOOL|1|||
|loc|SYMBOL|17|||

Related functions: [addColumn](../../Functions/a/addColumn.md), [dropColumns!](../../Functions/d/dropColumns!.md), [rename!](../../Functions/r/rename!.md).

