# cross join {#cross-join}

**Parent topic:**[Table joiners](../../../Programming/SQLStatements/TableJoiners/TableJoiners.md)

## Syntax {#syntax}

```
cj(leftTable, rightTable)
```

## Arguments {#arguments}

**leftTable** and **rightTable** are the tables to be joined.

## SQL-compatible cross join {#sql-compatible-cross-join}

```
select column_name(s)
from leftTable cross join rightTable
```

## Details {#details}

Return the Cartesian product of two tables. If the left table has n rows and the right table has m rows, then the cross join function returns n\*m rows.

## Examples {#examples}

```
a = table(2010 2011 2012 as year)
b = table(`IBM`C`AAPL as Ticker);
a;
```

|year|
|----|
|2010|
|2011|
|2012|

```
b;
```

|Ticker|
|------|
|IBM|
|C|
|AAPL|

```
cj(a,b);
```

|year|Ticker|
|----|------|
|2010|IBM|
|2010|C|
|2010|AAPL|
|2011|IBM|
|2011|C|
|2011|AAPL|
|2012|IBM|
|2012|C|
|2012|AAPL|

```
select * from cj(a,b) where year>2010;
// equivalent to `select * from a cross join b where year>2010`
```

|year|Ticker|
|----|------|
|2011|IBM|
|2011|C|
|2011|AAPL|
|2012|IBM|
|2012|C|
|2012|AAPL|

In contrast, [join](../../Operators/OperatorReferences/join.md) simply merges two tables' columns

```
join(a,b);
```

|year|Ticker|
|----|------|
|2010|IBM|
|2011|C|
|2012|AAPL|

